/* errnoULib.c - dummy error status library for UNIX */

static char *copyright = "Copyright 1984-1988, Wind River Systems, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
This library contains dummy versions of the routines in errnoLib.c.  It is
meant to be used under UNIX, when required by modules which are used both
under UniWorks and under UNIX.

SEE ALSO: errnoLib (1)
*/

#include "UniWorks.h"

LOCAL int errorStatus;

/*******************************************************************************
*
* errnoGet - get error status value of calling task
*/

int errnoGet ()

    {
    return (errorStatus);
    }
/*******************************************************************************
*
* errnoOfTaskGet - get error status value of specified task
*
* RETURNS: status value for given task, or ERROR if task doesn't exist.
*
* ARGSUSED
*/

int errnoOfTaskGet (tid)
    int tid;			/* task's id, 0 means current task */

    {
    return (errorStatus);
    }
/*******************************************************************************
*
* errnoSet - set error status value of calling task
*/

VOID errnoSet (errno)
    int errno;			/* error status value */

    {
    errorStatus = errno;
    }
