/* Bad 144 routines - badstrat and badinit */

static char *copyright = "Copyright 1988, Integrated Solutions, Inc.";

/*
modification history
--------------------
*/

/*
DESCRIPTION
*/

#include "UniWorks.h"
#include "rtLib.h"
#include "buf.h"
#include "dkbad.h"
#include "qbvar.h"

/*#define BAD144DEBUG	1 /**/

#define DEV_BSIZE	512
#define DEV_BSHIFT	9

/************************************************************************
*
* badstrat - Check the bad sector map 
*
*/

VOID badstrat (qi, bp, bbp, bad, strat, nspt, ntpc, ncpd, coff)
	struct qb_device *qi;		/* device struct */
	struct buf *bp;			/* buf for I/O transfer stuff */
	struct buf *bbp;		/* buf for I/O transfer stuff */
	struct dkbad *bad;		/* contains bad sector map info */
	int (*strat)();			/* I/O strategy routine */
	USHORT nspt, ntpc, ncpd, coff;
{
	int s, hadbad = 0, len = bp->b_bcount, error;
	UINT blkno;
	int i, hi, lo;
	int sbn = bp->b_blkno;
	int lbn = sbn + ((len+(DEV_BSIZE-1)) >> DEV_BSHIFT) - 1;
	int bbn, nbs;

#define SAVE_BFLAGS	(B_WRITE|B_READ|B_BUSY|B_PHYS|B_AGE|B_DELWRI| \
			B_TAPE|B_UAREA|B_PAGET|B_DIRTY|B_PGIN|B_CACHE| \
			B_INVAL|B_LOCKED|B_HEAD|B_BAD)


	/* 
	 * Binary search the bad sector map for remapped sectors 
	 */

	if (bad->bt_csn == 1 && bad->bt_mbz) {
	    lo = 0;
	    while (sbn <= lbn) {
	    	hi = bad->bt_mbz-1;
		while ((hi - lo) > 1) {
			i = lo + (hi - lo)/2;
			if (bad->bt_bad[i].bt_bn == sbn)
				hi = lo = i;
			else if (bad->bt_bad[i].bt_bn < sbn)
				lo = i;
			else
				hi = i;
		}

		if (bad->bt_bad[lo].bt_bn >= sbn)
			hi = lo;
		bbn = bad->bt_bad[hi].bt_bn;

		if (!hadbad) {
			if (bbn < sbn || bbn > lbn) {
				goto done;		/* no remaps */
			}
			hadbad++;
			*bbp = *bp;
			bbp->b_flags &= SAVE_BFLAGS;
		}

		if (bbn < sbn || bbn > lbn) {	/* transfer from sbn to lbn */
		    bbp->b_blkno = sbn;
		    bbp->b_bcount = len;
		    bbp->b_flags &= SAVE_BFLAGS;
#ifdef BAD144DEBUG
		    printf("badstrat, calling strat with blkno=%d\n",
			bbp->b_blkno);
#endif BAD144DEBUG
		    (*strat)(qi, bbp);
		    len -= bbp->b_bcount-bbp->b_resid;
		    sbn = lbn+1;
		} else {
		    if (sbn < bbn) {	/* transfer from sbn to bad block bbn */
			    bbp->b_blkno = sbn;
			    bbp->b_bcount = min(len,(bbn - sbn) * 512);
			    bbp->b_flags &= SAVE_BFLAGS;
#ifdef BAD144DEBUG
		    printf("badstrat, calling strat with blkno=%d\n",
			bbp->b_blkno);
#endif BAD144DEBUG
			    (*strat)(qi, bbp);
			    bbp->b_addr += bbp->b_bcount;
			    len -= bbp->b_bcount-bbp->b_resid;
			    if (bbp->b_flags & B_ERROR)
				    break;
		    }

		    /* transfer remapped bbn */
		    bbp->b_blkno = ((ncpd*ntpc*nspt) - nspt - 1) - hi;
		    bbp->b_bcount = min(len, 512);
		    bbp->b_flags &= SAVE_BFLAGS;
#ifdef BAD144DEBUG
		    printf("badstrat, calling strat with blkno=%d\n",
			bbp->b_blkno);
#endif BAD144DEBUG
		    (*strat)(qi, bbp);
		    bbp->b_addr += bbp->b_bcount;
		    len -= bbp->b_bcount-bbp->b_resid;
		    sbn = bbn+1;
		}
		if (bbp->b_flags & B_ERROR)
			break;
	    }
	    bp->b_resid = len;
	    if (bbp->b_flags & B_ERROR) {
		    bp->b_flags |= B_ERROR;
	    }
	    bbp->b_flags = 0;
	    return;
	}
#ifdef BAD144DEBUG
    printf("badstrat, calling strat with blkno=%d\n",
	bp->b_blkno);
#endif BAD144DEBUG
done:	(*strat)(qi, bp);
}

/************************************************************************
*
* badinit - Read in bad sector map
*
*/

VOID badinit (qi, bbp, bad, strat, nspt, ntpc, ncpd)
	struct qb_device *qi;		/* pointer to device struct */
	struct buf *bbp;		/* a buffer for I/O transfer */
	struct dkbad *bad;		/* bad struct to put the map into */
	int (*strat) ();
	USHORT nspt, ntpc, ncpd;
{
	int i, error;
	UINT blkno;
	register int nbs;

#ifdef BAD144DEBUG
	logMsg("badinit, &qi=0x%x, &bbp=0x%x, &bad=0x%x, nspt=%d, ntpc=%d, ncpd=%d\n",
		qi, bbp, bad, nspt, ntpc, ncpd);
#endif BAD144DEBUG

	/*
	 * Read in the bad sector map
	 */

	nbs = 0;
	bbp->b_flags = B_READ;
	bbp->b_bcount = sizeof (struct dkbad);
	bbp->b_addr = (UINT) bad;
    	bbp->b_blkno = blkno = ncpd * nspt * ntpc - nspt;
   	(*strat)(qi, bbp);

    	error = bbp->b_flags & B_ERROR;
    	bbp->b_flags = 0;

    	if (error) {
	    	printf("%.3s: cannot read bad sector map\n", &(qi->name)[1]);
	    	bad->bt_csn = -1;
	    	goto initdone;	/* so we'll keep trying */
    	}

#ifdef	BAD144DEBUG
    	printf("%.3s: read bad144 map from block %d\n", &(qi->name)[1], blkno);

	printf("First 10 maps ...\n\n");
	for(i = 0; i < 10; i++) {
		printf("map %d cyl=%d trk=%d sec=%d\n",
			i,
			bad->bt_bad[i].bt_cyl,
			((bad->bt_bad[i].bt_trksec>>8)&0xff),
			(bad->bt_bad[i].bt_trksec&0xff)); 
	}

#endif	BAD144DEBUG

    	if (bad->bt_csn != 0) {
		for (i = 0; i < MAXBADBLK; i++) {
		    if (bad->bt_bad[i].bt_cyl == 0xFFFF) {
			bad->bt_bad[i].bt_bn = -1;
		    }
		    else if ((bad->bt_bad[i].bt_cyl > ncpd) ||
			(((bad->bt_bad[i].bt_trksec>>8)&0xff)>ntpc)||
			((bad->bt_bad[i].bt_trksec&0xff) > nspt) ) {
			    printf("%.3s: bad bad144 map\n", &(qi->name)[1]);
			    bad->bt_csn = -1;
			    break;
		    } 

		    else {

#ifdef	BAD144DEBUG
			    printf("%.3s:(cyl %d,trk %d,sec %d)",
				&(qi->name)[1],
				bad->bt_bad[i].bt_cyl,
				(bad->bt_bad[i].bt_trksec>>8) & 0xff,
				bad->bt_bad[i].bt_trksec&0xff);
#endif	BAD144DEBUG

			    bad->bt_bad[i].bt_bn = 
				(((bad->bt_bad[i].bt_cyl * ntpc) +
				((bad->bt_bad[i].bt_trksec>>8)&0xff))
				*nspt)+
				(bad->bt_bad[i].bt_trksec&0xff);
			    nbs++;

#ifdef	BAD144DEBUG
			    printf("[blk %d] remapped to %d\n",
				bad->bt_bad[i].bt_bn, blkno - nbs);
#endif	BAD144DEBUG
			    
		    }
		    
		}
		if(bad->bt_csn != -1)
			printf("%.3s: %d remapped sectors\n", 
				&(qi->name)[1], nbs);
		bad->bt_csn = 1;
		bad->bt_mbz = nbs;
    	} 
	else
initdone:	bad->bt_csn = -1;
}

