/* iv68k.h - interrupt vectors for 68k CPUs */

/*
modification history
--------------------
01c,29apr88,gae  fixed typo's in AUTOVEC's 24-26.
01b,05jul87,dnw  added INUM_TO_IVEC, IVEC_TO_INUM, and TRAPNUM_TO_IVEC.
		 added IV_TRAP_{0-15} and IV_USER_0.
01a,29may87,gae  written
*/

#ifndef INCiv68kh
#define INCiv68kh


/* macros to convert interrupt vectors <-> interrupt numbers */

#define IVEC_TO_INUM(intVec)	((int) (intVec) >> 2)
#define INUM_TO_IVEC(intNum)	((FUNCPTR *) ((intNum) << 2))
#define TRAPNUM_TO_IVEC(trapNum) INUM_TO_IVEC (32 + trapNum)


/* interrupt vector definitions */

#define IV_RESET_1			INUM_TO_IVEC (0)
#define IV_RESET_2			INUM_TO_IVEC (1)
#define IV_BUS_ERROR			INUM_TO_IVEC (2)
#define IV_ADDRESS_ERROR		INUM_TO_IVEC (3)
#define IV_ILLEGAL_INSTRUCTION		INUM_TO_IVEC (4)
#define IV_ZERO_DIVIDE			INUM_TO_IVEC (5)
#define IV_CHK_INSTRUCTION		INUM_TO_IVEC (6)
#define IV_TRAP_INSTRUCTION		INUM_TO_IVEC (7)
#define IV_PRIVILEGE_VIOLATION		INUM_TO_IVEC (8)
#define IV_TRACE			INUM_TO_IVEC (9)
#define IV_LINE_1010_EMULATOR		INUM_TO_IVEC (10)
#define IV_LINE_1111_EMULATOR		INUM_TO_IVEC (11)
#define IV_RESERVED_12			INUM_TO_IVEC (12)
#define IV_CP_PROTOCOL_VIOLATION	INUM_TO_IVEC (13)
#define IV_FORMAT_ERROR			INUM_TO_IVEC (14)
#define IV_UNITIALIZED_INTERRUPT	INUM_TO_IVEC (15)

/* 16 - 23	Unassigned, Reserved */

#define IV_SPURIOUS_INTERRUPT		INUM_TO_IVEC (24)
#define IV_AUTOVEC_1			INUM_TO_IVEC (25)
#define IV_AUTOVEC_2			INUM_TO_IVEC (26)
#define IV_AUTOVEC_3			INUM_TO_IVEC (27)
#define IV_AUTOVEC_4			INUM_TO_IVEC (28)
#define IV_AUTOVEC_5			INUM_TO_IVEC (29)
#define IV_AUTOVEC_6			INUM_TO_IVEC (30)
#define IV_AUTOVEC_7			INUM_TO_IVEC (31)

#define IV_TRAP_0			INUM_TO_IVEC (32)
#define IV_TRAP_1			INUM_TO_IVEC (33)
#define IV_TRAP_2			INUM_TO_IVEC (34)
#define IV_TRAP_3			INUM_TO_IVEC (35)
#define IV_TRAP_4			INUM_TO_IVEC (36)
#define IV_TRAP_5			INUM_TO_IVEC (37)
#define IV_TRAP_6			INUM_TO_IVEC (38)
#define IV_TRAP_7			INUM_TO_IVEC (39)
#define IV_TRAP_8			INUM_TO_IVEC (40)
#define IV_TRAP_9			INUM_TO_IVEC (41)
#define IV_TRAP_10			INUM_TO_IVEC (42)
#define IV_TRAP_11			INUM_TO_IVEC (43)
#define IV_TRAP_12			INUM_TO_IVEC (44)
#define IV_TRAP_13			INUM_TO_IVEC (45)
#define IV_TRAP_14			INUM_TO_IVEC (46)
#define IV_TRAP_15			INUM_TO_IVEC (47)

#define IV_FPCP_B_S_U_CONDITION		INUM_TO_IVEC (48)
#define IV_FPCP_INEXACT_RESULT		INUM_TO_IVEC (49)
#define IV_DIVIDE_BY_ZERO		INUM_TO_IVEC (50)
#define IV_UNDERFLOW			INUM_TO_IVEC (51)
#define IV_OPERAND_ERROR		INUM_TO_IVEC (52)
#define IV_OVERFLOW			INUM_TO_IVEC (53)
#define IV_SIGNALING_NAN		INUM_TO_IVEC (54)
#define IV_RESERVED_55			INUM_TO_IVEC (55)
#define IV_PMMU_CONFIGURATION		INUM_TO_IVEC (56)
#define IV_PMMU_ILLEGAL_OPERATION	INUM_TO_IVEC (57)
#define IV_PMMU_ACCESS_LEVEL_VIOLATON	INUM_TO_IVEC (58)

/* 59 - 63	Unassigned, Reserved */

/* 64 - 255	User Defined Vectors (192) */

#define IV_USER_0			INUM_TO_IVEC (64)
#define IV_USER_191			INUM_TO_IVEC (255)

#endif
