/* ioLib.h - I/O interface library header */

/*
modification history
--------------------
04a,22jun88,dnw  moved READ, WRITE, and UPDATE back to UniWorks.h.
03z,04jun88,llk  added MAX_DIRNAMES and S_ioLib_NO_DEVICE_NAME_IN_PATH for path
		   parsing.
		 added FSTAT for file types (inspired by nfs).
		 added DEFAULT_FILE_PERM and DEFAULT_DIR_PERM for newly created
		   files and directories.
03y,30apr88,gae  got read/write modes right.
03x,29mar88,gae  added FIOISATTY.  Added UNIX style open() and lseek() flags.
		 moved READ, WRITE, and UPDATE here from UniWorks.h.
03w,31dec87,jlf  added FOLLOW_LINK.
03v,01oct87,gae  added FIOGETNAME for all file descriptors.
		 added FIO[SG]ETOPTIONS for line options on devices.
03u,09sep87,dnw  added FIONBIO for sockets.
		 added FIONMSGS for pipes.
03t,09sep87,dnw  added FIOSQUEEZE and HD_1, HD_2 for rt-11 disks.
03s,09jun87,ecs  added S_ioLib_CANCELED & FIOCANCEL.
03r,14feb87,dnw  added S_ioLib_NO_FILENAME.
03q,04feb87,llk  added FIODISKCHANGE.
03p,24dec86,gae  changed stsLib.h to vwModNum.h.
03o,01dec86,dnw  increased MAX_FILENAME_LENGTH from 32 to 100.
03n,20nov86,dnw	 added S_ioLib_DISK_NOT_PRESENT.
03m,17oct86,gae	 added S_ioLib_WRITE_PROTECTED.
03l,21may86,llk	 corrected comments.
03k,23mar86,jlf  changed GENERIC to NOT_GENERIC
03j,08mar86,dnw  added S_ioLib_DEVICE_TIMEOUT.
*/

#ifndef INCioLibh
#define INCioLibh

#include "vwModNum.h"


#define MAX_DIRNAMES		255	/* max directory names in a path --
					   same as NFS_MAXDIRNAMES */
#define MAX_FILENAME_LENGTH	100	/* max chars in filename including EOS*/

#define FOLLOW_LINK	-2		/* value for driver to return */

#define DEFAULT_FILE_PERM	0000640		/* default file permissions
						   unix style rw-r----- */
#define DEFAULT_DIR_PERM	0000750		/* default directory permissions
						   unix style rwxr-x--- */

/* file types -- NOTE:  these values are specified in the NFS protocol spec */

#define FSTAT_DIR		0040000		/* directory */
#define FSTAT_CHR		0020000		/* character special file */
#define FSTAT_BLK		0060000		/* block special file */
#define FSTAT_REG		0100000		/* regular file */
#define FSTAT_LNK		0120000		/* symbolic link file */
#define FSTAT_NON		0140000		/* named socket */


/* I/O status codes */

#define S_ioLib_NO_DRIVER		(M_ioLib | 1)
#define S_ioLib_UNKNOWN_REQUEST		(M_ioLib | 2)
#define S_ioLib_DEVICE_ERROR		(M_ioLib | 3)
#define S_ioLib_DEVICE_TIMEOUT		(M_ioLib | 4)
#define S_ioLib_WRITE_PROTECTED		(M_ioLib | 5)
#define S_ioLib_DISK_NOT_PRESENT	(M_ioLib | 6)
#define S_ioLib_NO_FILENAME		(M_ioLib | 7)
#define S_ioLib_CANCELED		(M_ioLib | 8)
#define S_ioLib_NO_DEVICE_NAME_IN_PATH	(M_ioLib | 9)


/* ioctl function codes */

#define FIONREAD	1		/* get num chars available to read */
#define FIOFLUSH	2		/* flush any chars in buffers */
#define FIOOPTIONS	3		/* set options (FIOSETOPTIONS) */
#define FIOBAUDRATE	4		/* set serial baud rate */
#define FIODISKFORMAT	5		/* format disk */
#define FIODISKINIT	6		/* initialize disk directory */
#define FIOSEEK		7		/* set current file char position */
#define FIOWHERE	8		/* get current file char position */
#define FIODIRENTRY	9		/* return a directory entry */
#define FIORENAME	10		/* rename a directory entry */
#define FIOREADYCHANGE	11		/* return TRUE if there has been a
					   media change on the device */
#define FIONWRITE	12		/* get num chars still to be written */
#define FIODISKCHANGE	13		/* set a media change on the device */
#define FIOCANCEL	14		/* cancel read or write on the device */
#define FIOSQUEEZE	15		/* squeeze out empty holes in rt-11
					 * file system */
#define FIONBIO		16		/* set non-blocking I/O; SOCKETS ONLY!*/
#define FIONMSGS	17		/* return num msgs in pipe */
#define FIOGETNAME	18		/* return file name in arg */
#define FIOGETOPTIONS	19		/* get options */
#define FIOSETOPTIONS	FIOOPTIONS	/* set options */
#define FIOISATTY	20		/* is a tty */

#define FIOFLUSHIN	21		/* flush chars in input buffer (tty)*/
#define FIOFLUSHOUT	22		/* flush chars in output buffer (tty)*/

/* ioctl option values */

#define OPT_ECHO	0x01		/* echo input */
#define OPT_CRMOD	0x02		/* lf -> crlf */
#define OPT_TANDEM	0x04		/* ^S/^Q flow control protocol */
#define OPT_7_BIT	0x08		/* strip parity bit from 8 bit input */
#define OPT_MON_TRAP	0x10		/* enable trap to monitor */
#define OPT_ABORT	0x20		/* enable shell restart */
#define OPT_LINE	0x40		/* enable basic line protocol */

#ifdef NOT_GENERIC
#define OPT_SMPTE	0x8000		/* smpte mode - other options ignored */
#endif

#define OPT_RAW		0		/* raw mode */

#define OPT_TERMINAL	(OPT_ECHO | OPT_CRMOD | OPT_TANDEM | \
			 OPT_MON_TRAP | OPT_7_BIT | OPT_ABORT | OPT_LINE)


/* ioctl augmented arguments */

typedef struct		/* REQ_DIR_ENTRY */
    {
    int entryNum;		/* number of directory entry */
    char name[MAX_FILENAME_LENGTH];	/* name of file */
    int nChars;			/* number of chars in file */
    short day;			/* creation day of month */
    short month;		/* creation month of year */
    short year;			/* creation year of era */
    } REQ_DIR_ENTRY;

/* disk formats */

#define SS_1D_8		1	/* single side, single density, 8"     */
#define SS_2D_8		2	/* single side, double density, 8"     */
#define DS_1D_8		3	/* double side, single density, 8"     */
#define DS_2D_8		4	/* double side, double density, 8"     */
#define SS_1D_5		5	/* single side, single density, 5 1/4" */
#define SS_2D_5		6	/* single side, double density, 5 1/4" */
#define DS_1D_5		7	/* double side, single density, 5 1/4" */
#define DS_2D_5		8	/* double side, double density, 5 1/4" */

#define HD_1		129	/* hard disk - type 1 */
#define HD_2		130	/* hard disk - type 2 */


/* Flags for open(2) - must match READ/WRITE/UPDATE in UniWorks.h! */

#define	O_RDONLY	0x0	/* read only */
#define	O_WRONLY	0x1	/* write only */
#define	O_RDWR		0x2	/* both read and write */
#define	O_CREAT		0x80	/* open with file create */
#define	O_TRUNC		0x100	/* open with truncation */

/* Flags for lseek(2) */

#define	L_SET		0	/* absolute offset */
#define	L_INCR		1	/* relative to current offset */
#define	L_XTND		2	/* relative to end of file */

#endif INCioLibh
