/*
 * $Header: mwcreg.h,v 1.1 89/01/23 17:17:04 rml Exp $
 */
/*
 * MWC VME-MWS black and white display hardware definitions
 * (1280 pixels/line x 1024 lines) / (8 pixels/byte) = 0x28000
 */

#ifdef KERNEL
#include "../h/types.h"
#include "../h/ioctl.h"
#include "../mipsvme/vmereg.h"
#else
#include <sys/types.h>
#include <sys/ioctl.h>
/*#include </sys/mipsvme/vmereg.h> /**/
#endif
#ifdef sun
#define MWC_FBSIZE (128*1024) /* this is to simulate BW2 1152x900	*/
#else
#define	MWC_FBSIZE	(160*1024)	/* total size of MWS address map */
#endif sun

#define MWCSIZE ((MWC_FBSIZE+(NBPG-1)) & ~(NBPG - 1))
#ifdef notdef
/*
 * Verify that MWC_IOB_ADDR falls on a page boundary
 * since mmap() sys call insists on addresses and the length 
 * to be mapped being aligned on page boundaries
 * otherwise put a pad in front of it.
 */
#endif notdef

#define MWC_FBOFF(n)  ((off_t) 0)	
#define MWC_FBLEN	  0x40000 
#define MWC_REGOFF(n) ((off_t) 0x3ffc0)
#define MWC_REGLEN	  64

# define MWC_BASE_ADDR     0x18000000	/* should be as defined by A32D32 */	
# define MWC_BASE_INCR     0x40000
# define MWC_ADDR(n)  ((caddr_t)(K1BASE + MWC_BASE_ADDR + n*MWC_BASE_INCR))

# define MWC_IOBADDR(n)   MWC_ADDR(n) 

