/*
 * $Header: mwc.c,v 1.1 89/01/23 17:16:59 rml Exp $
 */

#include "mwc.h"
#if NMWC > 0
/*
 * VMEBUS driver for ISI Monochrome Workstation Card.
 *
 * Note: the primary interface for this device is through the mmap system
 * call which maps the device's memory into the user's address space.
 * 
 TODO: multiple devices, mmap clean-up
 */

#include "../machine/pte.h"
#include "../mips/cpu.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/buf.h"
#include "../h/vm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/conf.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../mipsvme/vmevar.h"
#include "../bwfbdev/fbio.h"
#include "../bwfbdev/mwcreg.h"

struct vme_device *mwcinfo[NMWC];

int mwcprobe(), mwcslave(), mwcattach(), mwcintr();

struct vme_driver mwcdriver = {
	mwcprobe, mwcslave, mwcattach, "mwc", mwcinfo, "ISI", 0
};

struct mwcsoft {
	int probed;
} mwcsoft[NMWC];

#define MUNIT(dev) (minor(dev))

static
struct fbtype mwcparms = {
 FBTYPE_MWC,				/* frame buffer type	*/
 1280,					/* width in pixels	*/
 1024,					/* height in pixels	*/
 1280/32,				/* pitch		*/
 1,					/* depth		*/
 2,					/* size of colormap	*/
 MWCSIZE,				/* size			*/
 MWC_IOBADDR(0),			/* where to map fb	*/
 MWC_FBOFF(0),				/* fb offset		*/
 MWC_FBLEN,				/* total fb size	*/
 MWC_IOBADDR(0),   			/* where to map reg */
 MWC_REGOFF(0),				/* reg offset		*/
 MWC_REGLEN,				/* reg length		*/
};
mwcprobe(reg, ctlr)
caddr_t reg;
int ctlr;
{
	extern int autoconf_cvec;
	extern int autoconf_br;

	if(badaddr(reg, 4))
		return 0;
#ifdef TODO
	(Only do this once mwcintr is real.)
	Get a vme interrupt vector from new_vmevec() and set the card's
	intrvec to it.
	Enable vertical retrace interrupts on the card.
	Delay for a while (40 ms?) to allow autoconf to catch the interrupt.
#endif TODO
	autoconf_cvec = 0xa1;
	autoconf_br = 4;
	return (256 * 1024);	/* total Displayed + non- + control space */
}

mwcslave()
{
	return 1;
}

mwcattach(vi)
struct vme_device *vi;
{
	int unit;
	if((unit = vi->vi_unit) >= NMWC) 
		return 0;
	mwcsoft[unit].probed = 1;
	printf("ISI Monchrome Workstation Card at vme 0x%x\n",
		(int)(vi->vi_vmeaddr));
	return 1;
}

mwcintr()
{
#ifdef TODO
	synchronize mouse input to display: wakeup server if mouse has
	moved. This must be coordinated with the mouse driver if used.
#endif TODO
	panic("mwcintr");
}

mwcopen(dev)
	dev_t dev;
{
	register int unit = MUNIT(dev);

	if (unit >= NMWC)
		return (ENXIO);
	if( !mwcsoft[unit].probed )	/* device not there */
		return(ENXIO);
	return (0);
}

mwcclose(dev)
	dev_t dev;
{
	register int unit = MUNIT(dev);

	if (unit >= NMWC)
		return (ENXIO);
	return (0);
}

mwcread(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	return (mwcrw(dev, uio, UIO_READ));
}

mwcwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	return (mwcrw(dev, uio, UIO_WRITE));
}

mwcrw(dev, uio, rw)
	dev_t dev;
	struct uio *uio;
	enum uio_rw rw;
{
	register unit = MUNIT(dev);
	register struct vme_device *vi = mwcinfo[unit];
	register int o;
	register u_int c, v;
	register struct iovec *iov;
	register char *addr;
	int error = 0;

	while (uio->uio_resid > 0 && error == 0) {
		iov = uio->uio_iov;
		if (iov->iov_len == 0) {
			uio->uio_iov++;
			uio->uio_iovcnt--;
			if (uio->uio_iovcnt < 0)
				panic("mwcrw");
			continue;
		}

		c = iov->iov_len;
		if ( c + uio->uio_offset > MWCSIZE)
			goto fault;
		/* XXX */
		/* We can't seem to talk to it through a non-priviledged addr */
		addr = K1BASE + vi->vi_vmeaddr + uio->uio_offset;
		error = uiomove(addr, c, rw, uio);

		if (error)
			break;
		iov->iov_base += c;
		iov->iov_len -= c;
		uio->uio_offset += c;
		uio->uio_resid -= c;
	}
	return (error);
fault:
	return (EFAULT);
}

mwcioctl(dev, cmd, arg)
	dev_t dev;
	register unsigned int cmd;
	caddr_t arg;
{
	register int unit = MUNIT(dev);

	if(unit > NMWC) 
		return (ENXIO);
	switch(cmd) {

	case FBIOGTYPE: {
		struct fbtype *pt = (struct fbtype *)arg;
		bcopy( &mwcparms, pt, sizeof(struct fbtype));
#ifdef notdef
		struct fbtype *pt = (struct fbtype *)arg;
		pt->fb_type = mwcparms.fb_type;
		pt->fb_width = mwcparms.fb_width;
		pt->fb_height = mwcparms.fb_height;
		pt->fb_pitch = mwcparms.fb_pitch;
		pt->fb_depth = mwcparms.fb_depth;
		pt->fb_cmsize = mwcparms.fb_cmsize;
		pt->fb_size = mwcparms.fb_size;
#endif
		break;
		}

	default:
		return (EINVAL);
		break;
	}
	return (0);
}

mwcmmap(dev, off, prot) 
	dev_t dev;
{
	register int unit = MUNIT(dev);
	register struct vme_device *vi = mwcinfo[unit];
	char *addr;

	if (unit >= NMWC)
		return (-1);
	
	addr = vi->vi_vmeaddr + off;
	return(btop(K0_TO_PHYS(addr)));
}

#endif NMWC

