/*
 * $Header: ms.c,v 1.1 89/01/23 17:16:42 rml Exp $
 */
/*    MIPS Computer Systems, Inc. Sunnyvale, CA. 
 *
 * $Author: rml $
 * $Source: /u2/src/graphics/X.V11R3/src/server/ddx/bwfb/bwfbdev/RCS/ms.c,v $
 * $Revision: 1.1 $
 * $Date: 89/01/23 17:16:42 $
 *
 */

#include "mms.h"
#if NMMS > 0

/*
 * Line discipline for RS232 tablets;
 * supplies binary coordinate data.
 *
 *  - compile this -signed (see tty.h)
 *  TODO:
 *	- support for five buttons (X11 required)
 *  - various ioctl for mouse accel. etc.
 *  - connect to fb data-structures and remove all that hard-coded stuff
 *  - test various tablets
 *
 * Mouse select management is done by 
 * placing a single character on the tty raw input queue whenever
 * there is some amount of mouse data available to be read.  Once,
 * all the data has been read, the tty raw input queue is flushed.
 */
#include "../h/types.h"
#include "../h/conf.h"
#include "../h/param.h"
#include "../h/ioctl.h"
#include "../h/systm.h"
#include "../h/user.h"
#include "../h/tty.h"
#include "../h/proc.h"
#include "../h/vnode.h"
#include "../h/file.h"
#include "../h/buf.h"
#include "../h/uio.h"

#include "../bwfbdev/msreg.h"
#include "../bwfbdev/msio.h"
#include "../bwfbdev/ev_queue.h"

#define iabs(a)		(((a)<0)?(-a):(a))
#define Max(a,b)	(((a)>(b))?(a):(b))
#define Min(a,b)	(((a)<(b))?(a):(b))

#ifdef sun
#define T_LINEP t_linep
#endif
#ifdef mips
#define spl5 spltty
#endif
/*
 * Tablet configuration table.
 */
struct	tbconf {
	short	tbc_recsize;	/* input record size in bytes */
	short	tbc_uiosize;	/* size of data record returned user */
	int	tbc_sync;	/* mask for finding sync byte/bit */
	int	(*tbc_decode)();/* decoding routine */
	char	*tbc_run;	/* enter run mode sequence */
	char	*tbc_point;	/* enter point mode sequence */
	char	*tbc_stop;	/* stop sequence */
	char	*tbc_start;	/* start/restart sequence */
	int	tbc_flags;
#define	TBF_POL	0x1	/* polhemus hack */
};

static	int tbdecode(), gtcodecode(), poldecode();
static	int tblresdecode(), tbhresdecode(), msdecode();

struct	tbconf tbconf[TBTYPE] = {
{ 0 },
{ 5, sizeof (struct tbpos), 0200, tbdecode, "6", "4" },
{ 5, sizeof (struct tbpos), 0200, tbdecode, "\1CN", "\1RT", "\2", "\4" },
{ 8, sizeof (struct gtcopos), 0200, gtcodecode },
{17, sizeof (struct polpos), 0200, poldecode, 0, 0, "\21", "\5\22\2\23",
 TBF_POL },
{ 5, sizeof (struct tbpos), 0100, tblresdecode, "\1CN", "\1PT", "\2", "\4"},
{ 6, sizeof (struct tbpos), 0200, tbhresdecode, "\1CN", "\1PT", "\2", "\4"},
{ 5, sizeof (struct tbpos), 0360, msdecode },
};

/*
 * Tablet state
 */
struct tb {
	int	tbflags;		/* mode & type bits */
	Event_queue	tb_q;		/* input queue	(events only)  */
	caddr_t tb_qdata;		/* address of tb_q data block	*/
	int		tb_qbytes;		/* # of bytes used for data block	*/
	int		lastbuttons;	/* last status button	*/
	vsBox	mbox;
	vsCursor mouse;		/* screen coordinates of pointer	*/
	short	mthreshold;	/* pointer motion parameter	*/
	short	mscale;		/* scale factor (if negative then do square) */
#define	TBMAXREC	20	/* max input record size */
	char	cbuf[TBMAXREC];		/* input buffer */
	union {
		struct	tbpos tbpos;
		struct	gtcopos gtcopos;
		struct	polpos polpos;
	} rets;				/* processed state */
#define NTBS	16
} tb[NTBS];

/*
 * Open as tablet discipline; called on discipline change.
 */
/*ARGSUSED*/
mmsopen(dev, tp)
	dev_t dev;
	register struct tty *tp;
{
	register struct tb *tbp;
	register struct cdevsw *dp;
	struct sgttyb sg;
	int err;

#ifdef MS_DEBUG
	printf(" mmsopen: t_line=%d\n", tp->t_line);
#endif

	if (tp->t_line == MMOUSELDISC )
		return (ENODEV);
	ttywflush(tp);
	for (tbp = tb; tbp < &tb[NTBS]; tbp++)
		if (tbp->tbflags == 0)
			break;
	if (tbp >= &tb[NTBS])
		return (EBUSY);
	tbp->tbflags = TBTIGER|TBPOINT;		/* default */
	/*
	 * Setup tty flags
	 */
	dp = &cdevsw[major(dev)];
	if (err = (*dp->d_ioctl) (dev, TIOCGETP, (caddr_t)&sg, 0))
		return(err);
	sg.sg_flags = RAW+ANYP;
	sg.sg_ispeed = sg.sg_ospeed = B1200;
	if (err = (*dp->d_ioctl) (dev, TIOCSETP, (caddr_t)&sg, 0))
		return(err);
	tp->t_cp = tbp->cbuf;
	tp->t_inbuf = 0;
	bzero((caddr_t)&tbp->rets, sizeof (tbp->rets));
	tp->T_LINEP = (caddr_t)tbp;
	tp->t_flags |= LITOUT;

	/* initialize private data */
	tbp->tb_qdata = 0;
	tbp->lastbuttons = 87;
	tbp->mouse.x = 640;
	tbp->mouse.y = 512;
	tbp->mthreshold = tbp->mscale = 1;
#ifdef MS_DEBUG
	printf(" mmsopen: t_linep=0x%x\n", tp->T_LINEP);
#endif
	return (0);
}

/*
 * Line discipline change or last device close.
 */
mmsclose(tp)
	register struct tty *tp;
{
	register int s;
	register struct tb *tbp = (struct tb *)tp->T_LINEP;
	int modebits = TBPOINT|TBSTOP;

	if((tbp->tbflags&TB_EV_MODE) && (tbp->tb_qdata != 0))
		evq_free(tbp->tb_qbytes);
/*		kmem_free(tbp->tb_qdata, (u_int)tbp->tb_qbytes); */
	mmsioctl(tp, BIOSMODE, &modebits, 0);
	s = spl5();
	tbp->tbflags = 0;
	tp->t_cp = 0;
	tp->t_inbuf = 0;
	tp->t_rawq.c_cc = 0;		/* clear queues -- paranoid */
	tp->t_canq.c_cc = 0;
	tp->t_line = 0;			/* paranoid: avoid races */
	splx(s);
}

/*
 * Read from a tablet line.
 * Characters have been buffered in a buffer and decoded.
 */
mmsread(tp, uio)
	register struct tty *tp;
	struct uio *uio;
{
	int pri = spl5();
	register struct tb *tbp = (struct tb *)tp->T_LINEP;
	register struct tbconf *tc = &tbconf[tbp->tbflags & TBTYPE];
	int error = 0;

#ifdef MS_DEBUG
	printf("mmsread: state=%d rawq=%d\n", tp->t_state,
			tp->t_rawq.c_cc);
#endif
	if ((tp->t_state&TS_CARR_ON) == 0) {
		(void) splx(pri);
		return (EIO);
	}
	while (tp->t_rawq.c_cc <tc->tbc_recsize) {
		if (tp->t_state&TS_NBIO) {
			(void) splx(pri);
			return (EWOULDBLOCK);
		}
		/*
		 * wait on tty raw queue untill enough
		 */
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
	}
	if (tbp->tbflags & TB_EV_MODE) {
		vsEvent Xevent;
		while ((evq_peek(&tbp->tb_q, &Xevent) != EVENT_Q_EMPTY) &&
			(uio->uio_resid >= sizeof(Xevent))) {
			(void) splx(pri);
			if(error = uiomove((caddr_t)&Xevent, 
				sizeof(Xevent), UIO_READ, uio)) 
				break;
			else
				(void)evq_get(&tbp->tb_q, &Xevent);
			pri = spl5();
		}
	} else {
		(void) splx(pri);
		error = uiomove(&tbp->rets, tc->tbc_uiosize, UIO_READ, uio);
		pri = spl5();
	}
	tp->t_rawq.c_cc -= tc->tbc_recsize;
	if (tc->tbc_flags&TBF_POL)
		tbp->rets.polpos.p_key = ' ';
	(void) splx(pri);
	return (error);
}

/*
 * Low level character input routine.
 * Stuff the character in the buffer, and decode
 * if all the chars are there.
 *
 * This routine could be expanded in-line in the receiver
 * interrupt routine to make it run as fast as possible.
 */
mmsinput(c, tp)
	register int c;
	register struct tty *tp;
{
	register struct tb *tbp = (struct tb *)tp->T_LINEP;
	register struct tbconf *tc = &tbconf[tbp->tbflags & TBTYPE];

	/*
	 * Locate sync bit/byte or reset input buffer.
	 */
	if ((c&tc->tbc_sync == 0x80) || tp->t_inbuf == tc->tbc_recsize) {
		tp->t_cp = tbp->cbuf;
		tp->t_inbuf = 0;
	}
	*tp->t_cp++ = c;	/* may need to mask by 0177	*/
	tp->t_rawq.c_cc++;

	if (++tp->t_inbuf == tc->tbc_recsize) {
		int s;
		/*
		 * Call decode routine only if a full record has been collected.
		 */
		(*tc->tbc_decode)(tbp->cbuf, &tbp->rets);
		if (tbp->tbflags&TB_EV_MODE) {
			savEvent(&tbp->rets, tbp);
		} 
		s  = spl5();
		/* trigger select */
		ttwakeup(tp);
		(void) splx(s);
	}
}
static
savEvent(tbpos, tbp)
	struct tbpos *tbpos;
	struct tb *tbp;
{
	vsEvent Xevent;
	int c = tbpos->status;
	int l = tbp->lastbuttons;

	if (c != l) {
		Xevent.vse_x = tbpos->xpos;
		Xevent.vse_y = tbpos->ypos;
		Xevent.vse_device = VSE_MOUSE;
		/* change in the mouse buttons */
		tbp->lastbuttons = c;
		Xevent.vse_type = VSE_BUTTON;
		if ( ((c&1) != 0) && ((l&1) == 0)) {
			/* right button up */
			Xevent.vse_direction = VSE_KBTUP;
			Xevent.vse_key = VSE_RIGHT_BUTTON;
			queueEvent( &Xevent, &tbp->tb_q);
		}
		if ( ((c&1) == 0) && ((l&1) != 0)) {
			/* right button down */
			Xevent.vse_direction = VSE_KBTDOWN;
			Xevent.vse_key = VSE_RIGHT_BUTTON;
			queueEvent( &Xevent, &tbp->tb_q);
		}
		if ( ((c&2) != 0) && ((l&2) == 0)) {
			/* middle button up */
			Xevent.vse_direction = VSE_KBTUP;
			Xevent.vse_key = VSE_MIDDLE_BUTTON;
			queueEvent( &Xevent, &tbp->tb_q);
		}
		if ( ((c&2) == 0) && ((l&2) != 0)) {
			/* middle button down */
			Xevent.vse_direction = VSE_KBTDOWN;
			Xevent.vse_key = VSE_MIDDLE_BUTTON;
			queueEvent( &Xevent, &tbp->tb_q);
		}
		if ( ((c&4) != 0) && ((l&4) == 0)) {
			/* left button up */
			Xevent.vse_direction = VSE_KBTUP;
			Xevent.vse_key = VSE_LEFT_BUTTON;
			queueEvent( &Xevent, &tbp->tb_q);
		}
		if ( ((c&4) == 0) && ((l&4) != 0)) {
			/* left button down */
			Xevent.vse_direction = VSE_KBTDOWN;
			Xevent.vse_key = VSE_LEFT_BUTTON;
			queueEvent( &Xevent, &tbp->tb_q);
		}
	} else {
			/* mouse acceleration algorithms for cursor position */
			int dx = tbpos->xpos;
			int dy = tbpos->ypos;
			if ( (dy>50) || (dy < -50) || (dx > 50) || (dx < -50)){ 
				dx=0; dy=0; /* mouse too fast */
			}
			if (tbp->mscale < 0 ) {
				if (dy<0) dy = -(dy*dy);
				else dy = (dy*dy);
				if (dx<0) dx = -(dx*dx);
				else dx = (dx*dx);
			} else {	/* vs100 style */
				int thresh = tbp->mthreshold;
				int scale = tbp->mscale;
				if( iabs(dx) > thresh ) {
					if (dx < 0)
					 dx= (dx+thresh)*scale-thresh;
					else dx= (dx-thresh)*scale+thresh;
				}
				if( iabs(dy) > thresh ) {
					if (dy < 0)
					 dy= (dy+thresh)*scale-thresh;
					else dy= (dy-thresh)*scale+thresh;
				}
			}
			tbp->mouse.x += dx;
			tbp->mouse.x = Min(Max(0, tbp-> mouse.x), 1280-1);
			tbp->mouse.y -= dy;
			tbp->mouse.y = Min(Max(0, tbp-> mouse.y), 1024-1);

			/* Software Cursor -- * Wakeup X or no updates */
			if (evq_is_empty(&tbp->tb_q) || 
				tbp->mouse.y >= tbp->mbox.bottom || /* Mouse Box */
				tbp->mouse.y <  tbp->mbox.top ||
				tbp->mouse.x >= tbp->mbox.right ||
				tbp->mouse.x <  tbp->mbox.left) {
				Xevent.vse_type = VSE_MMOTION;
				Xevent.vse_device = VSE_MOUSE;
				Xevent.vse_x = tbpos->xpos;
				Xevent.vse_y = tbpos->ypos;
				queueEvent( &Xevent, &tbp->tb_q);
			}
		}
}

/*
 * Decode Mouse systems mouse
 * The byte protocol is a 5 byte series whenever something changes
 * at the mouse:
 *  1   10000LMR
 *  2   delta x
 *  3   delta y
 *  4   delta x
 *  5   delta y
 */
static
msdecode(cp, tbpos)
	register char *cp;
	register struct tbpos *tbpos;
{

	tbpos->status = *cp++;	/* needs to be decoded  */
	tbpos->xpos = *cp++; 
	tbpos->ypos = *cp++;
	tbpos->scount++;
}

static
queueEvent( ep, msq)
	vsEvent *ep;
	Event_queue *msq;
{
	vsEvent lev ;
/*
   Mouse Event Compression:
   If this event is motion, and there is a previous (last) motion event,
   and the last is not the only event in the queue, update the last event
   in place rather than queue a new one.
*/

	if ((ep->vse_type == VSE_MMOTION) &&
	    (evq_peek(msq, &lev) != EVENT_Q_EMPTY) && 
		(lev.vse_type == VSE_MMOTION) &&
		(evq_used(msq) > 1)) {
		
		(void) evq_get(msq, &lev);
		lev.vse_x = ep->vse_x;
		lev.vse_y = ep->vse_y;
		evq_putback(msq, &lev);
	} else {
		/* put on Q here */
		uniqtime(&ep->time);
		if (evq_put(msq, ep) == EVENT_Q_OVERFLOW )  /* room in queue */
			printf("ms: Event queue overflow\n");
	}

}


/*
 * Decode GTCO 8 byte format (high res, tilt, and pressure).
 */
static
gtcodecode(cp, tbpos)
	register char *cp;
	register struct gtcopos *tbpos;
{

	tbpos->pressure = *cp >> 2;
	tbpos->status = (tbpos->pressure > 16) | TBINPROX; /* half way down */
	tbpos->xpos = (*cp++ & 03) << 14;
	tbpos->xpos |= *cp++ << 7;
	tbpos->xpos |= *cp++;
	tbpos->ypos = (*cp++ & 03) << 14;
	tbpos->ypos |= *cp++ << 7;
	tbpos->ypos |= *cp++;
	tbpos->xtilt = *cp++;
	tbpos->ytilt = *cp++;
	tbpos->scount++;
}

/*
 * Decode old Hitachi 5 byte format (low res).
 */
static
tbdecode(cp, tbpos)
	register char *cp;
	register struct tbpos *tbpos;
{
	register char byte;

	byte = *cp++;
	tbpos->status = (byte&0100) ? TBINPROX : 0;
	byte &= ~0100;
	if (byte > 036)
		tbpos->status |= 1 << ((byte-040)/2);
	tbpos->xpos = *cp++ << 7;
	tbpos->xpos |= *cp++;
	if (tbpos->xpos < 256)			/* tablet wraps around at 256 */
		tbpos->status &= ~TBINPROX;	/* make it out of proximity */
	tbpos->ypos = *cp++ << 7;
	tbpos->ypos |= *cp++;
	tbpos->scount++;
}

/*
 * Decode new Hitach 5-byte format (low res).
 */
static
tblresdecode(cp, tbpos)
	register char *cp;
	register struct tbpos *tbpos;
{

	*cp &= ~0100;		/* mask sync bit */
	tbpos->status = (*cp++ >> 2) | TBINPROX;
	tbpos->xpos = *cp++;
	tbpos->xpos |= *cp++ << 6;
	tbpos->ypos = *cp++;
	tbpos->ypos |= *cp++ << 6;
	tbpos->scount++;
}

/*
 * Decode new Hitach 6-byte format (high res).
 */
static
tbhresdecode(cp, tbpos)
	register char *cp;
	register struct tbpos *tbpos;
{
	char byte;

	byte = *cp++;
	tbpos->xpos = (byte & 03) << 14;
	tbpos->xpos |= *cp++ << 7;
	tbpos->xpos |= *cp++;
	tbpos->ypos = *cp++ << 14;
	tbpos->ypos |= *cp++ << 7;
	tbpos->ypos |= *cp++;
	tbpos->status = (byte >> 2) | TBINPROX;
	tbpos->scount++;
}

/*
 * Polhemus decode.
 */
static
poldecode(cp, polpos)
	register char *cp;
	register struct polpos *polpos;
{

	polpos->p_x = cp[4] | cp[3]<<7 | (cp[9] & 0x03) << 14;
	polpos->p_y = cp[6] | cp[5]<<7 | (cp[9] & 0x0c) << 12;
	polpos->p_z = cp[8] | cp[7]<<7 | (cp[9] & 0x30) << 10;
	polpos->p_azi = cp[11] | cp[10]<<7 | (cp[16] & 0x03) << 14;
	polpos->p_pit = cp[13] | cp[12]<<7 | (cp[16] & 0x0c) << 12;
	polpos->p_rol = cp[15] | cp[14]<<7 | (cp[16] & 0x30) << 10;
	polpos->p_stat = cp[1] | cp[0]<<7;
	if (cp[2] != ' ')
		polpos->p_key = cp[2];
}
/*ARGSUSED*/
mmsioctl(tp, cmd, data, flag)
	struct tty *tp;
	caddr_t data;
{
	register struct tb *tbp = (struct tb *)tp->T_LINEP;
	int err = 0;
	int pri = spl5();

	switch (cmd) {

	case FIONREAD:
		if(tbp->tbflags & TB_EV_MODE)
			*((int *) data) = sizeof(vsEvent)*evq_used(&tbp->tb_q);
		else
			*((int *) data) =  tbp->rets.tbpos.scount;	
		break;

	case BIOGMODE:
		*(int *)data = tbp->tbflags & TBMODE;
		break;

	case BIOSTYPE:
		if (tbconf[*(int *)data & TBTYPE].tbc_recsize == 0 ||
		    tbconf[*(int *)data & TBTYPE].tbc_decode == 0)
			return (EINVAL);
		tbp->tbflags &= ~TBTYPE;
		tbp->tbflags |= *(int *)data & TBTYPE;
		/* fall thru... to set mode bits */

	case BIOSMODE: {
		register struct tbconf *tc;

		tbp->tbflags &= ~TBMODE;
		tbp->tbflags |= *(int *)data & TBMODE;
		tc = &tbconf[tbp->tbflags & TBTYPE];
		if (tbp->tbflags&TBSTOP) {
			if (tc->tbc_stop)
				ttyout(tc->tbc_stop, tp);
		} else if (tc->tbc_start)
			ttyout(tc->tbc_start, tp);
		if (tbp->tbflags&TBPOINT) {
			if (tc->tbc_point)
				ttyout(tc->tbc_point, tp);
		} else if (tc->tbc_run)
			ttyout(tc->tbc_run, tp);
		if (tbp->tbflags&TB_EV_MODE) {
			/* allocate dynamic memory	*/
			if (tbp->tb_qdata == NULL) {
				tbp->tb_qdata = (caddr_t) evq_malloc(&tbp->tb_qbytes);
				if (tbp->tb_qdata == NULL) {
					printf("ms: Could'nt allocate dynamic memory\n");
					return(ENOMEM);
				}
			}
			evq_initialize(&tbp->tb_q, tbp->tb_qdata, tbp->tb_qbytes);
		}
		ttstart(tp);
		break;
	}

	case BIOGTYPE:
		*(int *)data = tbp->tbflags & TBTYPE;
		break;

	case TIOCSETD:
	case TIOCGETD:
	default:
#ifdef  MS_DEBUG
		printf("mmsioctl: t_line= %d cmd= %d err= %d\n", tp->t_line, cmd, err);
#endif
		err = ttioctl(tp, cmd, data, flag);
		splx(pri);
		return (err);		/* pass thru... */

	}
	splx(pri);
	return(err);
}
#endif
