/*
 * $Header: kbstate.h,v 1.1 89/01/23 17:16:25 rml Exp $
 */
/*    MIPS Computer Systems, Inc. Sunnyvale, CA. 
 *
 * $Author: rml $
 * $Source: /u2/src/graphics/X.V11R3/src/server/ddx/bwfb/bwfbdev/RCS/kbstate.h,v $
 * $Revision: 1.1 $
 * $Date: 89/01/23 17:16:25 $
 *
 *   MIPS */

/*
 * Ascii device related definitions:
 */
#define	ASCII_FIRST	(0)
#define	ASCII_LAST	(127)
#define	META_FIRST	(128)
#define	META_LAST	(255)

/*
 * Top device related definitions:
 */
#define	TOP_FIRST	(256)
#define	TOP_LAST	(511)

/*
 *  First are keyboard
 * assignments.  All events for the virtual keyboard have 0 (went up) or
 * 1 (went down) values.
 */

#define	VKEY_FIRST	0x7F

#define	VKEY_KBD_CODES	(128)	

#define	VKEY_FIRSTSHIFT		(VKEY_FIRST+1)		
#define	SHIFT_CAPSLOCK		(VKEY_FIRSTSHIFT+0)		
#define	SHIFT_LOCK		(VKEY_FIRSTSHIFT+1)		
#define	SHIFT_LEFT		(VKEY_FIRSTSHIFT+2)		
#define	SHIFT_RIGHT		(VKEY_FIRSTSHIFT+3)		
#define	SHIFT_LEFTCTRL		(VKEY_FIRSTSHIFT+4)		
/* SHIFT_CTRL is for compatability with previous releases */	
#define	SHIFT_CTRL		SHIFT_LEFTCTRL			
#define	SHIFT_RIGHTCTRL		(VKEY_FIRSTSHIFT+5)		
#define	SHIFT_META		(VKEY_FIRSTSHIFT+6)		
#define	SHIFT_TOP		(VKEY_FIRSTSHIFT+7)		
#define	SHIFT_CMD		(VKEY_FIRSTSHIFT+8)		
#define	VKEY_LASTSHIFT		(VKEY_FIRSTSHIFT+15)		

#define	VKEY_FIRSTFUNC		(VKEY_LASTSHIFT+1)		

#define BUT_FIRST		(VKEY_FIRSTFUNC)		
#define BUT(i)			((BUT_FIRST)+(i)-1)
#define BUT_LAST		(BUT_FIRST+9)			

#define KEY_LEFTFIRST		((BUT_LAST)+1)			
#define KEY_LEFT(i)		((KEY_LEFTFIRST)+(i)-1)		
#define KEY_LEFTLAST		((KEY_LEFTFIRST)+15)		

#define KEY_RIGHTFIRST		((KEY_LEFTLAST)+1)		
#define KEY_RIGHT(i)		((KEY_RIGHTFIRST)+(i)-1)
#define KEY_RIGHTLAST		((KEY_RIGHTFIRST)+15)		

#define KEY_TOPFIRST		((KEY_RIGHTLAST)+1)		
#define KEY_TOP(i)		((KEY_TOPFIRST)+(i)-1)	
#define KEY_TOPLAST		((KEY_TOPFIRST)+15)		

#define KEY_BOTTOMLEFT		((KEY_TOPLAST)+1)		
#define KEY_BOTTOMRIGHT		((KEY_BOTTOMLEFT)+1)		

#define	VKEY_LASTFUNC		(VKEY_FIRSTFUNC+101)		

#define	VKEY_LAST		(VKEY_FIRST+VKEY_KBD_CODES-1)	
