/*
 * $Header: kbio.h,v 1.1 89/01/23 17:16:20 rml Exp $
 */
/*
 * Keyboard related ioctls
 */
#ifdef KERNEL
#include "../h/ioctl.h"
#else KERNEL
#include <sys/ioctl.h>
#endif KERNEL
#define LDISC
#define TERMINAL

/*
 * New ioctl values for TIOCSETD ioctl calls
 *
 */
#ifdef sun
#define MKBLDISC               KBDLDISC +1    /* check in /sys/sys/tty_conf.c */
#endif sun
#ifdef mips
#define MKBLDISC               SLIPDISC +1    /* check in /sys/sys/tty_conf.c */
#endif mips
#ifdef is68k
#define MKBLDISC               SLIPDISC +1    /* check in /sys/sys/tty_conf.c */
#endif is68k

#define	KIOSMODE		_IOW(b, 0, int)	/* set keyboard mode bit(s) */
#define	KIOGMODE 		_IOR(b, 5, int)	/* get keyboard mode bit(s) */
#define KBMODE	0xfff0      /* mode bits: 		*/
#define 	KB_NATIVE    	0x0000		/* raw mode			 */
#define 	KB_ASCII_MODE	0x0010		/* ascii translation */
#define 	KB_EV_MODE	 	0x0040		/* reports events	 */

#define KBTYPE	0x000f		/* keyboard type:	*/
#define		KB_KLUNK	0x00		/* Micro Switch 103SD32-2 */
#define		KB_VT100	0x01		/* Keytronics VT100 compatible */
#define		KB_DT_2		0x02		/* Intrepid-2 custom keyboard */
#define		KB_DT_3		0x03		/* Intrepid-3 custom keyboard */
#define		KB_UNKNOWN	0x0F		/* Ascii terminal masquerading as kbd */

#define	KIOCTRANSABLE	_IOW(b, 6, int)	/* set keyboard translatability */
#define	KIOCGTRANSABLE	_IOR(b, 7, int)	/* get keyboard translatability */
/*
 * Set kio_tablemask table's kio_station to kio_entry.
 * Copy kio_string to string table if kio_entry is between STRING and
 * STRING+15.  EINVAL is possible if there are invalid arguments.
 */
#define	KIOCSETKEY		_IOW(b, 1, struct kiockey)

/*
 * Get kio_tablemask table's kio_station to kio_entry.
 * Get kio_string from string table if kio_entry is between STRING and
 * STRING+15.  EINVAL is possible if there are invalid arguments.
 */
#define	KIOCGETKEY		_IOWR(b, 2, struct kiockey)

/*
 * Send the keyboard device a control command.  kbd.h contains
 * the constants that define the commands.  Normal values are:
 * KBD_CMD_BELL, KBD_CMD_NOBELL, KBD_CMD_CLICK, KBD_CMD_NOCLICK.
 * Inappropriate commands for particular keyboard types are ignored.
 *
 * Since there is no reliable way to get the state of the bell or click
 * or LED (because we can't query the kdb, and also one could do writes
 * to the appropriate serial driver--thus going around this ioctl)
 * we don't provide an equivalent state querying ioctl. 
 */
#define	KIOCCMD			_IOW(b, 8, int)	/* Send keyboard command */

/*
 * Get keyboard type.  Return values are one of KB_* 
 * e.g., KB_KLUNK, KB_VT100, etc... KB_UNKNOWN if
 * the type is not known.
 * Keyboard ID codes...transmitted by the various keyboards
 * after the IDLEKEY code.  
 */
#define	KIOCGTYPE		_IOR(b, 9, int)	/* get keyboard type */
#ifdef LDISC
#define	KIOCSTYPE		_IOW(b, 10, int)	/* set keyboard type */
#endif LDISC


#ifdef TODO
/*
 * Set flag indicating whether keystrokes get routed to /dev/console.
 */
#define	KIOCSDIRECT		_IOW(b, 10, int)

/*
 * Get flag indicating whether keystrokes get routed to /dev/console.
 */
#define	KIOCGDIRECT		_IOR(b, 11, int)

#endif TODO
#ifdef	KERNEL
/*
 * Set handler of untranslated keyboard output.
 */
#define	KIOCSUSECODE	_IOR(b, 3, int (*)())

/*
 * Get handler of untranslated keyboard output.
 */
#define	KIOCGUSECODE	_IOW(b, 4, int (*)())

#define	TR_CANNOT	0	/* Cannot translate keyboard using tables */
#define	TR_CAN		1	/* Can translate keyboard using tables */

struct	kiockey {
	int	kio_tablemask;	/* Translation table (one of: 0, CAPSMASK,
				   SHIFTMASK, CTRLMASK, UPMASK) */
#define	KIOCABORT1	-1	/* Special "mask": abort1 keystation */
#define	KIOCABORT2	-2	/* Special "mask": abort2 keystation */
	u_char	kio_station;	/* Physical keyboard key station (0-127) */
	u_char	kio_entry;	/* Translation table station's entry */
	char	kio_string[10];	/* Value for STRING entries (null terminated) */
};

#endif	KERNEL
