/*
 * $Header: fbio.h,v 1.1 89/01/23 17:15:55 rml Exp $
 */
/*    MIPS Computer Systems, Inc. Sunnyvale, CA. 
 *
 * $Author: rml $
 * $Source: /u2/src/graphics/X.V11R3/src/server/ddx/bwfb/bwfbdev/RCS/fbio.h,v $
 * $Revision: 1.1 $
 * $Date: 89/01/23 17:15:55 $
 *
 *   MIPS */
#ifndef    fbio_DEFINED
#define    fbio_DEFINED

#ifdef KERNEL
#include "../h/types.h"
#include "../h/ioctl.h"
#else
#include <sys/types.h>
#include <sys/ioctl.h>
#endif
/*
 * Frame buffer descriptor.
 * Returned by FBIOGTYPE ioctl on frame buffer devices.
 */
#ifdef sun
struct    fbtype {
    int    fb_type;    /* as defined below */
    int    fb_height;  /* screen height in pixels */
    int    fb_width;   /* screen width  in pixels */
    int    fb_depth;   /* bits per pixel */
    int    fb_cmsize;  /* size of color map (entries) */
    int    fb_size;    /* size of frame buffer memory in bytes */
};
#else
struct    fbtype {
    int     fb_type;     /* as defined below            */
    int     fb_width;    /* screen width  in pixels     */
    int     fb_height;   /* screen height in pixels     */
    int     fb_pitch;    /* number of WORDS per scan line */
    int     fb_depth;    /* bits per pixel              */
    int     fb_cmsize;   /* size of color map (entries) */
    int     fb_size;     /* visible display size        */
    caddr_t fb_addr;     /* where to map the fb 	*/
    off_t   fb_off;      /* where fb starts             */
    int     fb_fblen;    /* displayed  (+undisp. +regs if on same page) */
    caddr_t fb_reg_addr; /* contrl or status registers  */
    off_t   fb_reg_off;	 /* where they start            */
    int     fb_reglen;   /* reg length                 	*/
};
#endif

#ifdef mips
#define    FBIOGTYPE    _IOR(M, 0, struct fbtype)
#define    FBRESET      _IO(M, 1)
#endif
#ifdef sun
#define FBIOGTYPE _IOR(F, 0, struct fbtype)
#endif

#ifdef mips

#define    FBTYPE_MWC            0    /* ISI VME-MWS Monochrome  */
#define    FBTYPE_HIT8           1    /* GSI VGME-6408-X         */
#define    FBTYPE_LASTPLUSONE    2    /* max number of fbs       */

#endif
#ifdef sun
/* frame buffer type codes */
#define FBTYPE_SUN1BW           0
#define FBTYPE_SUN1COLOR        1
#define FBTYPE_SUN2BW           2
#define FBTYPE_SUN3BW           5       /* reserved for future Sun use */
#define FBTYPE_SUN3COLOR        6       /* reserved for future Sun use */
#define FBTYPE_SUN4BW           7       /* reserved for future Sun use */
#define FBTYPE_SUN4COLOR        8

#define FBTYPE_ISIBW    FBTYPE_SUN2BW
#define FBTYPE_LASTPLUSONE  1
#endif sun

#ifdef is68k
#define    FBIOGTYPE    _IOR(M, 0, struct fbtype)
#define    FBRESET      _IO(M, 1)
#define    FBTYPE_MWC            0    /* ISI VME-MWS Monochrome  */
#define    FBTYPE_ISIBW    	 1    /* ISI mono GIP		 */
#define    FBTYPE_HIT8           2    /* GSI VGME-6408-X         */
#define    FBTYPE_ISICLR    	 3    /* ISI color GIP		 */
#define    FBTYPE_LASTPLUSONE    4    /* max number of fbs       */
#endif is68k

#endif    !fbio_DEFINED
