/*
 * $Header: ev_queue.h,v 1.1 89/01/23 17:15:50 rml Exp $
 */
/*    MIPS Computer Systems, Inc. Sunnyvale, CA. 
 *
 * $Author: rml $
 * $Source: /u2/src/graphics/X.V11R3/src/server/ddx/bwfb/bwfbdev/RCS/ev_queue.h,v $
 * $Revision: 1.1 $
 * $Date: 89/01/23 17:15:50 $
 *
 *   MIPS */

#include "../bwfbdev/dt_event.h"

/*
 * Event input queue structure.
 */
typedef	struct	evq_queue {
	struct	evq_node *top;	/* input queue head (first in line) */
	struct	evq_node *bottom;	/* input queue head (last in line) */
	struct	evq_node *free;	/* input queue free list */
	int	num;			/* number of items currently on queue */
	int	size;			/* number of items allowed on queue */
} Event_queue;

#define	EVENT_QUEUE_NULL	((Event_queue *)0)
#define	evq_used(vq) ((vq)->num)
#define	evq_avail(vq) ((vq)->size - (vq)->num)
#define	evq_size(vq) ((vq)->size)
#define	evq_is_empty(vq) ((vq)->top == EVENT_Q_NODE_NULL)
#define	evq_is_full(vq) ((vq)->num == (vq)->size)

/*
 * Vuid input queue node structure.
 */
#define EVQ_EVENT_NULL ((vsEvent *)0)
#define EVENT_MAX_QNODES 256

typedef	struct	evq_node {
	struct	evq_node *next;	/* Next item in queue */
	struct	evq_node *prev;	/* Previous item in queue */
	vsEvent io_event;			/* X event */
} Event_q_node;
#define	EVENT_Q_NODE_NULL	((Event_q_node *)0)

/*
 * Vuid input queue status codes.
 */
typedef	enum	evq_code {
	EVENT_Q_OK=0,		/* OK */
	EVENT_Q_OVERFLOW=1,	/* overflow */
	EVENT_Q_EMPTY=2,	/* empty */
} Event_q_code;

extern	void evq_initialize();	/* (Event_queue *vq, caddr_t data, u_int bytes)
				   Client allocates bytes worth of storage
				   and pass in a data.  Client destroys the q
				   simply by releasing data. */
extern	Event_q_code evq_put();	/* (Event_queue *vq, vsEvent *io_event)
				   Place io_event on queue, position is
				   dependent on the firm event's time.  Can
				   return EVENT_Q_OVERFLOW if no more room. */
extern	Event_q_code evq_get();	/* (Event_queue *vq, vsEvent *io_event)
				   Place event on top of queue into io_event.
				   Can return EVENT_Q_EMPTY if no more events */
extern	Event_q_code evq_peek();	/* Like evq_get but doesn't remove from queue */
extern	Event_q_code evq_putback();/* (Event_queue *vq, vsEvent *io_event)
				   Push io_event on top of queue.  Can
				   return EVENT_Q_OVERFLOW if no more room. */

extern	int evq_compress();	/* (Event_queue *vq, factor)  Try to
				   collapse the queue to a size of 1/factor
				   by squeezing like valuator events together.
				   Returns number collapsed */
extern	int evq_is_valuator();	/* (Event_q_node *vqn) if value is not 0 or 1 */
extern	void evq_delete_node();	/* (Event_queue *vq, Event_q_node *vqn)
				   Deletes vqn from vq */


