/*    MIPS Computer Systems, Inc. Sunnyvale, CA. 
 *
 * $Author: rml $
 * $Source: /u2/src/graphics/X.V11R3/src/server/ddx/bwfb/bwfbdev/RCS/ev_queue.c,v $
 * $Revision: 1.1 $
 * $Date: 89/01/23 17:15:44 $
 *
 */
#ifndef lint
static char rcsid[] = "$Header: ev_queue.c,v 1.1 89/01/23 17:15:44 rml Exp $";
#endif
/*
 *   MIPS  */

/*
 * Input Device queue management.
 * TODO: support multiple workstations
 */

#include "../h/types.h"
#include "../h/time.h"
#include "../bwfbdev/ev_queue.h"

Event_q_node *evq_alloc_node();
void	evq_free_node();
int	evq_eqt();
struct	timeval evq_subt();
struct	timeval evq_divide();
struct	timeval evq_mult();
#define	tv_to_usec(tv)	(((tv).tv_sec * 1000000) + (tv).tv_usec)
		/* Works for small numbers (< 1000) of seconds */
struct	timeval ut_to_tv();

/* allocate dynamic memory	*/
static int flag = 0;
static caddr_t mem_base;

caddr_t
evq_malloc( bytes)
int *bytes;
{
	*bytes = EVENT_MAX_QNODES * sizeof(Event_q_node);
	if (!flag) {
		flag = 1;
		mem_base = (caddr_t) kmem_alloc((u_int) *bytes);
		return (mem_base);
	}
	return(mem_base);
}
void
evq_free( bytes)
{
	if (flag) {
		kmem_free(mem_base, (u_int) bytes);
		flag = 0;
	}
}
		
void
evq_initialize(vq, data, bytes)
	register Event_queue *vq;
	caddr_t data;
	int bytes;
{
	register Event_q_node *new_vqns, *vqn;

	/* Initialize queue */
	vq->top = vq->bottom = vq->free = EVENT_Q_NODE_NULL;
	vq->size = 1 + (bytes - sizeof (Event_q_node)) / sizeof (Event_q_node);
	/* free all nodes */
	new_vqns = (Event_q_node *)data;
	vq->num = vq->size;
	for (vqn = new_vqns; vqn < new_vqns + vq->size; vqn++)
		evq_free_node(vq, vqn);
	return;
}

Event_q_code
evq_put(vq, io_event)
	Event_queue *vq;
	vsEvent *io_event;
{
	register Event_q_node *vp;

	/* Merge into existing events based on time stamp */
	for (vp = vq->bottom; vp; vp = vp->prev) {
		/* Put later times closer to the bottom than earlier ones */
		if (timercmp(&vp->io_event.time, &io_event->time, <) ||
		    evq_eqt(vp->io_event.time, io_event->time)) {
			register Event_q_node *vqn = evq_alloc_node(vq);

			if (vqn == EVENT_Q_NODE_NULL)
				return (EVENT_Q_OVERFLOW);
			vqn->io_event = *io_event;
			/* Insert vqn before vq (neither are null) */
			/* Initialize vqn's next and prev */
			vqn->next = vp->next;
			vqn->prev = vp;
			/* Fix up vp next's prev */
			if (vp->next != EVENT_Q_NODE_NULL)
				vp->next->prev = vqn;
			/* Fix up vp's next */
			vp->next = vqn;
			/* Change bottom */
			if (vp == vq->bottom)
				vq->bottom = vqn;
			/* Change top */
			if (vq->top == EVENT_Q_NODE_NULL)
				vq->top = vqn;
			return (EVENT_Q_OK);
		}
	}
	/* Place at top of queue */
	return (evq_putback(vq, io_event));
}

Event_q_code
evq_get(vq, io_event)
	register Event_queue *vq;
	vsEvent *io_event;
{
	register Event_q_node *vqn = vq->top;

	if (vqn == EVENT_Q_NODE_NULL)
		return (EVENT_Q_EMPTY);
	/* Conditionally copy data */
	if (io_event != EVQ_EVENT_NULL)
		*io_event = vqn->io_event;
	/* Change top */
	vq->top = vqn->next;
	/* Null new top's prev */
	if (vq->top != EVENT_Q_NODE_NULL)
		vq->top->prev = EVENT_Q_NODE_NULL;
	/* Change bottom */
	if (vq->bottom == vqn)
		vq->bottom = EVENT_Q_NODE_NULL;
	/* Release storage */
	evq_free_node(vq, vqn);
	return (EVENT_Q_OK);
}

Event_q_code
evq_peek(vq, io_event)
	Event_queue *vq;
	vsEvent *io_event;
{
	if (vq->top == EVENT_Q_NODE_NULL)
		return (EVENT_Q_EMPTY);
	*io_event = vq->top->io_event;
	return (EVENT_Q_OK);
}

Event_q_code
evq_putback(vq, io_event)
	register Event_queue *vq;
	vsEvent *io_event;
{
	register Event_q_node *vqn = evq_alloc_node(vq);

	if (vqn == EVENT_Q_NODE_NULL)
		return (EVENT_Q_OVERFLOW);
	vqn->io_event = *io_event;
	/* Change new top's next */
	vqn->next = vq->top;
	/* Null new top's prev */
	vqn->prev = EVENT_Q_NODE_NULL;
	/* Change old top's prev */
	if (vq->top != EVENT_Q_NODE_NULL)
		vq->top->prev = vqn;
	/* Change top */
	vq->top = vqn;
	/* Change bottom */
	if (vq->bottom == EVENT_Q_NODE_NULL)
		vq->bottom = vqn;
	return (EVENT_Q_OK);
}

int
evq_compress(vq, factor)
	register Event_queue *vq;
	int factor;
{
	struct	timeval tv_interval, tv_avg_diff, tv_diff; /* Intermediates */
	struct	timeval tv_threshold;
	register Event_q_node *base, *victim;
	Event_q_node *victim_next;
	int num_start;

	if (vq->top == EVENT_Q_NODE_NULL)
		return (0);
	num_start = vq->num;
	/*
	 * Determine the threshold time interval under which events of
	 * the same type (pointer type only) are collapsed.
	 * min_time_betvqnen_values = ((first_entry_time - last_entry_time) /
     *     max_number_of_queue_entries) * factor_by_which_to_compress_queue;
	 */
	tv_interval = evq_subt(vq->bottom->io_event.time,
	    vq->top->io_event.time);
	tv_avg_diff = evq_divide(tv_interval, vq->num);
	tv_threshold = evq_mult(tv_avg_diff, factor);
	/* March down list */
	for (base = vq->top; base; base = base->next) {
		/* See if pointer type event */
		if (!evq_is_pointer(base))
			continue;
		/* Run down list looking for a collapse victim */
		for (victim = base->next; victim; victim = victim_next) {
			/* Remember next victim incase axe victim below */
			victim_next = victim->next;
			/* Fail if not pointer event */
			if (!evq_is_pointer(victim))
				goto Advance_Base;
			/*
			 * May peek ahead and do the collapse as long as the
			 * intervening times of other pointer event types
			 * are the same.  Fail if intervening event's time
			 * differs from victim's.
			 */
			if (victim->prev != base) {
				if (!evq_eqt(victim->prev->io_event.time,
				    victim->io_event.time))
					goto Advance_Base;
			}
			/* Fail if time difference is above threshold */
			tv_diff = evq_subt(victim->io_event.time,
			    base->io_event.time);
			/* Zero factor means collapse regardless of threshold */
			if ((factor > 0) &&
			    (timercmp(&tv_diff, &tv_threshold, >)))
				goto Advance_Base;
			/* Do collapse if same event type */
			if (victim->io_event.vse_type == base->io_event.vse_type){

				switch (base->io_event.vse_type ) {
				case VSE_BUTTON:
					base->io_event.vse_key =
					    victim->io_event.vse_key;
					break;
					
				case VSE_MMOTION:
				case VSE_TMOTION:
					base->io_event.vse_x =
					    victim->io_event.vse_x;
					base->io_event.vse_y =
					    victim->io_event.vse_y;
					break;

				default:
					/* reports error	*/
					printf("error of vse_type in evq_compress\n");
					break;
				}
				/* Remove victim node */
				evq_delete_node(vq, victim);
			}
		}
Advance_Base:
	{}
	}
	return (num_start - vq->num);
}
evq_is_pointer(vqn)
	register Event_q_node *vqn;
{
	return ( (vqn->io_event.vse_type == VSE_MMOTION ) ||
	    (vqn->io_event.vse_type == VSE_TMOTION ));
}

void
evq_delete_node(vq, vqn)
	register Event_queue *vq;
	register Event_q_node *vqn;
{
	/* Use get if removing off top of queue */
	if (vqn == vq->top) {
		(void) evq_get(vq, EVQ_EVENT_NULL);
		return;
	}
	/* Update previous next link (not null else vqn would be top) */
	vqn->prev->next = vqn->next;
	/* Change bottom */
	if (vq->bottom == vqn)
		vq->bottom = vqn->prev;
	else
		/* Update next previous link (if null else vqn is bottom) */
		vqn->next->prev = vqn->prev;
	/* Release storage */
	evq_free_node(vq, vqn);
	return;
}

/*
 * Caller must initialize data returned from evq_alloc_node.
 * EVENT_Q_NODE_NULL is possible.
 */
Event_q_node *
evq_alloc_node(vq)
	register Event_queue *vq;
{
	register Event_q_node *vqn;

	if (vq->free == EVENT_Q_NODE_NULL)
		return(EVENT_Q_NODE_NULL);
	vqn = vq->free;
	vq->free = vq->free->next;
	vq->num++;
	vqn->next = EVENT_Q_NODE_NULL;
	return(vqn);
}

void
evq_free_node(vq, vqn)
	register Event_queue *vq;
	Event_q_node *vqn;
{
	vqn->next = vq->free;
	vqn->prev = EVENT_Q_NODE_NULL;
	vq->free = vqn;
	vq->num--;
}

static int
evq_eqt(a, b)
	struct timeval a, b;
{
	return(a.tv_sec == b.tv_sec && a.tv_usec == b.tv_usec);
}

/* atv-btv */
struct	timeval
evq_subt(atv, btv)
	struct	timeval atv, btv;
{
	if ((atv.tv_usec < btv.tv_usec) && atv.tv_sec) {
		atv.tv_usec += 1000000;
		atv.tv_sec--;
	}
	if (atv.tv_usec > btv.tv_usec)
		atv.tv_usec -= btv.tv_usec;
	else
		atv.tv_usec = 0;
	if (atv.tv_sec > btv.tv_sec)
		atv.tv_sec -= btv.tv_sec;
	else {
		if  (atv.tv_sec < btv.tv_sec)
			atv.tv_usec = 0;
		atv.tv_sec = 0;
	}
	return(atv);
}

/* tv / dividend */
struct	timeval
evq_divide(tv, dividend)
	struct	timeval tv;
	int	dividend;
{
	int usecs;

	if (dividend == 0)
		return (tv);
	usecs = tv_to_usec(tv);
	usecs /= dividend;
	tv = ut_to_tv(usecs);
	return (tv);
}

/* tv * multiplier (works for small multipliers * seconds, < 1000) */
struct	timeval
evq_mult(tv, multiplier)
	struct	timeval tv;
	int	multiplier;
{
	int usecs;

	usecs = tv_to_usec(tv);
	usecs *= multiplier;
	tv = ut_to_tv(usecs);
	return (tv);
}

struct	timeval
ut_to_tv(usec)
	int	usec;
{
	struct	timeval tv;

	tv.tv_sec = usec / 1000000;
	tv.tv_usec = usec % 1000000;
	return (tv);
}




