/*
 * $Header: dt_event.h,v 1.1 89/01/23 17:15:39 rml Exp $
 */
/*
 * Event queue entries
 */

typedef struct  _vs_event {
        int vse_x;	/* x position */
        int vse_y;	/* y position */
        struct timeval  time;   /* Event's time stamp */
        char    vse_type;       /* button or motion? */
#define VSE_BUTTON      0x0             /* button moved */
#define VSE_MMOTION     0x1             /* mouse moved */
#define VSE_TMOTION     0x2             /* tablet moved */
        unsigned char  vse_key;	/* the key (button only) */
#define VSE_LEFT_BUTTON   0
#define VSE_MIDDLE_BUTTON 1
#define VSE_RIGHT_BUTTON  2
        char    vse_direction;	/* which direction (button only) */
#define VSE_KBTUP       0               /* up */
#define VSE_KBTDOWN     1               /* down */
#define VSE_KBTRAW	    2		        /* undetermined */
        char    vse_device;	    /* which device (button only) */
#define VSE_NULL	    0		        /* NULL event (for QD_GETEVENT ret) */
#define VSE_MOUSE       1               /* mouse */
#define VSE_DKB         2               /* main keyboard */
#define VSE_TABLET      3               /* graphics tablet */
#define VSE_AUX         4               /* auxiliary */
#define VSE_CONSOLE     5               /* console */
} vsEvent;

/* vse_device field */

/* mouse cursor position */

typedef struct _vs_cursor {
        int x;
        int y;
} vsCursor;

/* mouse motion rectangle */

typedef struct _vs_box {
        int bottom;
        int right;
        int left;
        int top;
} vsBox;
