/*
 * $Header: bwfbKeyMap.c,v 1.1 89/01/23 17:15:19 rml Exp $
 */
#include	"bwfb.h"
#include	"keysym.h"

/*
 *	XXX - Its not clear what to map these to for now.
 *	keysyms.h doesn't define enough function key names.
 */


#define	ASCII_GLYPHS_PER_KEY	2
#define	ASCII_MIN_KEY	0
#define	ASCII_MAX_KEY	0x83 /* add modifier keys */
#define	ASCII_CONTROL	0x11
#define	ASCII_LEFT_SHIFT	0x12
#define	ASCII_LOCK		0x14
#define	ASCII_ALT_L	0x19
#define ASCII_ALT_R	0x39
#define	ASCII_ACTION	0x58
#define	ASCII_RIGHT_SHIFT	0x59

static KeySym AsciiMap[MAP_LENGTH*ASCII_GLYPHS_PER_KEY] = {
/* Scan Code */	/* X11 Equivalent */	/* Key 	*/
/* 0x000  */	0xff00,	 NoSymbol,		/* ^@	*/
/* 0x001  */	0xff01,	 NoSymbol,		/* ^a	*/
/* 0x002  */	0xff02,	 NoSymbol,		/* ^b	*/
/* 0x003  */	0xff03,  NoSymbol,		/* ^c	*/
/* 0x004  */	0xff04,  NoSymbol,		/* ^d	*/
/* 0x005  */	0xff05,  NoSymbol,		/* ^e	*/
/* 0x006  */	0xff06,  NoSymbol,		/* ^f	*/
/* 0x007  */	0xff07,  NoSymbol,		/* ^g	*/
/* 0x008  */	XK_BackSpace,  NoSymbol,	/* ^h	*/
/* 0x009  */	XK_Tab,  NoSymbol,		/* ^i	*/
/* 0x00a  */	XK_Linefeed,  NoSymbol,		/* ^j	*/
/* 0x00b  */	XK_Clear,  NoSymbol,		/* ^k	*/
/* 0x00c  */	0xff0c,  NoSymbol,		/* ^l	*/
/* 0x00d  */	XK_Return,  NoSymbol,		/* ^m	*/
/* 0x00e  */	0xff0e,  NoSymbol,		/* ^n	*/
/* 0x00f  */	0xff0f,  NoSymbol,		/* ^o	*/
/* 0x010  */	0xff10,  NoSymbol,		/* ^p	*/
/* 0x011  */	0xff11,  NoSymbol,		/* ^q	*/
/* 0x012  */	0xff12,  NoSymbol,		/* ^r	*/
/* 0x013  */	XK_Pause,  NoSymbol,		/* ^s	*/
/* 0x014  */	0xff14,  NoSymbol,		/* ^t	*/
/* 0x015  */	0xff15,  NoSymbol,		/* ^u	*/
/* 0x016  */	0xff16,  NoSymbol,		/* ^v	*/
/* 0x017  */	0xff17,  NoSymbol,		/* ^w	*/
/* 0x018  */	0xff18,  NoSymbol,		/* ^x	*/
/* 0x019  */	0xff19,  NoSymbol,		/* ^y	*/
/* 0x01a  */	0xff1a,  NoSymbol,		/* ^z   */
/* 0x01b  */	XK_Escape,  NoSymbol,		/* ^[	*/
/* 0x01c  */	0xff1c,  NoSymbol,		/* ^\	*/
/* 0x01d  */	NoSymbol,  NoSymbol,
/* 0x01e  */	NoSymbol,  NoSymbol,
/* 0x01f  */	NoSymbol,  NoSymbol,
/* 0x020  */	XK_space,  NoSymbol,
/* 0x021  */	XK_exclam,  NoSymbol,
/* 0x022  */	XK_quotedbl,  NoSymbol,
/* 0x023  */	XK_numbersign,  NoSymbol,
/* 0x024  */	XK_dollar,  NoSymbol,
/* 0x025  */	XK_percent,  NoSymbol,
/* 0x026  */	XK_ampersand,  NoSymbol,
/* 0x027  */	XK_quoteright,  NoSymbol,
/* 0x028  */	XK_parenleft,  NoSymbol,
/* 0x029  */	XK_parenright,  NoSymbol,
/* 0x02a  */	XK_asterisk,  NoSymbol,
/* 0x02b  */	XK_plus,  NoSymbol,
/* 0x02c  */	XK_comma,  NoSymbol,
/* 0x02d  */	XK_minus,  NoSymbol,
/* 0x02e  */	XK_period,  NoSymbol,
/* 0x02f  */	XK_slash,  NoSymbol,
/* 0x030  */	XK_0,  NoSymbol,
/* 0x031  */	XK_1,  NoSymbol,
/* 0x032  */	XK_2,  NoSymbol,
/* 0x033  */	XK_3,  NoSymbol,
/* 0x034  */	XK_4,  NoSymbol,
/* 0x035  */	XK_5,  NoSymbol,
/* 0x036  */	XK_6,  NoSymbol,
/* 0x037  */	XK_7,  NoSymbol,
/* 0x038  */	XK_8,  NoSymbol,
/* 0x039  */	XK_9,  NoSymbol,
/* 0x03a  */	XK_colon,  NoSymbol,
/* 0x03b  */	XK_semicolon,  NoSymbol,
/* 0x03c  */	XK_less,  NoSymbol,
/* 0x03d  */	XK_equal,  NoSymbol,
/* 0x03e  */	XK_greater,  NoSymbol,
/* 0x03f  */	XK_question,  NoSymbol,
/* 0x040  */	XK_at,  NoSymbol,
/* 0x041  */	XK_A,  NoSymbol,
/* 0x042  */	XK_B,  NoSymbol,
/* 0x043  */	XK_C,  NoSymbol,
/* 0x044  */	XK_D,  NoSymbol,
/* 0x045  */	XK_E,  NoSymbol,
/* 0x046  */	XK_F,  NoSymbol,
/* 0x047  */	XK_G,  NoSymbol,
/* 0x048  */	XK_H,  NoSymbol,
/* 0x049  */	XK_I,  NoSymbol,
/* 0x04a  */	XK_J,  NoSymbol,
/* 0x04b  */	XK_K,  NoSymbol,
/* 0x04c  */	XK_L,  NoSymbol,
/* 0x04d  */	XK_M,  NoSymbol,
/* 0x04e  */	XK_N,  NoSymbol,
/* 0x04f  */	XK_O,  NoSymbol,
/* 0x050  */	XK_P,  NoSymbol,
/* 0x051  */	XK_Q,  NoSymbol,
/* 0x052  */	XK_R,  NoSymbol,
/* 0x053  */	XK_S,  NoSymbol,
/* 0x054  */	XK_T,  NoSymbol,
/* 0x055  */	XK_U,  NoSymbol,
/* 0x056  */	XK_V,  NoSymbol,
/* 0x057  */	XK_W,  NoSymbol,
/* 0x058  */	XK_X,  NoSymbol,
/* 0x059  */	XK_Y,  NoSymbol,
/* 0x05a  */	XK_Z,  NoSymbol,
/* 0x05b  */	XK_bracketleft,  NoSymbol,
/* 0x05c  */	XK_backslash,  NoSymbol,
/* 0x05d  */	XK_bracketright,  NoSymbol,
/* 0x05e  */	XK_asciicircum,  NoSymbol,
/* 0x05f  */	XK_underscore,  NoSymbol,
/* 0x060  */	XK_quoteleft,  NoSymbol,
/* 0x061  */	XK_A,  NoSymbol,
/* 0x062  */	XK_B,  NoSymbol,
/* 0x063  */	XK_C,  NoSymbol,
/* 0x064  */	XK_D,  NoSymbol,
/* 0x065  */	XK_E,  NoSymbol,
/* 0x066  */	XK_F,  NoSymbol,
/* 0x067  */	XK_G,  NoSymbol,
/* 0x068  */	XK_H,  NoSymbol,
/* 0x069  */	XK_I,  NoSymbol,
/* 0x06a  */	XK_J,  NoSymbol,
/* 0x06b  */	XK_K,  NoSymbol,
/* 0x06c  */	XK_L,  NoSymbol,
/* 0x06d  */	XK_M,  NoSymbol,
/* 0x06e  */	XK_N,  NoSymbol,
/* 0x06f  */	XK_O,  NoSymbol,
/* 0x070  */	XK_P,  NoSymbol,
/* 0x071  */	XK_Q,  NoSymbol,
/* 0x072  */	XK_R,  NoSymbol,
/* 0x073  */	XK_S,  NoSymbol,
/* 0x074  */	XK_T,  NoSymbol,
/* 0x075  */	XK_U,  NoSymbol,
/* 0x076  */	XK_V,  NoSymbol,
/* 0x077  */	XK_W,  NoSymbol,
/* 0x078  */	XK_X,  NoSymbol,
/* 0x079  */	XK_Y,  NoSymbol,
/* 0x07a  */	XK_Z,  NoSymbol,
/* 0x07b  */	XK_braceleft,  NoSymbol,
/* 0x07c  */	XK_bar,  NoSymbol,
/* 0x07d  */	XK_braceright,  NoSymbol,
/* 0x07e  */	XK_asciitilde,  NoSymbol,
/* 0x07f  */	XK_Delete,  NoSymbol,
/* 0x080  */	XK_Shift_L, XK_Shift_R,
/* 0x081  */	XK_Control_L, XK_Control_R,
/* 0x082  */	XK_Shift_Lock, XK_Shift_Lock,
/* 0x083  */	XK_Meta_L, XK_Meta_R
};


static KeySym Sun3Map[] = {
	XK_L1,		NoSymbol,		/* 0x01 */
	NoSymbol,	NoSymbol,		/* 0x02 */
	XK_L2,		NoSymbol,		/* 0x03 */
	NoSymbol,	NoSymbol,		/* 0x4 */
	XK_F1,		NoSymbol,		/* 0x5 */
	XK_F2,		NoSymbol,		/* 0x6 */
	NoSymbol,	NoSymbol,		/* 0x7 */
	XK_F3,		NoSymbol,		/* 0x8 */
	NoSymbol,	NoSymbol,		/* 0x9 */
	XK_F4,		NoSymbol,		/* 0xa */
	NoSymbol,	NoSymbol,		/* 0xb */
	XK_F5,		NoSymbol,		/* 0xc */
	NoSymbol,	NoSymbol,		/* 0xd */
	XK_F6,		NoSymbol,		/* 0xe */
	NoSymbol,	NoSymbol,		/* 0xf */
	XK_F7,		NoSymbol,		/* 0x10 */
	XK_F8,		NoSymbol,		/* 0x11 */
	XK_F9,		NoSymbol,		/* 0x12 */
	XK_Break,	NoSymbol,		/* 0x13 */
	NoSymbol,	NoSymbol,		/* 0x14 */
	XK_R1,		NoSymbol,		/* 0x15 */
	XK_R2,		NoSymbol,		/* 0x16 */
	XK_R3,		NoSymbol,		/* 0x17 */
	NoSymbol,	NoSymbol,		/* 0x18 */
	XK_L3,		NoSymbol,		/* 0x19 */
	XK_L4,		NoSymbol,		/* 0x1a */
	NoSymbol,	NoSymbol,		/* 0x1b */
	NoSymbol,	NoSymbol,		/* 0x1c */
	XK_Escape,	NoSymbol,		/* 0x1d */
	XK_1,		XK_exclam,		/* 0x1e */
	XK_2,		XK_at,			/* 0x1f */
	XK_3,		XK_numbersign,		/* 0x20 */
	XK_4,		XK_dollar,		/* 0x21 */
	XK_5,		XK_percent,		/* 0x22 */
	XK_6,		XK_asciicircum,		/* 0x23 */
	XK_7,		XK_ampersand,		/* 0x24 */
	XK_8,		XK_asterisk,		/* 0x25 */
	XK_9,		XK_parenleft,		/* 0x26 */
	XK_0,		XK_parenright,		/* 0x27 */
	XK_minus,	XK_underscore,		/* 0x28 */
	XK_equal,	XK_plus,		/* 0x29 */
	XK_quoteleft,	XK_asciitilde,		/* 0x2a */
	XK_BackSpace,	NoSymbol,		/* 0x2b */
	NoSymbol,	NoSymbol,		/* 0x2c */
	XK_R4,		NoSymbol,		/* 0x2d */
	XK_R5,		NoSymbol,		/* 0x2e */
	XK_R6,		NoSymbol,		/* 0x2f */
	NoSymbol,	NoSymbol,		/* 0x30 */
	XK_L5,		NoSymbol,		/* 0x31 */
	NoSymbol,	NoSymbol,		/* 0x32 */
	XK_L6,		NoSymbol,		/* 0x33 */
	NoSymbol,	NoSymbol,		/* 0x34 */
	XK_Tab,		NoSymbol,		/* 0x35 */
	XK_Q,		NoSymbol,		/* 0x36 */
	XK_W,		NoSymbol,		/* 0x37 */
	XK_E,		NoSymbol,		/* 0x38 */
	XK_R,		NoSymbol,		/* 0x39 */
	XK_T,		NoSymbol,		/* 0x3a */
	XK_Y,		NoSymbol,		/* 0x3b */
	XK_U,		NoSymbol,		/* 0x3c */
	XK_I,		NoSymbol,		/* 0x3d */
	XK_O,		NoSymbol,		/* 0x3e */
	XK_P,		NoSymbol,		/* 0x3f */
	XK_bracketleft,	XK_braceleft,		/* 0x40 */
	XK_bracketright,	XK_braceright,	/* 0x41 */
	XK_Delete,	NoSymbol,		/* 0x42 */
	NoSymbol,	NoSymbol,		/* 0x43 */
	XK_R7,		NoSymbol,		/* 0x44 */
	XK_Up,		XK_R8,			/* 0x45 */
	XK_R9,		NoSymbol,		/* 0x46 */
	NoSymbol,	NoSymbol,		/* 0x47 */
	XK_L7,		NoSymbol,		/* 0x48 */
	XK_L8,		NoSymbol,		/* 0x49 */
	NoSymbol,	NoSymbol,		/* 0x4a */
	NoSymbol,	NoSymbol,		/* 0x4b */
	XK_Control_L,	NoSymbol,		/* 0x4c */
	XK_A,		NoSymbol,		/* 0x4d */
	XK_S,		NoSymbol,		/* 0x4e */
	XK_D,		NoSymbol,		/* 0x4f */
	XK_F,		NoSymbol,		/* 0x50 */
	XK_G,		NoSymbol,		/* 0x51 */
	XK_H,		NoSymbol,		/* 0x52 */
	XK_J,		NoSymbol,		/* 0x53 */
	XK_K,		NoSymbol,		/* 0x54 */
	XK_L,		NoSymbol,		/* 0x55 */
	XK_semicolon,	XK_colon,		/* 0x56 */
	XK_quoteright,	XK_quotedbl,		/* 0x57 */
	XK_backslash,	XK_bar,			/* 0x58 */
	XK_Return,	NoSymbol,		/* 0x59 */
	NoSymbol,	NoSymbol,		/* 0x5a */
	XK_Left,	XK_R10,			/* 0x5b */
	XK_R11,		NoSymbol,		/* 0x5c */
	XK_Right,	NoSymbol,		/* 0x5d */
	NoSymbol,	NoSymbol,		/* 0x5e */
	XK_L9,		NoSymbol,		/* 0x5f */
	NoSymbol,	NoSymbol,		/* 0x60 */
	XK_L10,		NoSymbol,		/* 0x61 */
	NoSymbol,	NoSymbol,		/* 0x62 */
	XK_Shift_L,	NoSymbol,		/* 0x63 */
	XK_Z,		NoSymbol,		/* 0x64 */
	XK_X,		NoSymbol,		/* 0x65 */
	XK_C,		NoSymbol,		/* 0x66 */
	XK_V,		NoSymbol,		/* 0x67 */
	XK_B,		NoSymbol,		/* 0x68 */
	XK_N,		NoSymbol,		/* 0x69 */
	XK_M,		NoSymbol,		/* 0x6a */
	XK_comma,	XK_less,		/* 0x6b */
	XK_period,	XK_greater,		/* 0x6c */
	XK_slash,	XK_question,		/* 0x6d */
	XK_Shift_R,	NoSymbol,		/* 0x6e */
	XK_Linefeed,	NoSymbol,		/* 0x6f */
	XK_R13,		NoSymbol,		/* 0x70 */
	XK_Down,	XK_R14,			/* 0x71 */
	XK_R15,		NoSymbol,		/* 0x72 */
	NoSymbol,	NoSymbol,		/* 0x73 */
	NoSymbol,	NoSymbol,		/* 0x74 */
	NoSymbol,	NoSymbol,		/* 0x75 */
	NoSymbol,	NoSymbol,		/* 0x76 */
	XK_Caps_Lock,	NoSymbol,		/* 0x77 */
	XK_Meta_L,	NoSymbol,		/* 0x78 */
	XK_space,	NoSymbol,		/* 0x79 */
	XK_Meta_R,	NoSymbol,		/* 0x7a */
	NoSymbol,	NoSymbol,		/* 0x7b */
	NoSymbol,	NoSymbol,		/* 0x7c */
	NoSymbol,	NoSymbol,		/* 0x7d */
	NoSymbol,	NoSymbol,		/* 0x7e */
	NoSymbol,	NoSymbol,		/* 0x7f */
};

KeySymsRec bwfbKeySyms[] = {
    /*	map	   minKeyCode	maxKC	width */
#ifdef	notdef
    KlunkMap,		1,	0x7a,	2,
    VT100Map,		1,	0x7a,	2,
#else
    (KeySym *)NULL,	0,	0,	0,
    (KeySym *)NULL,	0,	0,	0,
#endif
    AsciiMap,		ASCII_MIN_KEY,      
				ASCII_MAX_KEY,	
					ASCII_GLYPHS_PER_KEY,
    Sun3Map,		1,	0x7a,	2,
};

#ifdef notdef
typedef struct {		/* XXX temporary	*/
	KeyCode lock;
	KeyCode shiftA, shiftB;
	KeyCode controlA, controlB;
	KeyCode mod1A, mod1B;
	KeyCode mod2A, mod2B;
	KeyCode mod3A, mod3B;
	KeyCode mod4A, mod4B;
	KeyCode mod5A, mod5B;
	}  ModifierMapRec, *ModifierMapPtr;

ModifierMapRec bwfbMapRec[] = {
/*	lock shiftA shiftB ctrlA ctrlB m1a m1b m2a m2b m3a m3b m4a m4b m5a m5b */
    {    0,    0,     0,     0,   0,   0,    0,  0, 0,  0,  0,  0,  0,  0,  0,},
    {    0,    0,     0,     0,   0,   0,    0,  0, 0,  0,  0,  0,  0,  0,  0,},
    {	LockKeyCode, 
	       ShiftKeyCode,  
		      0x00, ControlKeyCode,  
				    0, MetaKeyCode, 0, 0, 0,  0,  0,  0,  0,  0,  0,},
    {	0, 0x63,  0x6e, 0x4c,  0, 0x78, 0x7a, 0, 0,  0,  0,  0,  0,  0,  0,},
};
#endif

CARD8	modMap[MAP_LENGTH];

#define	KEY_SHIFT 	0x080
#define	KEY_CTRL	0x081
#define	KEY_LOCK	0x082
#define	KEY_COMPOSE	0x083

GetModMappings(pKeyboard)
DevicePtr pKeyboard;
{
    int	i;
    KbPrivRec	*pPriv = pKeyboard->devicePrivate;

    for (i = MIN_KEYCODE; i < MAP_LENGTH; i++)
	modMap[i] = NoSymbol;

    modMap[KEY_LOCK + pPriv->offset]    = LockMask;
    modMap[KEY_SHIFT + pPriv->offset]   = ShiftMask;
    modMap[KEY_CTRL + pPriv->offset]    = ControlMask;
    modMap[KEY_COMPOSE + pPriv->offset] = Mod1Mask;
}
