/*
 * $Header: bwfbKbd.c,v 1.1 89/01/23 17:15:13 rml Exp $
 */
/*-
 * bwfbKbd.c --
 *	Functions for retrieving data from a keyboard.
 */
#define NEED_EVENTS
#include "bwfb.h"

#ifdef HAS_KBD
#include <stdio.h>
#include "Xproto.h"
#include "keysym.h"

typedef struct {
    int	    	  trans;          	/* Original translation form */
} bwfbKbPrivRec, *bwfbKbPrivPtr;

typedef struct {	/* XXX temporary !	*/
	KeyCode lock;
	KeyCode shiftA, shiftB;
	KeyCode controlA, controlB;
	KeyCode mod1A, mod1B;
	KeyCode mod2A, mod2B;
	KeyCode mod3A, mod3B;
	KeyCode mod4A, mod4B;
	KeyCode mod5A, mod5B;
	}  ModifierMapRec, *ModifierMapPtr;

extern ModifierMapRec bwfbMapRec[];
extern KeySymsRec bwfbKeySyms[];

static void 	  bwfbBell();
static void 	  bwfbKbdCtrl();
static vsEvent *bwfbKbdGetEvents();
static void 	  bwfbKbdProcessEvent();
static void 	  bwfbKbdDoneEvents();


static bwfbKbPrivRec	bwfbKbPriv;  
static KbPrivRec  	sysKbPriv = {
    -1,				/* Type of keyboard */
    -1,				/* Descriptor open to device */
    bwfbKbdGetEvents,		/* Function to read events */
    bwfbKbdProcessEvent,		/* Function to process an event */
    bwfbKbdDoneEvents,		/* Function called when all events */
				/* have been handled. */
    0,				/* offset into modifier map */
    (pointer)&bwfbKbPriv,	/* Private to keyboard device */
};

#ifdef ISWINDOWS
extern int indev;
extern	CARD8	modMap[];
#endif

/*-
 *-----------------------------------------------------------------------
 * bwfbKbdProc --
 *	Handle the initialization, etc. of a keyboard.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *
 * Note:
 *
 *-----------------------------------------------------------------------
 */
int
bwfbKbdProc (pKeyboard, what)
    DevicePtr	  pKeyboard;	/* Keyboard to manipulate */
    int	    	  what;	    	/* What to do to it */
{
    KbPrivPtr	  pPriv;
    register int  kbdFd;
	int format;

    switch (what) {
	case DEVICE_INIT:
	    if (pKeyboard != LookupKeyboardDevice()) {
		ErrorF ("Cannot open non-system keyboard");
		return (!Success);
	    }
	    
	    /*
	     * First open and find the current state of the keyboard.
	     */
	    if (sysKbPriv.fd >= 0) {
		kbdFd = sysKbPriv.fd;
	    } else {
#ifdef ISWINDOWS
#undef LDISC
		kbdFd = indev;
		sysKbPriv.type = KB_DT_2;
#else
		kbdFd = open ("/dev/kbd", O_RDWR, 0);
		if (kbdFd < 0) {
		    Error ("Opening /dev/kbd");
		    return (!Success);
		}
#endif
		sysKbPriv.fd = kbdFd;
#ifdef LDISC
		format = MKBLDISC;
		if (ioctl (kbdFd, TIOCSETD , &format) < 0) {
		  Error ("TIOCSETD");
		  return(!Success);
		}
		format = KB_DT_2;
		if (ioctl (kbdFd, KIOCSTYPE , &format) < 0) {
		  Error ("KIOCSTYPE");
		  return(!Success);
		}
#endif LDISC
#ifndef ISWINDOWS
		(void) ioctl (kbdFd, KIOCGTYPE, &sysKbPriv.type);
		(void) ioctl (kbdFd, KIOGMODE, &bwfbKbPriv.trans);
#endif
		if (sysKbPriv.type < 0 || sysKbPriv.type > KB_DT_3
		    || bwfbKeySyms[sysKbPriv.type].map == NULL)
		    FatalError("Unsupported keyboard type %d\n", sysKbPriv.type);
		if (fcntl (kbdFd, F_SETFL, (FNDELAY|FASYNC)) < 0
			|| fcntl(kbdFd, F_SETOWN, getpid()) < 0) {
			perror("bwfbKbdProc");
			FatalError("Can't set up kbd on fd %d\n", kbdFd);
		}
	    }

	    /*
	     * Perform final initialization of the system private keyboard
	     * structure and fill in various slots in the device record
	     * itself which couldn't be filled in before.
	     */
	    pKeyboard->devicePrivate = (pointer)&sysKbPriv;

	    if (bwfbKeySyms[sysKbPriv.type].minKeyCode < MIN_KEYCODE) {
		int offset = MIN_KEYCODE -
			     bwfbKeySyms[sysKbPriv.type].minKeyCode;

		bwfbKeySyms[sysKbPriv.type].minKeyCode += offset;
		bwfbKeySyms[sysKbPriv.type].maxKeyCode += offset;
		sysKbPriv.offset = offset;
	    }
	    pKeyboard->on = FALSE;
#ifdef ISWINDOWS
	    GetModMappings(pKeyboard);
	    InitKeyboardDeviceStruct(
		    pKeyboard,
		    &(bwfbKeySyms[sysKbPriv.type]),
		    modMap,
		    bwfbBell,
		    bwfbKbdCtrl);
#else
	    InitKeyboardDeviceStruct(
		    pKeyboard,
		    &(bwfbKeySyms[sysKbPriv.type]),
		    &(bwfbMapRec[sysKbPriv.type]),
		    bwfbBell,
		    bwfbKbdCtrl);
#endif
	    break;

	case DEVICE_ON:
		pPriv = (KbPrivPtr)pKeyboard->devicePrivate;
		kbdFd = pPriv->fd;

	        /*
	         * Set the keyboard into "direct" mode and turn on
	         * event translation.
	         */
		if (bwfbChangeKbdTranslation(pKeyboard,TRUE) < 0) {
		    FatalError("Can't set keyboard translation\n");
		}

		AddEnabledDevice(kbdFd);
	    pKeyboard->on = TRUE;
	    break;

	case DEVICE_CLOSE:
	case DEVICE_OFF:
		pPriv = (KbPrivPtr)pKeyboard->devicePrivate;
		kbdFd = pPriv->fd;
	    
	        /*
	         * Restore original keyboard directness and translation.
	         */
		if (bwfbChangeKbdTranslation(pKeyboard,FALSE) < 0) {
		    FatalError("Can't reset keyboard translation\n");
		}

		RemoveEnabledDevice(kbdFd);
	    pKeyboard->on = FALSE;
	    break;
    }
    return (Success);
}

/*-
 *-----------------------------------------------------------------------
 * bwfbBell --
 *	Ring the terminal/keyboard bell
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	None, really...
 *
 *-----------------------------------------------------------------------
 */
static void
bwfbBell (loudness, pKeyboard)
    int	    	  loudness;	    /* Percentage of full volume */
    DevicePtr	  pKeyboard;	    /* Keyboard to ring */
{
    /* no can do, for now */
}

/*-
 *-----------------------------------------------------------------------
 * bwfbKbdCtrl --
 *	Alter some of the keyboard control parameters
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Some...
 *
 *-----------------------------------------------------------------------
 */
static void
bwfbKbdCtrl (pKeyboard)
    DevicePtr	  pKeyboard;	    /* Keyboard to alter */
{
    /* can only change key click on bwfb 3 keyboards, so what's the use? */
}

/*-
 *-----------------------------------------------------------------------
 * bwfbKbdGetEvents --
 *	Return the events waiting in the wings for the given keyboard.
 *
 * Results:
 *	A pointer to an array of vsEvents or (vsEvent *)0 if no events
 *	The number of events contained in the array.
 *
 * Side Effects:
 *	None.
 *-----------------------------------------------------------------------
 */
static vsEvent *
bwfbKbdGetEvents (pKeyboard, pNumEvents)
    DevicePtr	  pKeyboard;	    /* Keyboard to read */
    int	    	  *pNumEvents;	    /* Place to return number of events */
{
    int	    	  nBytes;	    /* number of bytes of events available. */
    KbPrivPtr	  pPriv;
    static vsEvent	evBuf[MAXEVENTS];   /* Buffer for vsEvents */

    pPriv = (KbPrivPtr) pKeyboard->devicePrivate;
    nBytes = read (pPriv->fd, evBuf, sizeof(evBuf));

    if (nBytes < 0) {
	if (errno == EWOULDBLOCK) {
	    *pNumEvents = 0;
	} else {
	    Error ("Reading keyboard");
	    FatalError ("Could not read the keyboard");
	}
    } else {
	*pNumEvents = nBytes / sizeof (vsEvent);
    }
    return (evBuf);
}

/*-
 *-----------------------------------------------------------------------
 * bwfbKbdProcessEvent --
 *
 * Results:
 *
 * Side Effects:
 *
 *-----------------------------------------------------------------------
 */
static void
bwfbKbdProcessEvent (pKeyboard, fe)
    DevicePtr	  pKeyboard;
    vsEvent	  *fe;
{
    xEvent		xE;
    PtrPrivPtr	  	ptrPriv;

    ptrPriv = (PtrPrivPtr) LookupPointerDevice()->devicePrivate;

    xE.u.keyButtonPointer.time = TVTOMILLI(fe->time);
    xE.u.keyButtonPointer.rootX = ptrPriv->x;
    xE.u.keyButtonPointer.rootY = ptrPriv->y;
    xE.u.u.type = ((fe->vse_direction == VSE_KBTUP) ? KeyRelease : KeyPress);
    xE.u.u.detail = (fe->vse_key & 0x7F);

    (* pKeyboard->processInputProc) (&xE, pKeyboard);
}

/*-
 *-----------------------------------------------------------------------
 * bwfbDoneEvents --
 *	Nothing to do, here...
 *
 * Results:
 *
 * Side Effects:
 *
 *-----------------------------------------------------------------------
 */
static void
bwfbKbdDoneEvents (pKeyboard)
    DevicePtr	  pKeyboard;
{
}

/*-
 *-----------------------------------------------------------------------
 * bwfbChangeKbdTranslation
 *	Makes operating system calls to set keyboard translation 
 *	and direction on or off.
 *
 * Results:
 *	-1 if failure, else 0.
 *
 * Side Effects:
 * 	Changes kernel management of keyboard.
 *
 *-----------------------------------------------------------------------
 */
int
bwfbChangeKbdTranslation(pKeyboard,makeTranslated)
    DevicePtr pKeyboard;
    Bool makeTranslated;
{   
    KbPrivPtr	pPriv;
    int 	kbdFd;
    int 	tmp;

#ifdef ISWINDOWS
	return(0);
#endif

    pPriv = (KbPrivPtr)pKeyboard->devicePrivate;
    kbdFd = pPriv->fd;

    if (makeTranslated) {
        /*
         * Next set the keyboard into "direct" mode and turn on
         * event translation. If either of these fails, we can't go
         * on.
         */
#ifdef TODO
	/*
	 * Next set the keyboard into "direct" mode and turn on
	 * event translation. If either of these fails, we can't go
	 * on.
	 */
	tmp = 1;
	if (ioctl (kbdFd, KIOCSDIRECT, &tmp) < 0) {
	    Error ("Setting keyboard direct mode");
	    return (-1);
	}
#endif TODO
	tmp = KB_EV_MODE;
	if (ioctl (kbdFd, KIOSMODE, &tmp) < 0) {
	    Error ("Setting keyboard translation");
	    return (-1);
	}
    }
    else {
#ifdef TODO
        /*
         * Next set the keyboard into "indirect" mode and turn off
         * event translation.
         */
	tmp = 0;
	(void)ioctl (kbdFd, KIOCSDIRECT, &tmp);
#endif TODO
	tmp = ((bwfbKbPrivPtr)pPriv->devPrivate)->trans;
	(void)ioctl (kbdFd, KIOSMODE, &tmp);
    }
    return(0);
}

Bool
LegalModifier(key)
{
    return (TRUE);
}


#endif HAS_KBD
