/*
 * $Header: bwfbIo.c,v 1.1 89/01/23 17:15:08 rml Exp $
 */
/*-
 * bwfbIo.c --
 *	Functions to handle input from the keyboard and mouse.
 *
 */

#include    "bwfb.h"
#include    "opaque.h"

Bool	    	screenSaved = FALSE;
int	    	lastEventTime = 0;
extern int	bwfbSigIO;
extern void	SaveScreens();

/*-
 *-----------------------------------------------------------------------
 * TimeSinceLastInputEvent --
 *	Function used for screensaver purposes by the os module.
 *
 * Results:
 *	The time in milliseconds since there last was any
 *	input.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
int
TimeSinceLastInputEvent()
{
    struct timeval	now;

    gettimeofday (&now, (struct timezone *)0);

    if (lastEventTime == 0) {
	lastEventTime = TVTOMILLI(now);
    }
    return TVTOMILLI(now) - lastEventTime;
}

#ifndef ISWINDOWS
/*-
 *-----------------------------------------------------------------------
 * ProcessInputEvents --
 *	Retrieve all waiting input events and pass them to DIX in their
 *	correct chronological order. Only reads from the system pointer
 *	and keyboard.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Events are passed to the DIX layer.
 *
 *-----------------------------------------------------------------------
 */
void
ProcessInputEvents ()
{
    register vsEvent *kbdEvents;	/* Current keyboard event */
    register int numKbdEvents;   	/* Number of remaining keyboard events */
    int nKE;    	    			/* Original number of keyboard events */
    DevicePtr		    pKeyboard;
    register KbPrivPtr  kbdPriv;

    register vsEvent    *ptrEvents;    	/* Current pointer event */
    register int	    numPtrEvents; 	/* Number of remaining pointer events */
    int	    	  	    nPE;    	    	/* Original number of pointer events */
    DevicePtr		    pPointer;
    register PtrPrivPtr     ptrPriv;
    vsEvent	  	    *lastEvent;	    	/* Last event processed */
    enum {
	NoneYet, Ptr, Kbd
    }			    lastType = NoneYet;	/* Type of last event */


    /*
     *  Defensive programming - only reset bwfbIOPending (preventing
     *  further calls to ProcessInputEvents() until a future SIGIO)
     *  if we have actually received a SIGIO,  so we know it works.
     */
    if (bwfbSigIO) {
	isItTimeToYield = 0;
    }
    pPointer = LookupPointerDevice();
    pKeyboard = LookupKeyboardDevice();

	ptrPriv = (PtrPrivPtr)pPointer->devicePrivate;
	kbdPriv = (KbPrivPtr)pKeyboard->devicePrivate;
	
	/*
	 * Get events from both the pointer and the keyboard, storing the number
	 * of events gotten in nPE and nKE and keeping the start of both arrays
	 * in pE and kE
	 */
	ptrEvents = (* ptrPriv->GetEvents) (pPointer, &nPE);
	kbdEvents = (* kbdPriv->GetEvents) (pKeyboard, &nKE);
	
	numPtrEvents = nPE;
	numKbdEvents = nKE;
	lastEvent = (vsEvent *)0;

	/*
	 * So long as one event from either device remains unprocess, we loop:
	 * Take the oldest remaining event and pass it to the proper module
	 * for processing. The DDXEvent will be sent to ProcessInput by the
	 * function called.
	 */
	while (numPtrEvents || numKbdEvents) {
	    if (numPtrEvents && numKbdEvents) {
		if (timercmp (&kbdEvents->time, &ptrEvents->time, <)) {
		    if (lastType == Ptr) {
			(* ptrPriv->DoneEvents) (pPointer, FALSE);
		    }
		    (* kbdPriv->ProcessEvent) (pKeyboard, kbdEvents);
		    numKbdEvents--;
		    lastEvent = kbdEvents++;
		    lastType = Kbd;
		} else {
		    if (lastType == Kbd) {
			(* kbdPriv->DoneEvents) (pKeyboard, FALSE);
		    }
		    (* ptrPriv->ProcessEvent) (pPointer, ptrEvents);
		    numPtrEvents--;
		    lastEvent = ptrEvents++;
		    lastType = Ptr;
		}
	    } else if (numKbdEvents) {
		if (lastType == Ptr) {
		    (* ptrPriv->DoneEvents) (pPointer, FALSE);
		}
		(* kbdPriv->ProcessEvent) (pKeyboard, kbdEvents);
		numKbdEvents--;
		lastEvent = kbdEvents++;
		lastType = Kbd;
	    } else {
		if (lastType == Kbd) {
		    (* kbdPriv->DoneEvents) (pKeyboard, FALSE);
		}
		(* ptrPriv->ProcessEvent) (pPointer, ptrEvents);
		numPtrEvents--;
		lastEvent = ptrEvents++;
		lastType = Ptr;
	    }
	}
    while (numPtrEvents) {
		(* ptrPriv->ProcessEvent) (pPointer, ptrEvents);
		numPtrEvents--;
		lastEvent = ptrEvents++;
	}

	if (lastEvent) {
	    lastEventTime = TVTOMILLI(lastEvent->time);
	    if (screenSaved) {
		SaveScreens(SCREEN_SAVER_FORCER, ScreenSaverReset);
	    }
	}
	
	(* kbdPriv->DoneEvents) (pKeyboard);
	(* ptrPriv->DoneEvents) (pPointer);

    bwfbRestoreCursor();

}
#endif


/*-
 *-----------------------------------------------------------------------
 * SetTimeSinceLastInputEvent --
 *	Set the lastEventTime to now.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	lastEventTime is altered.
 *
 *-----------------------------------------------------------------------
 */
void
SetTimeSinceLastInputEvent()
{
    struct timeval now;

    gettimeofday (&now, (struct timezone *)0);
    lastEventTime = TVTOMILLI(now);
}
