/*
 * $Header: bwfbInit.c,v 1.1 89/01/23 17:15:03 rml Exp $
 */
/*-
 * bwfbInit.c --
 *	Initialization functions for screen/keyboard/mouse, etc.
 */

#include    "bwfb.h"
#include    <servermd.h>
#include    "dixstruct.h"
#include    "dix.h"
#include    "opaque.h"

extern int bwfbMouseProc();
#ifdef HAS_KBD
extern void bwfbKbdProc();
#endif  NO_KBD
extern Bool ISIProbe();
#ifdef notdef
extern Bool HITProbe();
#endif
/*
 * XXX-COLOR add other probe routines here	
 */
extern void ProcessInputEvents();
extern void SetInputCheck();
extern char *strncpy();
extern GCPtr CreateScratchGC();

#define	XDEVICE	"XDEVICE"
#define	PARENT	"WINDOW_GFX"

int bwfbSigIO = 0;	 /* For use with SetInputCheck */

	/* What should this *really* be? */
#define MOTION_BUFFER_SIZE 0

/*-
 *-----------------------------------------------------------------------
 * SigIOHandler --
 *	Signal handler for SIGIO - input is available.
 *
 * Results:
 *	isItTimeToYield is set - ProcessInputEvents() will be called soon.
 *
 * Side Effects:
 *	None
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static void
SigIOHandler(sig, code, scp)
    int		code;
    int		sig;
    struct sigcontext *scp;
{
    bwfbSigIO++;
    isItTimeToYield++;
}

bwfbFbDataRec bwfbFbData[] = {
/*    ISIProbe,  	"/dev/ISIfb",	    neverProbed, /**/
    ISIProbe,	"/dev/fb",	    neverProbed,
/*    HITProbe,  	"/dev/hit0",	    neverProbed, */
	/* XXX-COLOR add device names */
};

/*
 * NUMSCREENS is the number of supported frame buffers (i.e. the number of
 * structures in bwfbFbData which have an actual probeProc).
 */
#define NUMSCREENS (sizeof(bwfbFbData)/sizeof(bwfbFbData[0]))
#define NUMDEVICES 2

fbFd	bwfbFbs[NUMSCREENS];  /* Space for descriptors of open frame buffers */

static PixmapFormatRec	formats[] = {
    1, 1, BITMAP_SCANLINE_PAD,	/* 1-bit deep */
    4, 4, BITMAP_SCANLINE_PAD,	/* 4-bit deep */
    8, 8, BITMAP_SCANLINE_PAD,	/* 8-bit deep */
};
#define NUMFORMATS	(sizeof formats)/(sizeof formats[0])

/*-
 *-----------------------------------------------------------------------
 * InitOutput --
 *	Initialize screenInfo for all actually accessible framebuffers.
 *	The
 *
 * Results:
 *	screenInfo init proc field set
 *
 * Side Effects:
 *	None
 *
 *-----------------------------------------------------------------------
 */

InitOutput(pScreenInfo, argc, argv)
    ScreenInfo 	  *pScreenInfo;
    int     	  argc;
    char    	  **argv;
{
    int     	  i, index, ac = argc;
	char		  **av = argv;
	int 		  nonBlockConsole = 1;

	while (ac--) {
		if (!strcmp(*av,"-debug")) {
			nonBlockConsole = 0;
			break;
		}
		av++;
	}
	/*
	 *        Writes to /dev/console can block - causing an
	 *        excess of error messages to hang the server in
	 *        deadlock.  So.......
	 */
	if (nonBlockConsole && (fcntl(2, F_SETFL, O_NDELAY) < 0)) {
		perror("fcntl");
		ErrorF("InitOutput: can't put stderr in non-block mode\n");
	}
    pScreenInfo->imageByteOrder = IMAGE_BYTE_ORDER;
    pScreenInfo->bitmapScanlineUnit = BITMAP_SCANLINE_UNIT;
    pScreenInfo->bitmapScanlinePad = BITMAP_SCANLINE_PAD;
    pScreenInfo->bitmapBitOrder = BITMAP_BIT_ORDER;

    pScreenInfo->numPixmapFormats = NUMFORMATS;
    for (i=0; i< NUMFORMATS; i++)
    {
        pScreenInfo->formats[i] = formats[i];
    }

    for (i = 0, index = 0; i < NUMSCREENS; i++) {
	if ((* bwfbFbData[i].probeProc) (pScreenInfo, index, i, argc, argv)) {
	    /* This display exists OK */
	    index++;
	} else {
	    /* This display can't be opened */
	    ;
	}
    }
    if (index == 0)
	FatalError("Can't find any displays\n");

    pScreenInfo->numScreens = index;

    bwfbInitCursor();
    signal(SIGWINCH, SIG_IGN);
}

/*-
 *-----------------------------------------------------------------------
 * InitInput --
 *	Initialize all supported input devices...what else is there
 *	besides pointer and keyboard?
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Two DeviceRec's are allocated and registered as the system pointer
 *	and keyboard devices.
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
InitInput(argc, argv)
    int     	  argc;
    char    	  **argv;
{
#ifdef HAS_KBD
    DevicePtr p, k;
    static int  zero = 0;
    k = AddInputDevice(bwfbKbdProc, TRUE);
    RegisterKeyboardDevice(k);
#else  HAS_KBD
    DevicePtr p;
    static int  zero = 0;
#endif HAS_KBD
    
    p = AddInputDevice(bwfbMouseProc, TRUE);

    RegisterPointerDevice(p, MOTION_BUFFER_SIZE);
    signal(SIGIO, SigIOHandler);

    SetInputCheck (&zero, &isItTimeToYield);
}

/*-
 *-----------------------------------------------------------------------
 * bwfbScreenInit --
 *	Things which must be done for all types of frame buffers...
 *	Should be called last of all.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	The graphics context for the screen is created. The CreateGC,
 *	CreateWindow and ChangeWindowAttributes vectors are changed in
 *	the screen structure.
 *
 *-----------------------------------------------------------------------
 */
void
bwfbScreenInit (pScreen)
    ScreenPtr	  pScreen;
{
    fbFd    	  *fb;
    DrawablePtr	  pDrawable;
    fb = &bwfbFbs[pScreen->myNum];

    /*
     * Prepare the GC for cursor functions on this screen.
     * Do this before setting interceptions to avoid looping when
     * putting down the cursor...
     */
    pDrawable = (DrawablePtr)(pScreen->devPrivate);

    fb->pGC = CreateScratchGC (pDrawable->pScreen, pDrawable->depth);

    /*
     * By setting graphicsExposures false, we prevent any expose events
     * from being generated in the CopyArea requests used by the cursor
     * routines.
     */
    fb->pGC->graphicsExposures = FALSE;

    /*
     * Preserve the "regular" functions
     */
    fb->CreateGC =	    	    	pScreen->CreateGC;
    fb->CreateWindow = 	    	    	pScreen->CreateWindow;
    fb->ChangeWindowAttributes =    	pScreen->ChangeWindowAttributes;
    fb->GetImage =	    	    	pScreen->GetImage;
    fb->GetSpans =			pScreen->GetSpans;

    /*
     * Interceptions
     */
    pScreen->CreateGC =	    	    	bwfbCreateGC;
    pScreen->CreateWindow = 	    	bwfbCreateWindow;
    pScreen->ChangeWindowAttributes = 	bwfbChangeWindowAttributes;
    pScreen->GetImage =	    	    	bwfbGetImage;
    pScreen->GetSpans =			bwfbGetSpans;

    /*
     * Cursor functions
     */
    pScreen->RealizeCursor = 	    	bwfbRealizeCursor;
    pScreen->UnrealizeCursor =	    	bwfbUnrealizeCursor;
    pScreen->DisplayCursor = 	    	bwfbDisplayCursor;
    pScreen->SetCursorPosition =    	bwfbSetCursorPosition;
    pScreen->CursorLimits = 	    	bwfbCursorLimits;
    pScreen->PointerNonInterestBox = 	bwfbPointerNonInterestBox;
    pScreen->ConstrainCursor = 	    	bwfbConstrainCursor;
    pScreen->RecolorCursor = 	    	bwfbRecolorCursor;

}

extern char *getenv();

/*-
 *-----------------------------------------------------------------------
 * nthdev --
 *	Return the nth device in a colon-separated list of devices.
 *	n is 0-origin.
 *
 * Results:
 *	A pointer to a STATIC string which is the device name.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
static char *
nthdev (dList, n)
    register char    *dList;	    /* Colon-separated device names */
    int	    n;	  	    /* Device number wanted */
{
    char *result;
    static char returnstring[100];

    while (n--) {
	while (*dList && *dList != ':') {
	    dList++;
	}
    }
    if (*dList) {
	register char *cp = dList;

	while (*cp && *cp != ':') {
	    cp++;
	}
	result = returnstring;
	strncpy (result, dList, cp - dList);
	result[cp - dList] = '\0';
    } else {
	result = (char *)0;
    }
    return (result);
}

/*-
 *-----------------------------------------------------------------------
 * bwfbOpenFrameBuffer --
 *	Open a frame buffer according to the rule:
 *	Find the device to use by looking in the bwfbFbData table,
 *	an XDEVICE envariable, a -dev switch or using /dev/fb if trying
 *	to open screen 0 and all else has failed.
 *
 * Results:
 *	The fd of the framebuffer.
 *
 * Side Effects:
 *
 *-----------------------------------------------------------------------
 */
int
bwfbOpenFrameBuffer(pfbType, index, fbNum, argc, argv)
/*    int	    	  expect;   	/* The expected type of framebuffer */
    struct fbtype *pfbType; 	/* Place to store the fb info */
    int	    	  fbNum;    	/* Index into the bwfbFbData array */
    int	    	  index;    	/* Screen index */
    int	    	  argc;	    	/* Command-line arguments... */
    char	  **argv;   	/* ... */
{
    char       	  *name=(char *)0;
    int           i;	    	/* Index into argument list */
    int           fd = -1;	    	/* Descriptor to device */
    static int	  devFbUsed=FALSE;  /* true if /dev/fb has been used for a */
    	    	  	    	    /* screen already */
    static Bool	  inited = FALSE;
    static char	  *xdevice; 	/* string of devices to use from environ */
    static char	  *devsw;   	/* string of devices from args */

    if (!inited) {
	xdevice = devsw = (char *)NULL;

	xdevice = getenv (XDEVICE);
	/*
	 * Look for an argument of the form -dev <device-string>
	 * If such a one is found place the <device-string> in devsw.
	 */
	for (i = 1; i < argc; i++) {
	    if ((strcmp(argv[i], "-dev") == 0) && (i + 1 < argc)) {
		devsw = argv[i+1];
		break;
	    }
	}
	inited = TRUE;
    }

    /*
     * Attempt to find a file name for the frame buffer 
     */

    /*
     * First see if any device was given on the command line.
     * If one was and the device is both readable and writeable,
     * set 'name' to it, else set it to NULL.
     */
    if (devsw == (char *)NULL ||
	(name = nthdev (devsw, index)) == (char *)NULL ||
	(access (name, R_OK | W_OK) != 0) ||
	(strcmp(name, bwfbFbData[fbNum].devName) != 0)) {
	    name = (char *)NULL;
    }
	    
    /*
     * If we still don't have a device for this screen, check the
     * environment variable for one. If one was given, stick its
     * path in name and check its accessibility. If it's not
     * properly accessible, then reset the name to NULL to force the
     * checking of the bwfbFbData array.
     */
    if (devsw == (char *)NULL && name == (char *)NULL &&
	xdevice != (char *)NULL &&
	(name = nthdev(xdevice, index)) != (char *)NULL &&
	(access (name, R_OK | W_OK) != 0)) {
	    name = (char *)NULL;
    }

    /*
     * Take the device given in the frame buffer description
     * and see if it exists and is accessible. If it does/is,
     * we will use it, as long as no other device was given.
     */
    if (devsw == (char *)NULL && name == (char *)NULL &&
	access(bwfbFbData[fbNum].devName, (R_OK | W_OK)) == 0) {
	    name = bwfbFbData[fbNum].devName;
    }

    /*
     * If we still have nothing and have yet to use "/dev/fb" for
     * a screen, default the name to be "/dev/fb"
     */
    if (devsw == (char *)NULL && name == (char *)NULL && !devFbUsed) {
	name = "/dev/fb";
    }

    if (name) {
	fd = open(name, O_RDWR, 0);
        if (fd < 0) {
	    return (-1);
	} 
	if (ioctl(fd, FBIOGTYPE, pfbType) < 0) {
	    perror("bwfbOpenFrameBuffer");
	    (void) close(fd);
	    return (-1);
	}
    }

    if (name && strcmp (name, "/dev/fb") == 0) {
	devFbUsed = TRUE;
    }

    return (fd);
}

/*
 * DDX - specific abort routine.  Called by AbortServer().
 */
void
AbortDDX()
{
}

/* Called by GiveUp(). */
void
ddxGiveUp()
{
}

int
ddxProcessArgument (argc, argv, i)
    int	argc;
    char *argv[];
    int	i;
{
    return 0;
}

void
ddxUseMsg()
{
}
