/*
 * $Header: bwfbISI.c,v 1.1 89/01/23 17:14:58 rml Exp $
 */
/*-
 * bwfb.c --
 *	Functions for handling the bwfb controller.
 *
 */

#include    "bwfb.h"
#include    "resource.h"
#include    "colormapst.h"

#include    <sys/mman.h>
#ifdef	ISWINDOWS
#include    <vt.h> 
#else
#include    "bwfbdev/mwcreg.h"
#include    "/sys/dev/fbreg.h"
/*#include    <vt.h> /**/
#endif

extern caddr_t mmap();

/* This is display dependant (sun for ex: WHITE = 0 )	*/
#define WHITE	65535
#define BLACK	0

#if (WHITE == 0)
#define GREATER <=
#else
#define GREATER >=
#endif

/* Pixel buffer (displayable or not + Control space) */
typedef  u_char *ISIPtr;

/*
 * add other types here
 */
#ifdef ISWINDOWS
int	indev;
extern char *GIP_Error;
#endif

/*-
 *-----------------------------------------------------------------------
 * bwfbSaveScreen --
 *	Disable the video on the frame buffer to save the screen.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Video enable state changes.
 *
 *-----------------------------------------------------------------------
 */
static Bool
bwfbSaveScreen (pScreen, on)
    ScreenPtr	  pScreen;
    Bool    	  on;
{
    int         state = on;

    switch (on) {
    case SCREEN_SAVER_FORCER:
	SetTimeSinceLastInputEvent();
	screenSaved = FALSE;
	break;
    case SCREEN_SAVER_OFF:
	screenSaved = FALSE;
	break;
    case SCREEN_SAVER_ON:
    default:
	screenSaved = TRUE;
	break;
    }
    return TRUE;
}

/*-
 *-----------------------------------------------------------------------
 * bwfbCloseScreen --
 *	called to ensure video is enabled when server exits.
 *
 * Results:
 *	Screen is unsaved.
 *
 * Side Effects:
 *	None
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static Bool
bwfbCloseScreen(i, pScreen)
    int		i;
    ScreenPtr	pScreen;
{
    return (pScreen->SaveScreen(pScreen, SCREEN_SAVER_OFF));
}

/*ARGSUSED*/
static void
bwfbResolveColor(pred, pgreen, pblue, pVisual)
    unsigned short	*pred, *pgreen, *pblue;
    VisualPtr		pVisual;
{
    /* Gets intensity from RGB.  If intensity is GREATER than half,
	 * pick white, else pick black.  
	 * This is display dependant	*/
    unsigned short tmp;

    tmp = (((39L * *pred +
           50L * *pgreen +
           11L * *pblue) >> 8) GREATER (((1<<8)-1)*50)) ? WHITE : BLACK;
    *pred = *pgreen = *pblue = tmp;
}
/*-
 *-----------------------------------------------------------------------
 * bwfbCreateColormap --
 *	create a bw colormap
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	allocate two pixels
 *
 *-----------------------------------------------------------------------
 */
void
bwfbCreateColormap(pmap)
    ColormapPtr	pmap;
{
    unsigned short	red, green, blue, pix;

    /* this is a monochrome colormap, it only has two entries, just fill
     * them in by hand.  If it were a more complex static map, it would be
     * worth writing a for loop or three to initialize it */

    /* this will be pixel 0 */
    red = green = blue = BLACK;
    AllocColor(pmap, &red, &green, &blue, &(pmap->pScreen->blackPixel), 0);

    /* this will be pixel 1 */
    red = green = blue = WHITE;
    AllocColor(pmap, &red, &green, &blue, &(pmap->pScreen->whitePixel), 0);

}

/*-
 *-----------------------------------------------------------------------
 * bwfbDestroyColormap --
 *	destroy a bw colormap
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	None
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
void
bwfbDestroyColormap(pmap)
    ColormapPtr	pmap;
{
}
/*-
 *-----------------------------------------------------------------------
 * bwfbInit --
 *	Attempt to find and initialize the ISI framebuffer
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Most of the elements of the ScreenRec are filled in.  The
 *	video is enabled for the frame buffer...
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
static Bool
bwfbInit (index, pScreen, argc, argv)
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    ScreenPtr	  pScreen;  	/* The Screen to initialize */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    ColormapPtr pColormap;

    if (!mfbScreenInit(index, pScreen,
			   bwfbFbs[index].fb,
			   bwfbFbs[index].info.fb_width,
			   bwfbFbs[index].info.fb_height, 90, 90))
	return (FALSE);

    pScreen->SaveScreen = bwfbSaveScreen;
    pScreen->RealizeCursor = bwfbRealizeCursor;
    pScreen->UnrealizeCursor = bwfbUnrealizeCursor;
    pScreen->DisplayCursor = bwfbDisplayCursor;
    pScreen->SetCursorPosition = bwfbSetCursorPosition;
    pScreen->CursorLimits = bwfbCursorLimits;
    pScreen->PointerNonInterestBox = bwfbPointerNonInterestBox;
    pScreen->ConstrainCursor = bwfbConstrainCursor;
    pScreen->RecolorCursor = bwfbRecolorCursor;
    pScreen->ResolveColor = bwfbResolveColor;
    pScreen->CreateColormap = bwfbCreateColormap;
    pScreen->DestroyColormap = bwfbDestroyColormap;
    pScreen->RegionCreate = miRegionCreate;
    pScreen->RegionCopy = miRegionCopy;
    pScreen->RegionDestroy = miRegionDestroy;
    pScreen->Intersect = miIntersect;
    pScreen->Inverse = miInverse;
    pScreen->Union = miUnion;
    pScreen->Subtract = miSubtract;
    pScreen->RegionReset = miRegionReset;
    pScreen->TranslateRegion = miTranslateRegion;
    pScreen->RectIn = miRectIn;
    pScreen->PointInRegion = miPointInRegion;
    pScreen->QueryBestSize = mfbQueryBestSize;
    pScreen->whitePixel = WHITE;
    pScreen->blackPixel = BLACK;

    if (CreateColormap(pScreen->defColormap, pScreen,
		   LookupID(pScreen->rootVisual, RT_VISUALID, RC_CORE),
		   &pColormap, AllocNone, 0) != Success
	|| pColormap == NULL)
	    FatalError("Can't create colormap in bwfbInit()\n");
	mfbInstallColormap(pColormap);

    /*
     * Enable video output...? 
     */
    (void) bwfbSaveScreen(pScreen, SCREEN_SAVER_FORCER);

    bwfbScreenInit(pScreen);
    return (TRUE);

}

/*-
 *-----------------------------------------------------------------------
 * ISIProbe --
 *	Attempt to find and initialize the ISI MWS Monochrome controller or
 *	the ISI mono GIP controller.
 *
 * Results:
 *	None
 *
 * Side Effects:
 *	Memory is allocated for the frame buffer and the buffer is mapped. 
 *
 *-----------------------------------------------------------------------
 */

Bool
ISIProbe(pScreenInfo, index, fbNum, argc, argv)
    ScreenInfo	  *pScreenInfo;	/* The screenInfo struct */
    int	    	  index;    	/* The index of pScreen in the ScreenInfo */
    int	    	  fbNum;    	/* Index into the bwfbFbData array */
    int	    	  argc;	    	/* The number of the Server's arguments. */
    char    	  **argv;   	/* The arguments themselves. Don't change! */
{
    int	i, oldNumScreens;
    int ps = getpagesize();

    if (bwfbFbData[fbNum].probeStatus == probedAndFailed) {
	return FALSE;
    }

    if (bwfbFbData[fbNum].probeStatus == neverProbed) {
	int         fd, vmfd;
	struct fbtype FBtype;
	ISIPtr      ISIfb = NULL;		/* Place to map the thing */
#ifdef ISWINDOWS
	{
	    int ldisc = TWSDISC;
	    short mmode = (VT_MOUSE_DOWN | VT_MOUSE_UP | VT_MOUSE_CONTINUOUS);
	    extern	char *gpframe; /* from libgip.a */

	    indev = GIP_Init();
	    if (indev < 0) FatalError("%s\n",GIP_Error);
	    /* setreuid(-1, -1);       /* don't need to be setuid after this */
	    ioctl(indev, TIOCSETD, &ldisc);     /* SetLineDisc */
	    ioctl(indev, TIOVSETMM, &mmode);    /* SetMouseMode */
	    ISIfb = (ISIPtr)gpframe;
	    FBtype.fb_type = FBTYPE_MWC;
	    FBtype.fb_height = 1024;
	    FBtype.fb_width = 1280;
	    FBtype.fb_pitch = 1280/32;
	    FBtype.fb_depth = 1;
	    FBtype.fb_cmsize = 2;
	    FBtype.fb_size = 1280*1024;
	    FBtype.fb_off = 0;
	    FBtype.fb_addr = ISIfb;
	    FBtype.fb_fblen = 1280*1024;
	}
#else
	/*
	 * XXX-COLOR add new devices
	 */

	if ((fd = bwfbOpenFrameBuffer(&FBtype, index, fbNum, 
		    argc, argv)) < 0) {
	    bwfbFbData[fbNum].probeStatus = probedAndFailed;
	    return FALSE;
	}

	ISIfb = (ISIPtr) valloc((unsigned)FBtype.fb_fblen);
	
	if (ISIfb == (ISIPtr) NULL) {
	    ErrorF("Could not allocate room for frame buffer.\n");
	    bwfbFbData[fbNum].probeStatus = probedAndFailed;
	    (void) close(fd);
	    return FALSE;
	}

	if (FBtype.fb_type == FBTYPE_ISIBW) {
		if (MapGIP(ISIfb, FBtype) != 0) {
			ErrorF("Mapping GIP");
			bwfbFbData[fbNum].probeStatus = probedAndFailed;
			(void) close(fd);
			return FALSE;
		}
	}
	else if (mmap((pointer)ISIfb,
		FBtype.fb_fblen,
		PROT_READ | PROT_WRITE, MAP_SHARED,
		fd, FBtype.fb_off) < 0) {
		ErrorF("Mapping ISI frame buffer");
		bwfbFbData[fbNum].probeStatus = probedAndFailed;
		(void) close(fd);
		return FALSE;
	}
#endif
	bwfbFbs[index].fb = (pointer) ISIfb;
	bwfbFbs[index].info = FBtype;
	bwfbFbData[fbNum].probeStatus = probedAndSucceeded;

    }

    /*
     * If we've ever successfully probed this device, do the following.
     */
    oldNumScreens = pScreenInfo->numScreens;
    i = AddScreen(bwfbInit, argc, argv);
    pScreenInfo->screen[index].CloseScreen = bwfbCloseScreen;
    return (i > oldNumScreens);
}

#ifndef ISWINDOWS

#define MSIZE	(256*1024)	/* maximum screen size (in bytes) mono */
#define CSIZE	(1024*1024)	/* maximum screen size (in bytes) color */

static
MapGIP(fbptr, fb)
ISIPtr	fbptr;
struct fbtype	fb;
{
    register char	i, n;
    register int	ps = getpagesize();
    register int	vmfd;
    extern char		*malloc();
    int 		isgip;
    int			fblen;
    short		*fbfifo;
    char 		*framebuffer, *csr;
    
    if( (vmfd = open("/dev/kmem", O_RDWR))<0){
	return (-1);
    }

    if((framebuffer = (char *)malloc ((fb.fb_cmsize == 2 ? 
			    MSIZE : CSIZE)+ps-1)) == 0){
	goto maperror;
    }

    if((csr = (char *)malloc (ps+ps-1)) == 0){
	goto maperror;
    }
    fbfifo = (short *)(((int)csr + ps) & ~(ps - 1));
    
    if (mmap ((caddr_t)fbptr, fb.fb_fblen, PROT_READ|PROT_WRITE, MAP_SHARED,
	vmfd, fb.fb_addr)){
	goto maperror;
    }

/*    if (mmap (fbfifo, ps, PROT_READ|PROT_WRITE, MAP_SHARED, vmfd, CSIZE)) /**/
    if (mmap (fbfifo, ps, PROT_READ|PROT_WRITE, MAP_SHARED, vmfd, fb.fb_reg_addr))
	/* cannot map gip fifo; assume there is no gip */
	isgip = 0;
    else
	/* a gip! */
	isgip = 1;

    close (vmfd);
    return (0);

maperror:	/* clean up and return error indication */
    if (framebuffer) {
	free (framebuffer);
	if (csr) {
	    free (csr);
	}
    }
    close (vmfd);
    return (-1);
}
#endif
