/*
 * $Header: bwfbEvents.c,v 1.1 89/01/23 17:14:44 rml Exp $
 */
/*      bwfbEvents.c	*/

/*
 *
 *      ProcessInputEvents()	Read IS input; convert to X event
 *
 *      Copyright (c) 1986,1987,1988, Integrated Solutions, Inc.
 */
#include <stdio.h>
#include <sys/ioctl.h>

#include <vt.h>
#define	 NEED_EVENTS
#include "bwfb.h"
#include "Xproto.h"
#include "keysym.h"

#define	IBUFSIZE	512

/* modifier masks */

#define	shiftmask	0x01
#define	shiftlockmask	0x02
#define	controlmask	0x04
#define	metamask	0x08

#define KEY_MASKS	(controlmask|metamask|shiftmask|shiftlockmask)

typedef struct {
    int     bmask;          /* Current button state */
    Bool    mouseMoved;     /* Mouse has moved */
} BwfbMsPrivRec, *BwfbMsPrivPtr;


/* find these in bwfbKeyMap.c */

#define ShiftKeyCode	(0x80)
#define ControlKeyCode	(0x81)
#define LockKeyCode	(0x82)
#define MetaKeyCode	(0x83)

/* extern DEVICE	*CurrentDevice; */ 
extern int	indev;
struct {
    short x,y;
} last_mouse;

int	mouse_acceleration = 1;
int	mouse_threshold;
int	invalid_mouse;

extern	int	isItTimeToYield;
extern	int	bwfbSigIO;
extern	int	lastEventTime;

/*
 * newmousexy(x,y)
 *
 * bind mouse to new x,y
 *
 */


short	screenbounds[4] = {	/* this is ugly */
	0,1280,
	0,1024
};

newmousexy(x,y)
int x,y;
{
    short mousebounds[4];
    extern	int	errno;

    mousebounds[0] = mousebounds[1] = x;
    mousebounds[2] = mousebounds[3] = y;
    ioctl(indev, TIOUMBND, mousebounds);    /* warps mouse cursor */
    ioctl(indev, TIOUMBND, screenbounds);   /* sets bounds back */
    ioctl(indev,TIOCFLUSH,2);
    last_mouse.x = x;
    last_mouse.y = y;
}

/*
 *	ProcessInputEvents()
 *
 *	It is assumed that read always returns complete sequences.
 *	Uses PF[1-4] to toggle ShiftKey, LockKey, ControlKey, and MetaKey.
 */
#ifdef ISWINDOWS
ProcessInputEvents()
{
    static unsigned		mask = 0;
    unsigned char		inbuf[IBUFSIZE];
    register unsigned char	*p = inbuf;
    register int		nread;
    xEvent			event;
    int				mousex,mousey;
    DevicePtr			pKbd,pPtr;
    KbPrivPtr     		pKbdPriv;
    PtrPrivPtr			pPtrPriv;
    int				warp = 0;
    u_char			key;
    int				gag;

    if (bwfbSigIO) {
	isItTimeToYield = 0;
	bwfbSigIO = 0;
    }

    fcntl(indev, F_SETFL, FNDELAY);
    if ((nread = read(indev, (char *)inbuf, IBUFSIZE)) <= 0) {
	/* no input now */
	fcntl(indev, F_SETFL, 0);
/*	if (invalid_mouse) /**/
/*	    --invalid_mouse; /**/
	return;
    }

    pKbd = LookupKeyboardDevice();
    pPtr = LookupPointerDevice();
    pKbdPriv = (KbPrivPtr) pKbd->devicePrivate;
    pPtrPriv = pPtr->devicePrivate;

    while (p < &inbuf[nread]) {
	gag = lastEventTime;
	lastEventTime = GetTimeInMillis();
	if (lastEventTime == gag) lastEventTime++;
	if (*p == VT_MOUSE) {
	    /* a mouse input */

	    /* which button */
	    switch (*++p & (VT_MOUSE_LEFT|VT_MOUSE_MIDDLE|VT_MOUSE_RIGHT)) {
	    case VT_MOUSE_LEFT:
		event.u.u.detail = Button1;
		break;
	    case VT_MOUSE_MIDDLE:
		event.u.u.detail = Button2;
		break;
	    case VT_MOUSE_RIGHT:
		event.u.u.detail = Button3;
		break;
	    }

	    /* which direction */
	    switch (*p++ & (VT_MOUSE_DOWN|VT_MOUSE_UP|VT_MOUSE_NOBUTTON)) {
	    case VT_MOUSE_DOWN:
		event.u.u.type  = ButtonPress;
		break;
	    case VT_MOUSE_UP:
		event.u.u.type  = ButtonRelease;
		break;
	    case VT_MOUSE_NOBUTTON:
		event.u.u.type	= MotionNotify;
		break;
	    }

	    p++; /* window */
	    p++; /* pane */

	    mousex = *p++ << 8;
	    mousex |= *p++;
	    mousey = *p++ << 8;
	    mousey |= *p++;

	    if (invalid_mouse && (event.u.u.type == MotionNotify)) {
		/* throw away buffered mouse motion events after warp */
		continue;
	    }

	    /* adjust for mouse acceleration if necessary */
	    if ((mouse_acceleration > 1) && (event.u.u.type == MotionNotify)) {
		/* accelerated mouse */
		register int delta;
		delta = mousex - last_mouse.x;
		if ((delta < -mouse_threshold) || (delta > mouse_threshold)) {
		    /* accelerate mouse in x direction */
		    register short new_x;
		    warp = 1;	/* will have to warp the mouse */
		    new_x = last_mouse.x +
			((delta<0?-1:1)*mouse_threshold)*(1-mouse_acceleration)
			+ (mouse_acceleration*delta);
		    /* keep warped mouse on the screen */
		    if (new_x >= 1280)
			mousex = 1280 - 1;
		    else if (new_x < 0)
			mousex = 0;
		    else
			mousex = (unsigned short) new_x;
		}

		delta = mousey - last_mouse.y;
		if ((delta < -mouse_threshold) || (delta > mouse_threshold)) {
		    /* accelerate mouse in y direction */
		    register short new_y;
		    warp = 1;	/* will have to warp the mouse */
		    new_y = last_mouse.y +
			((delta<0?-1:1)*mouse_threshold)*(1-mouse_acceleration)
			+ (mouse_acceleration*delta);
		    /* keep warped mouse on the screen */
		    if (new_y >= 1024)
			mousey = 1024 - 1;
		    else if (new_y < 0)
			mousey = 0;
		    else
			mousey = (unsigned short) new_y;
		}
	    }

debug("%c(%d,%d)\n",(event.u.u.type == MotionNotify)?'M':'B',mousex,mousey);
	    pPtrPriv->x = mousex;
	    pPtrPriv->y = mousey;

	    bwfbConstrainXY (&mousex, &mousey);

	    if (event.u.u.type == MotionNotify) {
		((BwfbMsPrivPtr)pPtrPriv->devPrivate)->mouseMoved = TRUE;
		if (pPtrPriv->x != mousex || pPtrPriv->y != mousey) {
		    newmousexy(mousex,mousey);
		    pPtrPriv->x = mousex;
		    pPtrPriv->y = mousey;
		}
		bwfbMouseDoneEvents(pPtr, FALSE);
	    } else {
if (event.u.u.type == ButtonPress)
debug("P(%d)(%d,%d)\n",event.u.u.detail,mousex,mousey);
if (event.u.u.type == ButtonRelease)
debug("R(%d)(%d,%d)\n",event.u.u.detail,mousex,mousey);
		event.u.keyButtonPointer.rootX =  mousex;
		event.u.keyButtonPointer.rootY =  mousey;
		(*pPtr->processInputProc) (&event, pPtr);
	    }

	    last_mouse.x = mousex;
	    last_mouse.y = mousey;
	} else {
	    /* keyboard input */
	    event.u.keyButtonPointer.rootX =  last_mouse.x;
	    event.u.keyButtonPointer.rootY =  last_mouse.y;

	    event.u.keyButtonPointer.time = lastEventTime; 

	    /* check for PF[1-4] (ESC O [PQRS]);  assumes that if a */
	    /* complete PF escape sequence is in the buffer, it was */
	    /* produced by a PF key */

	    if ((&inbuf[nread] - p >= 3) &&
		(*p == '\033') && (*(p+1) == 'O') &&
		(*(p+2) >= 'P') && (*(p+2) <= 'S')) {
		/* one of Shift, Lock, Control, Meta (PF[1-4]) was pressed */
		switch (*(p+2)) {	/* toggle the appropriate key */
		case 'P':	/* PF1 -- ShiftKey */
		    mask ^= shiftmask;
		    event.u.u.detail = ShiftKeyCode + pKbdPriv->offset;
		    event.u.u.type =
			    (mask & shiftmask) ? KeyPress : KeyRelease;
		    break;
		case 'Q':	/* PF2 -- LockKey */
		    mask ^= shiftlockmask;
		    event.u.u.detail = LockKeyCode + pKbdPriv->offset;
		    event.u.u.type =
			    (mask & shiftlockmask) ? KeyPress : KeyRelease;
		    break;
		case 'R':	/* PF3 -- ControlKey */
		    mask ^= controlmask;
		    event.u.u.detail = ControlKeyCode + pKbdPriv->offset;
		    event.u.u.type =
			    (mask & controlmask) ? KeyPress : KeyRelease;
		    break;
		case 'S':	/* PF4 -- MetaKey */
		    mask ^= metamask;
		    event.u.u.detail = MetaKeyCode + pKbdPriv->offset;
		    event.u.u.type =
			    (mask & metamask) ? KeyPress : KeyRelease;
		    break;
		}
		p += 3;
		(*pKbd->processInputProc) (&event, pKbd);
	    } else {
		/* "normal" key */

		key = (*p++) + pKbdPriv->offset;

		/* send UP for any Shift, Lock, Control, or Meta keys down */
		if (mask & shiftmask) {
		    event.u.u.detail = ShiftKeyCode + pKbdPriv->offset;
		    event.u.u.type = KeyRelease;
		    (*pKbd->processInputProc) (&event, pKbd);
		    event.u.keyButtonPointer.time++; 
		}
		if (mask & shiftlockmask) {
		    event.u.u.detail = LockKeyCode + pKbdPriv->offset;
		    event.u.u.type = KeyRelease;
		    (*pKbd->processInputProc) (&event, pKbd);
		    event.u.keyButtonPointer.time++; 
		}
		if (mask & controlmask) {
		    event.u.u.detail = ControlKeyCode + pKbdPriv->offset;
		    event.u.u.type = KeyRelease;
		    (*pKbd->processInputProc) (&event, pKbd);
		    event.u.keyButtonPointer.time++; 
		}
		if (mask & metamask) {
		    event.u.u.detail = MetaKeyCode + pKbdPriv->offset;
		    event.u.u.type = KeyRelease;
		    (*pKbd->processInputProc) (&event, pKbd);
		    event.u.keyButtonPointer.time++; 
		}

		if (key >= 'A' + pKbdPriv->offset &&
		    key <= 'Z' + pKbdPriv->offset) {
		    event.u.u.detail = ShiftKeyCode + pKbdPriv->offset;
		    event.u.u.type = KeyPress;
		    (*pKbd->processInputProc) (&event, pKbd);
		    event.u.keyButtonPointer.time++; 
		}

		event.u.u.detail = key;
		event.u.u.type = KeyPress;
		(*pKbd->processInputProc) (&event, pKbd);
		event.u.keyButtonPointer.time++; 
		event.u.u.type = KeyRelease;
		(*pKbd->processInputProc) (&event, pKbd);
		if (key >= 'A' + pKbdPriv->offset &&
		    key <= 'Z' + pKbdPriv->offset) {
		    event.u.u.detail = ShiftKeyCode + pKbdPriv->offset;
		    event.u.u.type = KeyRelease;
		    (*pKbd->processInputProc) (&event, pKbd);
		}

		mask = 0;	/* nothing should be down now */
	    }
	}
	fflush(stderr);
    }
/*    if (invalid_mouse) /**/
/*	--invalid_mouse; /**/
    bwfbMouseDoneEvents(pPtr, TRUE);
    bwfbRestoreCursor();
}
#endif

#ifdef DEBUG
#define	DEBUGTTY "/dev/ttyp1"
FILE *dbfp;
debug(str,a1,a2,a3,a4,a5)
char *str;
{
    if (dbfp == NULL)
	dbfp = fopen(DEBUGTTY,"w");
    if (dbfp != NULL) {
	fprintf(dbfp,str,a1,a2,a3,a4,a5);
	fflush(dbfp);
    }
}
#else DEBUG
debug(){}
#endif DEBUG
