#ifndef lint
static char rcsid[] = "$XConsortium: xboxes.c,v 1.15 88/09/23 09:27:33 swick Exp $";
#endif	lint

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Label.h>
#include <X11/Command.h>
#include <X11/Box.h>
#include <X11/Viewport.h>
#include <X11/Cardinals.h>

/* options for XtInitialize */
static XrmOptionDescRec options[] = {
    {"-update","update", XrmoptionSepArg, "1"}
};


struct _app_resources {
	int	update_val;
	} app_resources;

static XtResource resources[] = {
	{"update", "Update", XtRInt, sizeof(XtRInt),
	  XtOffset(struct _app_resources*, update_val), XtRInt, (caddr_t) 1},
	};

static Widget toplevel, w_shift, w_control, w_caplock, w_meta, check;
Boolean is_shift, is_control, is_caplock, is_meta;
Display *dpy; 
int	onesec = 1000;  /* 1000 ms */
int	sec=1;
unsigned long interval;
Boolean	diag=False;

Syntax(call)
	char *call;
{
    fprintf( stderr, "Usage: %s [-update <seconds>]\n", call );
}

/* ARGSUSED */
void callback(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
  XtDestroyWidget(toplevel);
  exit(0);
}

/* ARGSUSED */
void dispstat(widget,closure,callData)
    Widget widget;
    caddr_t closure;
    caddr_t callData;
{
    char keyret[32];
    int  i;

    XQueryKeymap(dpy, &keyret[0]);
    i = 0|keyret[17];

    if(i&1) XtSetSensitive(w_shift, True);
    else XtSetSensitive(w_shift, False);

    if(i&4) XtSetSensitive(w_control, True);
    else XtSetSensitive(w_control, False);

    if(i&2) XtSetSensitive(w_caplock, True);
    else XtSetSensitive(w_caplock, False);

    if(i&8) XtSetSensitive(w_meta, True);
    else XtSetSensitive(w_meta, False);

    if(diag) fprintf(stderr,"checked done\n");
    XtAddTimeOut(interval, dispstat, NULL);
}


void main(argc, argv)
    unsigned int argc;
    char **argv;
{
    Widget viewport, box, qbox, statbox, root;
    static XtCallbackRec callbackList[] = { {callback, NULL}, {NULL, NULL} };
    static Arg callbackarg[] = { {XtNcallback,(XtArgVal)callbackList} };
    static Arg arg[5];


    toplevel = XtInitialize( "key", "Demo", options, XtNumber(options),
			     &argc, argv);


    XtGetApplicationResources(toplevel, &app_resources,
			resources, XtNumber(resources),
			NULL, ZERO);
    /* sec = (XtArgVal) app_resources.update_val; */
    sec = app_resources.update_val;

    viewport = toplevel;
    dpy = XtDisplay(toplevel);

    if (argc != 1) Syntax(argv[0]);


    box = XtCreateManagedWidget("outerbox", boxWidgetClass,
				viewport, NULL, ZERO);
    qbox = XtCreateManagedWidget("qbox", boxWidgetClass,
				 box, NULL, ZERO);


    XtCreateManagedWidget(" quit ", commandWidgetClass, 
				qbox, callbackarg, ONE);

    check=XtCreateManagedWidget(" check", commandWidgetClass, 
				qbox, arg, ONE);
    XtAddCallback(check, XtNcallback, dispstat, NULL);

    w_shift=XtCreateManagedWidget("  SHIFT ", labelWidgetClass, box, NULL, ZERO);
    w_control=XtCreateManagedWidget(" CONTROL", labelWidgetClass, box, NULL, ZERO);
    w_caplock=XtCreateManagedWidget("CAP LOCK", labelWidgetClass, box, NULL, ZERO);
    w_meta=XtCreateManagedWidget("  META  ", labelWidgetClass, box, NULL, ZERO);

    XtAddTimeOut(onesec, dispstat, NULL);

    if (sec > 86400) sec = 1; /* update limited to 24 hr; also fix TRIFs bug 
				of getting wrong value if not specified */
    if (sec > 0) interval = onesec * sec;
    else interval = onesec;

    /* diagnostic flag */
    if (diag) printf("update = %d\t interval = %d\n",sec,interval);
    
    XtRealizeWidget(toplevel);
    XtMainLoop();
}
