/*
 * $Header: geometry.c,v 1.1 89/01/30 09:42:17 root Exp $
 */
/*
 * Geometry: Module containing code dealing with geometries and sizehints.
 *
 * Entry Points:
 *
 *    init_hints    : Routine to init. a XSizeHints structure to no hints.
 *
 *    parse_geometry: Like XParseGeometry but ADDS the result to a already
 *                    mostly filled out XSizeHints structure.  Handles
 *                    negative x & y positions correctly and sets US flags
 *                    as needed.  The program should first call Init_Hints
 *                    on the hints, fill in any hints it wants using P flags
 *                    and then call Parse_Geometry with the user's geometry.
 *                    A value of NULL for the geometry is prefectly ok.
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>

void init_hints(hints)
        XSizeHints *hints;
{
	hints->flags = 0;
	hints->x = hints->y = 0;
	hints->width = hints->height = 100;
}

void parse_geometry(dpy, screen, geometry, hints)
        Display *dpy;
        int screen;
        char *geometry;
        XSizeHints *hints;
{
	int status;

	if (!geometry)
	  return;

	status = XParseGeometry(geometry, &hints->x, &hints->y, &hints->width,
				&hints->height);
	if (status & (XValue|YValue)) {
	  hints->flags |= USPosition;
	  hints->flags &= ~PPosition;
        }

	if (status & (WidthValue|HeightValue)) {
	  hints->flags |= USSize;
	  hints->flags &= ~PSize;
        }

	if ( (status&XNegative) && (status&XValue) )
	  hints->x += DisplayWidth(dpy, screen) - hints->width;

	if ( (status&YNegative) && (status&YValue) )
	  hints->y += DisplayHeight(dpy, screen) - hints->height;
}
