/*
**	Double precision sinh/cosh
**	Algorithm from Cody & Waite,
**	Software Manual for the Elementary Functions
**	Prentice-Hall, 1980
**
**	Hacking by Wendy Thrash
*/

# include <errno.h>
int errno;

static double p0	=  -.35181283430177117881e6;
static double p1	=  -.11563521196851768270e5;
static double p2	=  -.16375798202630751372e3;
static double p3	=  -.78966127417357099479;
static double q0	=  -.21108770058106271242e7;
static double q1	=   .36162723109421836460e5;
static double q2	=  -.27773523119650701667e3;

static double eps	= 7.450580596923828125e-9; /* 2.**(-27) */
static double lnv	=  .6931610107421875;
static double wmax	=  709.77955188264167191;
static double vo2m1	=  .13830277879601902638e-4;

static int	ybar[]	= {0x40862E42, 0xFEFA39EE}; /* next # < dlog(xmax) */
static int	Inf[]	= {0x7ff00000,0x00000000};

double
sinh(x)
double x;
{
	double sinhus();
	double f,p,q,r,y;
	int sign;

	if (*(int *)&x < 0) {
		y = -x;
		sign = 0x80000000;
	}
	else {
		y = x;
		sign = 0;
	}
	if (y > 1.)
		return sinhus(y,sign,0);
	else if (y < eps)
		return x;
	else {
		f = x*x;
		p = ((p3*f + p2)*f + p1)*f + p0;
		q = ((f + q2)*f + q1)*f + q0;
		r = f * (p/q);
		return x + x*r;
	}
}

double
cosh(x)
double x;
{
	double sinhus(), y;

	y = x;
	if (*(int *)&x < 0)
		*(int *)&y &= 0x7fffffff;
	return sinhus(y,0,1);
}

static double
sinhus(y, sign, coshwanted)
double y;
int sign;
int coshwanted;
{
	double w, z, exp(), ldexp(), result;

	if(y > *(double *)ybar) {
		w = y - lnv;
		if (w > wmax) {
			errno = EDOM;
			if (sign < 0)
				return -(*(double *)Inf);
			else
				return *(double *)Inf;
		}
		z = exp(w);
		result = z + vo2m1*z;
	}
	else {
		z = exp(y);
		if (coshwanted)
			result = ldexp((z + 1./z),-1);
		else
			result = ldexp((z - 1./z),-1);
	}
	*(int *)&result ^= sign;
	return result;
}
