/*
**	Double precision sin/cos
**	Algorithm from Cody & Waite,
**	Software Manual for the Elementary Functions
**	Prentice-Hall, 1980
**
**	Hacking by Wendy Thrash
*/

static double twoopi	=  .63661977236758134308;
static double oneopi	=  .31830988618379067154;
static double pio2	=  1.57079632679489661923;
static double pi	=  3.14159265358979323846;
static double threepio2	=  4.71238898038468985769;
static double c1	=  3.1416015625;
static double c2	= -8.908910206761537356617e-6;
static double c1o2	=  1.57080078125;
static double c2o2	= -4.4544551033807686783085e-6;
static double r1	=  -.16666666666666665052;
static double r2	=  .83333333333331650314e-2;
static double r3	=  -.19841269841201840457e-3;
static double r4	=  .27557319210152756119e-5;
static double r5	=  -.25052106798274584544e-7;
static double r6	=  .16058936490371589114e-9;
static double r7	=  -.76429178068910467734e-12;
static double r8	=  .27204790957888846175e-14;

static double eps	= 7.450580596923828125e-9; /* 2.**(-27) */

double
cos(arg)
double arg;
{
	double sinus();

	if(arg<0.)
		return(sinus(arg, pio2-arg, 1, 1));
	else
		return(sinus(arg, pio2+arg, 1, 1));
}

double
sin(arg)
double arg;
{
	double sinus();

	if (arg < 0.)
		return(sinus(arg, -arg, -1, 0));
	else
		return(sinus(arg, arg, 1, 0));
}

static double
sinus(x, y, sgn, coswanted)
double x;
double y;
int sgn;
int coswanted;
{
	double modf();
	double xn, f, g, r, result;
	double dummy;
	double absx, absf;
	int n;

# ifdef IEEE		/* If compiler worked well, wouldn't need this */
	absx = x;
	*(int *)&absx &= 0x7fffffff;
# else IEEE
	if (x < 0.)
		absx = -x;
	else
		absx = x;
# endif IEEE
	
	if (y < threepio2) {	/* Perverted speedup code follows */
		if (y < pio2) {
			n = 0;
			if (coswanted) {
				xn = -.5;
				f = (absx + c1o2) + c2o2;
			}
			else {
				xn = 0.;
				f = absx;
			}
		}
		else {
			n = 1;
			sgn = -sgn;
			if (coswanted) {
				xn = .5;
				f = (absx - c1o2) - c2o2;
			}
			else {
				xn = 1.;
				f = (absx - c1) - c2;
			}
		}
	}
	else {			/* Nice, straightforward code follows */
		dummy = modf(y*oneopi+.5,&xn);	/* Note y >= 0. */
		n = xn;
		if (coswanted)
			xn = xn - .5;
		if (n & 1)
			sgn = -sgn;
		f = (absx - xn*c1) - xn*c2;
	}

# ifdef IEEE
	absf = f;
	*(int *)&absf &= 0x7fffffff;
	if (*(int *)&absf < *(int *)&eps)	/* Do approx compare as int */
		result = f;
# else IEEE
	if (f < 0.)
		absf = -f;
	else
		absf = f;
	if (absf < eps)
		result = f;
# endif IEEE
	else {
		g = f*f;
		r = (((((((r8*g+r7)*g+r6)*g+r5)*g+r4)*g+r3)*g+r2)*g+r1)*g;
		result = f + f*r;
	}
	if (sgn < 0)
		result = -result;
	return result;
}
