# define IEEE
/*
**	exp returns the exponential function of its
**	double-precision argument.
*/

#include <errno.h>
#include <math.h>

int	errno;
static double	oneoln2	= 1.4426950408889634074;
static double	c1	= .693359375;
static double	c2	= -2.1219444005469058277e-4;
static double	p0	= .249999999999999993;
static double	p1	= .694360001511792852e-2;
static double	p2	= .165203300268279130e-4;
static double	q0	= .5;
static double	q1	= .555538666969001188e-1;
static double	q2	= .495862884905441284e-3;
# ifdef IEEE
static int	minf[]	= {0xC086232B, 0xDD7ABCD1}; /* next # > dlog(xmin) */
static int	maxf[]	= {0x40862E42, 0xFEFA39EE}; /* next # < dlog(xmax) */
static int	eps[]	= {0x3C900000, 0x0};	/* 2.**-54 */
# endif IEEE

double
exp(x)
double x;
{
	double absx, dummy;
	double xn, g, z, gp, q, r;
	int n;

	if(x < *(double *)minf)
		return(0.);
	if(x > *(double *)maxf) {
		errno = ERANGE;
		return(HUGE);
	}
	absx = x;
	*(int *)&absx &= 0x7fffffff;	/* abs(x) */
	if (absx < *(double *)eps)
		return 1.0;
	else {
		
		dummy = modf(absx*oneoln2+.5,&xn);
		if (*(int *)&x < 0)			/* If x < 0. */
			*(int *)&xn ^= 0x80000000;	/* Negate xn */
		n = xn;
		g = (x - xn*c1) - xn*c2;
		z = g*g;
		gp = ((p2 * z + p1) * z + p0) * g;
		q = (q2 * z + q1) * z + q0;
		r = .5 + gp/(q - gp);
		return ldexp(r, n+1);
	}
}
