# include "DEFS.h"

/************************************************************************/
/*  EXP:   Calculate e to the power specified by the stack argument.	*/
/*	  The result is returned in d0					*/
/*									*/
/*         FPERR is set upon overflow, underflow, or NaN argument.	*/
/*									*/
/*  Algorithm from Cody & Waite, Software Manual for the		*/
/*  Elementary Functions, Prentice-Hall, 1980.				*/
/*  Gory details provided by Wendy Thrash, ISI/NBI, 1984-5.		*/
/*									*/
/************************************************************************/

/*  The argument is multiplied by 1/LN 2.  The integer portion of the */
/*  product becomes the two's exponent.  A rational approximation */
/*  is used to compute 2**FRAC(ARG * 1/LN 2). */

.data


FINLN2:	.long	0x3FB8AA3B	/* 1/ln 2  =  1.4426 95040 88896 34074	*/
FXBIGX:	.long	0x42B17218	/* 88.72284 = ln(XMAX)			*/
FXSMLX:	.long	0xC2AEAC4F	/* -87.3365 = ln(XMIN)			*/
FXEPS:	.long	0x33000000	/* 2. ** -25				*/
FXC1:	.long	0xbF318000	/* -355./512.				*/
FXC2:	.long	0x395E8083	/* 2.1219444005469058277 E-4		*/
FXP0:	.long	0x3E800000	/* .24999999950 (Well, OK, .25)		*/
FXP1:	.long	0x3B885308	/* .41602886268 E-2			*/
FXQ0:	.long	0x3f000000	/* .5					*/
FXQ1:	.long	0x3D4CBF5B	/* .49987178778 E-1			*/

.text

ENTRY(r_exp)
	link	a6,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ		/* Set-up for FP functions */

/* Is argument in range?? */
	bvs	FFNANR		/* NaN parm -> NaN result */
	bcc	FEXP01		/* J/ arg not INF */

	bmi	FFUNFR		/* -INF parm -> underflow result */
	bra	FFPINR		/* +INF parm -> positive INF result */

FEXP01:	movl	d0,d2		/* Save argument (X) */

	movl	d0,d1		/* another copy */
	bge	2f		/* Jump if X non-negative */
	cmpl	FXSMLX,d2	/* Is X <= SMALL? */
	bgt	FFUNFR		/* If so, underflow */
	andl	#0x7fffffff,d1	/* Get abs(X) */
	bra	3f
2:
	cmpl	FXBIGX,d2	/* Is X >= BIG? */
	bge	FFPINR		/* If so, overflow */
3:
	cmpl	FXEPS,d1	/* Is abs(X) < EPS? */
	ble	FFONER		/* If so, return 1. */

/* End of range tests */

	movl	d0,sp@-		/* argument on stack */
	movl	FINLN2,sp@-	/* 1/ln 2 on stack */
	jbsr	spmul		/* Convert to 2^ function */
	addql	#4,sp		/* Remove 1/ln 2 from stack */

	jbsr	NINT
	movl	d0,d3	/* Save the integer (N) */
	movl	d0,sp@-
	jbsr	spfloat	/* Convert integer to floating point (XN) */
	addql	#4,sp	/* Remove N from stack */

/*	We reduce the argument by computing g = (X + XN*C1) + XN*C2 */
/*	(The signs of the constants have been changed from Cody & Waite) */
	movl	d0,d7		/* XN */
	movl	d0,sp@-		/* XN */
	movl	FXC2,sp@-	/* C2 */
	jbsr	spmul		/* XN * C2*/
	movl	d0,d6		/* Save XN*C2 */
	movl	FXC1,sp@	/* C1 overwrites C2 on stack */
	jbsr	spmul		/* XN*C1 */
	addql	#4,sp		/* Remove C1 from stack */
	movl	d0,sp@		/* XN*C1 overwrites XN on stack */
	jbsr	spadd		/* X + XN*C1 */
	addql	#4,sp		/* Remove XN*C1 from stack */
	movl	d0,sp@		/* X + XN*C1 overwrites X on stack */
	movl	d6,sp@-		/* XN*C2 on stack */
	jbsr	spadd		/* g = (X + XN*C1) + XN*C2 */
	movl	d0,d4		/* save g */
	addql	#4,sp		/* Remove XN*C2 from stack */
	movl	d0,sp@		/* g overwrites X + XN*C1 on stack */
	movl	d0,sp@-		/* another copy of g on stack */
	jbsr	spmul		/* z = g*g */
	movl	d0,d5		/* save z */
	movl	d0,sp@		/* z overwrites second copy of g on stack */
	movl	FXP1,sp@-	/* p1 on stack */
	jbsr	spmul		/* p1*z */
	movl	d0,sp@		/* p1*z overwrites p1 on stack */
	movl	FXP0,sp@-	/* p0 on stack */
	jbsr	spadd		/* p1*z + p0 */
	lea	sp@(8),sp	/* Remove p0, p1*z from stack */
	movl	d0,sp@		/* p1*z + p0 overwrites *z on stack */
	jbsr	spmul		/* (p1*z + p0)*g = g*P(z) */
	movl	d0,d6
	addql	#4,sp		/* remove p1*z + p0 from stack */
	movl	FXQ1,sp@	/* q1 overwrites g on stack */
	movl	d5,sp@-		/* z on stack */
	jbsr	spmul		/* q1*z */
	addql	#4,sp		/* remove z from stack */
	movl	d0,sp@		/* q1*z overwrites q1 on stack */
	movl	FXQ0,sp@-	/* q0 on stack */
	jbsr	spadd		/* q1*z + q0 = Q(z) */
	addql	#4,sp		/* remove q0 from stack */
	movl	d6,sp@		/* g*P(z) overwrites q1*z on stack */
	movl	d0,sp@-		/* Q(z) on stack */
	jbsr	spsub		/* Q(z) - g*P(z) */
	movl	d0,sp@		/* Q(z) - g*P(z) overwrites Q(z) on stack */
	movl	d6,sp@-		/* g*P(z) on stack */
	jbsr	spdiv		/* g*P(z)/(Q(z) - g*P(z)) */
	lea	sp@(8),sp	/* clean garbage from stack */
	movl	d0,sp@		/* Quotient replaces Q(z) on stack */
	movl	FXQ0,sp@-	/* .5 on stack */
	jbsr	spadd		/* R(g) */
	lea	sp@(8),sp	/* clean garbage from stack */

/*	It only remains to adjust the exponent */
/*	Note that R(g) > 0, so the following scaling works: */

	addql	#1,d3		/* increment N (viz. algorithm) */
	swap	d3
	clrw	d3
	lsll	#7,d3
	addl	d3,d0		/* Should be the answer! */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
