#include	<errno.h>
int errno;

static int NaN[]	= {0x7fffffff,0xffffffff};
static double eps	= 7.450580596923828125e-9; /* 2.**(-27) */

static double p1	= -.27368494524164255994E2;
static double p2	=  .57208227877891731407E2;
static double p3	= -.39688862997504877339E2;
static double p4	=  .10152522233806463645E2;
static double p5	= -.69674573447350646411;
static double q0	= -.16421096714498560795E3;
static double q1	=  .41714430248260412556E3;
static double q2	= -.38186303361750149284E3;
static double q3	=  .15095270841030604719E3;
static double q4	= -.23823859153670238830E2;

static double a[]	= {0., .78539816339744830962};
static double b[]	= {1.57079632679489661923, .78539816339744830962};

double
asin(arg)
double arg;
{
	double comp();

	return comp(arg,0);
}

double
acos(arg)
double arg;
{
	double comp();

	return comp(arg,1);
}

static double
comp(x,flag)
double x;
int flag;
{
	double y, g, ldexp(), sqrt();
	double gp, q, r, result;
	int i;

	y = x;
	*(int *)&y &= 0x7fffffff;	/* y = abs(x) */
	i = flag;
	if (y > .5) {
		i = 1 - flag;
		if (y > 1.) {
			errno = EDOM;
			return *(double *)NaN;
		}
		g = ldexp(1.-y,-1);
		y = -ldexp(sqrt(g),1);
	}
	else if (y < eps) {
		result = y;
		goto quadadjust;
	}
	else {
		g = y*y;
	}
	gp = ((((p5*g+p4)*g+p3)*g+p2)*g+p1)*g;
	q = ((((g+q4)*g+q3)*g+q2)*g+q1)*g+q0;
	r = gp/q;
	result = y + y*r;

quadadjust:

	if (flag) {
		if (x < 0)
			result = (b[i] + result) + b[i];
		else
			result = (a[i] - result) + a[i];
	}
	else {
		result = (a[i] + result) + a[i];
		if (x < 0)
			result = -result;
	}
	return result;
}
