/*	@(#)tan.c	4.1	12/25/82	*/

/*
	floating point tangent

	A series is used after range reduction.
	Coefficients are #4285 from Hart & Cheney. (19.74D)
	This is the Berkeley routine, hacked by Wendy Thrash
*/

#include <errno.h>
#include <math.h>

int	errno;
static double invpi	  = 1.27323954473516268;
static double p0	 = -0.1306820264754825668269611177e+5;
static double p1	  = 0.1055970901714953193602353981e+4;
static double p2	 = -0.1550685653483266376941705728e+2;
static double p3	  = 0.3422554387241003435328470489e-1;
static double p4	  = 0.3386638642677172096076369e-4;
static double q0	 = -0.1663895238947119001851464661e+5;
static double q1	  = 0.4765751362916483698926655581e+4;
static double q2	 = -0.1555033164031709966900124574e+3;

double
tan(arg)
double arg;
{
	double temp, e, x, xsq;
	register int flag, i, negflg;

	flag = 0;
	negflg = 0;
	if(*(int *)&arg < 0){
		arg = -arg;
		negflg = 1;
	}
	arg *= invpi;   /*overflow?*/
	i = arg;
	x = arg - i;
	switch(i&3) {
	case 1:
		x = 1. - x;
		flag = 1;
		break;

	case 2:
		negflg = 1 - negflg;
		flag = 1;
		break;

	case 3:
		x = 1. - x;
		negflg = 1 - negflg;
		break;

	case 0:
		break;
	}

	xsq = x*x;
	temp = ((((p4*xsq+p3)*xsq+p2)*xsq+p1)*xsq+p0)*x;
	temp = temp/(((xsq+q2)*xsq+q1)*xsq+q0);

	if(flag == 1) {

/*		Note: if denormalized numbers possible, will need a better */
/*		test for zero in the following: */

		if(*(int *)&temp == 0) {
			errno = ERANGE;
			if (negflg)
				return(-HUGE);
			else
				return(HUGE);
		}
		if (negflg)
			return (-1./temp);
		else
			return (1./temp);
	}
	if (negflg)
		return (-temp);
	else
		return (temp);
}
