
/*
**	log returns the natural logarithm of its double-precision argument.
**
**	This routine is a bit more complicated than some of the others;
**	the simple-minded translation of Cody & Waite's algorithm led to
**	a routine that was about half the speed of the old one (though much
**	more accurate).  I fiddled things to make it approximately the same
**	speed, while retaining the accuracy.	-Wendy T-
*/

#include <errno.h>
#include <math.h>

int	errno;
double	frexp();
static double	log2	= 0.693147180559945309e0;
static double	ln10	= 2.302585092994045684;
static double	c0	= 0.70710678118654752440;	/* sqrt(.5) */
static double	c1	= 0.693359375;			/* 355/512 */
static double	c2	= -2.121944400546905827679E-4;
static double	c3	= .43429448190325182765;	/* log10(e) */
static double	a0	= -.64124943423745581147E2;
static double	a1	= 0.16383943563021534222E2;
static double	a2	= -.78956112887491257267;
static double	b0	= -.76949932108494879777E3;
static double	b1	= .31203222091924532844E3;
static double	b2	= -.35667977739034646171E2;
static int	NaN[]	= {0x7fffffff,0xffffffff};
static int	Inf[]	= {0x7ff00000,0x00000000};

double
log(x)
double x;
{
	double f, w, a, b, r, z;
	double znum, zden, xn;
	int n;
	register int xhigh;

	if(*(int *)&x <= 0) {
		if (x < 0.) {
			errno = EDOM;
			return(*(double *)NaN);
		}
		else if (x == 0.) {
			errno = EDOM;
			return(*(double *)Inf);
		}
/*		Denormalized numbers, when implemented, should fall through */
	}

/*	f = frexp(x,&n);	Let's do this in-line: */

	xhigh = *(int *)&x;
	n = ((xhigh & 0x7ff00000) >> 20) - 1022;
	f = x;
	*(int *)&f = (xhigh & ~0x7ff00000) | 0x3fe00000;

	if (f > c0) {
		znum = f - 1.;
/*		zden = f*.5 + .5;		*/
		*(int *)&f -= 0x00100000;  /* cheap f *= .5; can't underflow */
		zden = f + .5;
	}
	else {
		n = n - 1;
/*		znum = f - .5;			*/
/*		zden = znum * .5 + .5;		*/
/*		Let's try znum = 2.*f - 1.; zden = f + .5	*/
		zden = f + .5;
		*(int *)&f += 0x00100000;  /* cheap f *= 2.; can't overflow */
		znum = f - 1.;
	}
	z = znum/zden;
	w = z*z;
	a = (a2*w + a1)*w +a0;
	b = ((w + b2)*w + b1)*w + b0;
	r = z + z*(w * a / b);
	xn = n;
	return((xn*c2 + r) + xn*c1);
}

double
log10(x)
double x;
{

	return(c3*log(x));
}
