/*	@(#)hypot.c	4.1	12/25/82	*/

/*
 * sqrt(a^2 + b^2)
 *	(but carefully)
 */

static union foo {
	double ddat;
	struct foo2 {
		long l1;
		long l2;
	} ldat;
} dat1, dat2;

double sqrt();
double
hypot(a,b)
double a,b;
{
	double t;

	dat1.ddat = a;
	dat1.ldat.l1 &= 0x7fffffff;
	dat2.ddat = b;
	dat2.ldat.l1 &= 0x7fffffff;
	if (dat1.ddat > dat2.ddat) {
		b = dat1.ddat;
		a = dat2.ddat;
	}
	else {
		b = dat2.ddat;
		a = dat1.ddat;
	}
/*	if(b==0) return(0.);  code below subsumes this (very special) case */
/*
**	There's a comment below about possible pathological overflow.
**	It seems to me that equally pathological overflow is possible on
**	the divide.  I'm going to insert a little trick here to prevent it.
**	(Actually, the Berkeley boys use the same trick in one of their other
**	routines.) Normally, I'd hate to waste the cycles, but this is
**	supposed to be a CAREFUL routine, after all.   - Wendy Thrash -
*/

	if (b-a == b)
		return b;

/*	End of trick.  (There, now, that wasn't so bad, was it.) */

	a /= b;
	/*
	 * pathological overflow possible
	 * in the next line.
	 */
	return(b*sqrt(1. + a*a));
}

struct	complex
{
	double	r;
	double	i;
};

double
cabs(arg)
struct complex arg;
{
	double hypot();

	return(hypot(arg.r, arg.i));
}
