/* char id_close[] = "@(#)close.c	1.6";
 *
 * close.c  -  f77 file close, flush, exit routines
 */

#include "fio.h"

static char FROM_OPEN[] =	"\2";
static char clse[]	=	"close";

extern int unitcount_;
extern ftnint unit_list[];


f_clos(a) cllist *a;
{	unit *b;
	int n;

	lfname = NULL;
	elist = NO;
	external = YES;
	errflag = a->cerr;
/*	lunit = a->cunit; old */
	lunit = tr_unit(a->cunit,clse); /*BCN*/	
	if(lunit==STDERR && (!a->csta || *a->csta != FROM_OPEN[0]))
		err(errflag,F_ERUNIT,"can't close stderr");
	b= &units[lunit];
	if(!b->ufd) err(errflag,F_ERNOPEN,clse);
	if(a->csta && *a->csta != FROM_OPEN[0])
		switch(lcase(*a->csta))
		{
	delete:
		case 'd':
			fclose(b->ufd);
			if(b->ufnm) unlink(b->ufnm); /*SYSDEP*/
			break;
		default:
	keep:
		case 'k':
			if(b->uwrt && (n=t_runc(b,errflag,clse))) return(n);
			fclose(b->ufd);
			break;
		}
	else if(b->uscrtch) goto delete;
	else goto keep;
	if(b->ufnm) {
		if (!isdev(b->ufnm))
			{
			unitcount_--;
			rm_unit(lunit);
			}
		free(b->ufnm);
	}
	b->ufnm=NULL;
	b->ufd=NULL;
	return(OK);
}

f_exit()
{
	ftnint lu, dofirst = YES;
	cllist xx;
	xx.cerr=1;
	xx.csta=FROM_OPEN;
	for(lu=1; lu < MXUNIT;)
	{
		if (unit_list[lu] != EMPTY)
		   if ((lu != STDERR) || (lu != STDOUT) || (lu != STDIN)) {
		      xx.cunit=unit_list[lu];
#ifdef DEBUG
	fprintf(stderr,"lu = %d  unit_list[%d]= %d\n",lu,lu,unit_list[lu]);
#endif DEBUG
		      f_clos(&xx);
		      dofirst = NO;
	 	      }
	   	lu++;
	}
#ifdef OLDLIB
	for(lu=STDOUT; (dofirst || lu!=STDOUT); lu = ++lu % MXUNIT)
	{
		xx.cunit=lu;
		f_clos(&xx);
		dofirst = NO;
	}
#endif OLDLIB
}

ftnint
flush_(u) ftnint *u;
{
	FILE *F;

	F = units[*u].ufd;
	if(F)
		return(fflush(F));
	else
		return(F_ERNOPEN);
}

rm_unit(unit)
ftnint unit;
{
	
	ftnint i;

	unit_list[unit] = EMPTY; /* del closed unit from table*/ 
	for (i=1;i< MXUNIT;) {
#ifdef DEBUG
fprintf(stderr,"RM_UNIT unit= %d unit_list[%d] = %d\n",unit,i,unit_list[i]);
#endif DEBUG
		i++;
		}
}
