float	r_exp();

static float p0  = -0.6307673640497716991184787251e+6;
static float p1  = -0.8991272022039509355398013511e+5;
static float p2  = -0.2894211355989563807284660366e+4;
static float p3  = -0.2630563213397497062819489e+2;
static float q0  = -0.6307673640497716991212077277e+6;
static float q1   = 0.1521517378790019070696485176e+5;
static float q2  = -0.173678953558233699533450911e+3;

static
union foo {
	float fdat;
	long ldat;
} dat;

float
r_sinh(arg)
float *arg;
{
	float temp, argsq;
	register needneg;

	needneg = 0;
	dat.fdat = *arg;
	if(dat.ldat < 0) {
		dat.ldat &= 0x7fffffff;
		needneg = 1;
	}

	if(dat.fdat > 9.) {
		temp = .5 * r_exp(&dat.fdat);
		if (needneg)
			return(-temp);
		else
			return(temp);
	}

	if(dat.fdat > 0.5) {
		temp = r_exp(&dat.fdat);
		if (needneg)
			return(.5 * (1./temp - temp));
		else
			return(.5 * (temp - 1./temp));
	}

/*
** This approximation is surely overkill for single precision,
** but I don't have a less accurate (faster) one at hand - WT
*/
	argsq = *arg * *arg;
	temp = (((p3*argsq+p2)*argsq+p1)*argsq+p0) * dat.fdat;
	temp /= (((argsq+q2)*argsq+q1)*argsq+q0);
	if (needneg)
		return (-temp);
	else
		return (temp);
}

float
r_cosh(arg)
float *arg;
{
	float temp;

	dat.fdat = *arg;
	dat.ldat &= 0x7fffffff;	/* abs */
	if(dat.fdat > 9.) {
		return(.5 * r_exp(&dat.fdat));
	}
	temp = r_exp(&dat.fdat);
	return (.5 * (temp + 1./temp));
}
