# include "DEFS.h"

/************************************************************************/
/*									*/
/*  single precision hyperbolic tangent function			*/
/*  Algorithm from Cody & Waite, Software Manual for the		*/
/*  Elementary Functions, Prentice-Hall, 1980.				*/
/*  Gory details provided by Wendy Thrash, ISI/NBI, 1984-5.		*/
/*									*/
/************************************************************************/

.data

FTXBIG:	.long	0x41102CB3	/* 13ln2 = 9.01091. */
FTEPS:	.long	0x39800000	/* 2**-12 */
FTLN32:	.long	0x3F0C9F54	/* ln(3)/2 = .549306144334 */
FTP0:	.long	0xBF52E2C6	/* p0 = -.8237728127 */
FTP1:	.long	0xBB7B11B1	/* p1 = -.3831010665E-2 */
FTQ0:	.long	0x401E2A1A	/* q0 = .2471319654E+1 */
FTQ1:	.long	0x3F800000	/* q1 = 1.0 */

.text

ENTRY(r_tanh)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ		/* Set-up for FP functions */
	bcs	FTRET1		/* Return +-1 if +- Inf */
	bvs	FFNANR		/* Return NaN if NaN */
	movl	d0,d4		/* Save X */
	bclr	#31,d0		/* abs(X) */
	cmpl	FTXBIG,d0	/* Is |X| > XBIG ? */
	bgt	FTRET1		/* Return +-1 if out of range */
	cmpl	FTLN32,d0	/* Is |X| > ln(3)/2 ? */
	bgt	FTEASY		/* If so, do things the easy way */
	cmpl	FTEPS,d0	/* Is |X| < EPS ? */
	blt	FTRET		/* If so, return f = |X| */
	movl	d0,sp@-		/* f = |X| on stack */
	movl	d0,sp@-		/* Another copy of f on stack */
	jbsr	spmul		/* g = f*f */
	movl	d0,sp@		/* g on stack */
	movl	FTQ0,sp@-	/* q0 on stack */
	jbsr	spadd		/* g + q0 */
	movl	d0,d5		/* Save Q = g + q0 */
	movl	FTP1,sp@	/* p1 overwrites q0 on stack */
	jbsr	spmul		/* p1*g */
	movl	d0,sp@		/* p1*g overwrites p1 on stack */
	movl	FTP0,sp@-	/* p0 on stack */
	jbsr	spadd		/* p1*g + p0 */
	addql	#4,sp		/* Remove p0 from stack */
	movl	d0,sp@		/* p1*g + p0 overwrites p1*g on stack */
	jbsr	spmul		/* gP = (p1*g + p0)*g */
	movl	d0,sp@		/* gP overwrites p1*g + p0 */
	movl	d5,sp@(4)	/* Q overwrites g */
	jbsr	spdiv		/* R = gP/Q */
	addql	#4,sp		/* Remove gP from stack */
	movl	d0,sp@		/* R overwrites Q */
	jbsr	spmul		/* f*R */
	movl	d0,sp@		/* f*R overwrites R */
	jbsr	spadd		/* Result = f + f*R */
	addql	#8,sp		/* Clean up stack */
FTRET:
	andl	#0x80000000,d4	/* Get sign of X */
	orl	d4,d0		/* Adjust sign of result */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

FTRET1:
	movl	FTQ1,d0		/* Result is 1. */
	bra	FTRET

FTEASY:
	addl	#0x00800000,d0	/* 2*f */
	movl	d0,sp@-		/* 2*f on stack */
	pea	sp@		/* address of 2*f on stack (I hope) */
	jbsr	_r_exp		/* exp(2f) */
	movl	d0,sp@(4)	/* exp(2f) on stack */
	movl	FTQ1,sp@	/* 1. on stack */
	jbsr	spadd		/* exp(2f) + 1. */
	movl	d0,sp@(4)	/* exp(2f) + 1. on stack */
	movl	#0x40000000,sp@	/* 2. on stack */
	jbsr	spdiv		/* 2./(exp(2f) + 1.) */
	movl	d0,sp@(4)	/* 2./(exp(2f) + 1.) on stack */
	movl	FTQ1,sp@	/* 1. on stack */
	jbsr	spsub		/* Result = 1.-2./(exp(2f)+1) */
	lea	sp@(8),sp	/* Clean up stack */
	bra	FTRET

	.data
