# include "DEFS.h"

/************************************************************************/
/*									*/
/*  single precision tangent function					*/
/*  Algorithm from Cody & Waite, Software Manual for the		*/
/*  Elementary Functions, Prentice-Hall, 1980.				*/
/*  Gory details provided by 						*/
/*  Wendy Thrash, ISI/NBI, 1984-5.					*/
/*									*/
/************************************************************************/

.data

				/* -pi/2 = -1.57079632679489661923132 */
FTMPIO2H: .long	0xBFF921FB	/* High word of -pi/2 (double precision) */
FTMPIO2L: .long	0x54442D18	/* Low word of -pi/2 (double precision) */

FTBIGX:	.long	0x47800000	/* 65536. */
FTEPS:	.long	0x39800000	/* 2**-12 */
FT2OPI:	.long	0x3F22F983	/* 2./PI = .63661977236758134308 */
FTP0:	.long	0x3F800000	/* p0 = 1.0 */
FTP1:	.long	0xBDC433B8	/* p1 = -.958017723E-1 */
FTQ0:	.long	0x3F800000	/* q0 = 1.0 */
FTQ1:	.long	0xBEDBB7AF	/* q1 = -.429135777 */
FTQ2:	.long	0x3C1F3375	/* q2 = .971685835E-2 */

.text

ENTRY(r_tan)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ		/* Set-up for FP functions */
	bcs	FFNANR		/* Return NAN if +/- INF */
	bvs	FFNANR		/* Return NaN if NaN */
	movl	d0,d4		/* Save X */
	bclr	#31,d0		/* abs(X) */
/*	Note: the tan computation really loses precision before X=65536 */
	cmpl	FTBIGX,d0	/* Is |X| > 65536 ? */
	bge	FFNANR		/* Return NaN if arg out of range */
	movl	FT2OPI,sp@-	/* Put 2./PI on stack */
	movl	d4,sp@-		/* Put X on stack */
	jbsr	spmul		/* X * 2./PI */
	lea	sp@(8),sp	/* Remove stuff from stack */
	jbsr	NINT
	movl	d0,d5		/* Save the integer (N) */

/*	This routine is significantly more accurate when the */
/*	argument reduction in done in double precision.  So.... */

	movl	d0,sp@-
	jbsr	dpfloat		/* Convert integer to floating point (XN) */
	movl	d1,sp@		/* XN low word on stack*/
	movl	d0,sp@-		/* XN high word on stack */
	movl	FTMPIO2L,sp@-	/* -pi/2 low word on stack */
	movl	FTMPIO2H,sp@-	/* -pi/2 high word on stack */
	jbsr	dpmul		/* -(pi/2)*XN (dp) */
	movl	d1,sp@(12)	/* -(pi/2)*XN low word on stack */
	movl	d0,sp@(8)	/* -(pi/2)*XN high word on stack */
	addql	#4,sp		/* Clean up stack a little */
	movl	d4,sp@		/* X on stack */
	jbsr	sptodp		/* X (dp) */
	movl	d1,sp@		/* X low word on stack */
	movl	d0,sp@-		/* X high word on stack */
	jbsr	dpadd		/* X - (pi/2)*XN */
	lea	sp@(8),sp	/* Clean garbage from stack */
	movl	d1,sp@(4)	/* X - (pi/2)*XN low word on stack */
	movl	d0,sp@		/* X - (pi/2)*XN high word on stack */
	jbsr	dptosp		/* Convert back to single precision */

/*	End argument reduction */

	movl	d0,d1
	bclr	#31,d1		/* abs(f) */
	cmpl	FTEPS,d1	/* Is abs(f) > 2.**-12 ? */
	bgt	1f		/* If so, continue */
	movl	FTP0,d3		/* XDEN = 1.0 */
				/* XNUM = f (d0) */
	jbr	FTAN20
1:
	movl	d0,d6		/* Save f */
	movl	d0,sp@(4)	/* f overwrites |X| - pi*XN low on stack */
	movl	d0,sp@		/* f overwrites |X| - pi*XN high on stack */
	jbsr	spmul		/* g = f*f */
	movl	d0,sp@		/* g overwrites second copy of f */
	movl	FTQ2,sp@-	/* q2 on stack */
	jbsr	spmul		/* q2*g */
	movl	d0,sp@		/* q2*g overwrites q2 */
	movl	FTQ1,sp@-	/* q1 on stack */
	jbsr	spadd		/* q2*g + q1 */
	addql	#4,sp		/* Remove q1 from stack */
	movl	d0,sp@		/* q2*g + q1 overwrites q2*g on stack */
	jbsr	spmul		/* (q2*g + q1)*g */
	movl	d0,sp@		/* (q2*g + q1)*g overwrites q2*g + q1 */
	movl	FTQ0,sp@-	/* q0 on stack */
	jbsr	spadd		/* Q(g) = (q2*g + q1)*g + q0 */
	movl	d0,d3		/* Save XDEN = Q(g) */
	addql	#4,sp		/* Remove q0 from stack */
	movl	FTP1,sp@	/* p1 overwrites ... on stack */
	jbsr	spmul		/* p1*g */
	addql	#4,sp		/* Remove p1 from stack */
	movl	d0,sp@		/* p1*g overwrites g on stack*/
	jbsr	spmul		/* p1*g*f */
	movl	d0,sp@		/* p1*g*f overwrites p1*g on stack */
	jbsr	spadd		/* XNUM = f*P(g) = p1*g*f + f */
FTAN20:
	btst	#0,d5		/* Is N even ? */
	beq	2f		/* If so, get out of here */
	bchg	#31,d0		/* Negate XNUM */
	exg	d0,d3		/* Exchange XNUM, XDEN */
2:
	movl	d3,sp@(4)	/* XDEN or XNUM */
	movl	d0,sp@		/* XNUM or XDEN */
	jbsr	spdiv		/* Form result */
	lea	sp@(8),sp	/* Adjust stack */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
