# include "DEFS.h"

/************************************************************************/
/*									*/
/*  sin, cos routines							*/
/*  Algorithms from Cody & Waite, Software Manual for the		*/
/*  Elementary Functions, Prentice-Hall, 1980.				*/
/*  Gory details provided by Wendy Thrash, ISI/NBI, 1984-5.		*/
/*									*/
/************************************************************************/

.data

FSBIGX:	.long	0x47800000	/* 65536. */
FSOOPI:	.long	0x3EA2F983	/* 1./PI = .31830988618379067154 */
FSMPIH:	.long	0xC00921FB	/* High word of -pi = -3.14159265358979323846 */
FSMPIL:	.long	0x54442D18	/* Low word of -pi */
FSR1:	.long	0xBE2AAAA4	/* -.1666665668 */
FSR2:	.long	0x3C08873E	/* .8333025139E-2 */
FSR3:	.long	0xB94FB223	/* -.1980741872E-3 */
FSR4:	.long	0x362E9C5B	/* .2601903036E-5 */
FSPIO2:	.long	0x3FC90FDB	/* pi/2 = 1.57079632679 */
FSEPS:	.long	0x39800000	/* 2**-12 */
FSONE:	.long	0x3f800000	/* 1.0 */
FSMONE:	.long	0xbf800000	/* -1.0 (used as mask) */

.text

ENTRY(r_cos)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ		/* Set-up for FP functions */
	bcs	FFNANR		/* Return NAN if +/- INF */
	bvs	FFNANR		/* Return NaN if NaN */
	moveq	#1,d2		/* Set cos flag */
	clrl	d7		/* Set sign to + */
	bclr	#31,d0		/* abs(X) */
	movl	d0,d4		/* Save abs(X) */
	movl	d0,sp@-		/* abs(x) on stack */
	movl	FSPIO2,sp@-	/* pi/2 on stack */
	jbsr	spadd		/* Y = |X| + pi/2 */
	lea	sp@(8),sp	/* Clean up stack */
	bra	FSIN5
ENTRY(r_sin)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ		/* Set-up for FP functions */
	bcs	FFNANR		/* Return NAN if +/- INF */
	bvs	FFNANR		/* Return NaN if NaN */
	clrl	d2		/* Clear cos flag */
	movl	d0,d7		/* Will become sign */
	andl	#0x80000000,d7	/* Sign */
	bclr	#31,d0		/* abs(X) */
	movl	d0,d4		/* Save abs(X) */
FSIN5:
/*	Note: the sin computation really loses precision before X=65536 */
	cmpl	FSBIGX,d0	/* Is Y > 65536 ? */
	bge	FFNANR		/* Return NaN if arg out of range */
	movl	d0,d6		/* Save Y */
	movl	FSOOPI,sp@-	/* Put 1./PI on stack */
	movl	d0,sp@-		/* Put Y on stack */
	jbsr	spmul		/* Y * 1./PI */
	lea	sp@(8),sp	/* Remove stuff from stack */
	jbsr	NINT
	movl	d0,d5		/* Save the integer (N) */
	movl	d0,sp@-
	jbsr	spfloat		/* Convert integer to floating point (XN) */
	addql	#4,sp		/* Remove N from stack */
	btst	#0,d5		/* Is N even or odd? */
	beq	2f		/* Jump if even */
	bchg	#31,d7		/* Negate sign */
2:
	movl	d2,d2		/* Check cos flag */
	beq	3f		/* Jump if doing sin */
	movl	#0xbf000000,sp@-	/* -.5 on stack */
	movl	d0,sp@-		/* XN on stack */
	jbsr	spadd		/* XN - .5 on stack */
	lea	sp@(8),sp	/* Clear garbage from stack */
3:

/*	This routine is significantly more accurate when the */
/*	argument reduction in done in double precision.  So.... */

	movl	d0,sp@-		/* XN on stack */
	jbsr	sptodp		/* Convert to double precision */
	movl	d1,sp@		/* XN low word on stack*/
	movl	d0,sp@-		/* XN high word on stack */
	movl	FSMPIL,sp@-	/* -pi low word on stack */
	movl	FSMPIH,sp@-	/* -pi high word on stack */
	jbsr	dpmul		/* -pi*XN (dp) */
	movl	d1,sp@(12)	/* -pi*XN low word on stack */
	movl	d0,sp@(8)	/* -pi*XN high word on stack */
	addql	#4,sp		/* Clean up stack a little */
	movl	d4,sp@		/* |X| on stack */
	jbsr	sptodp		/* |X| (dp) */
	movl	d1,sp@		/* |X| low word on stack */
	movl	d0,sp@-		/* |X| high word on stack */
	jbsr	dpadd		/* |X| - pi*XN */
	lea	sp@(8),sp	/* Clean garbage from stack */
	movl	d1,sp@(4)	/* |X| - pi*XN low word on stack */
	movl	d0,sp@		/* |X| - pi*XN high word on stack */
	jbsr	dptosp		/* Convert back to single precision */

/*	End argument reduction */

/*	movl	d0,d1		/* */
/*	bchg	#31,d1		/* abs(f) */
/*	cmpl	FSEPS,d1	/* Is abs(f) < 2.**-12 ? */
/*	ble	FSIN20		/* If so, f is result */
	
	movl	d0,d6		/* Save f */
	movl	d0,sp@(4)	/* f overwrites |X| - pi*XN low on stack */
	movl	d0,sp@		/* f overwrites |X| - pi*XN high on stack */
	jbsr	spmul		/* g = f*f */
	movl	d0,sp@		/* g overwrites second copy of f */
	movl	FSR4,sp@-	/* r4 on stack */
	jbsr	spmul		/* r4*g */
	movl	d0,sp@		/* r4*g overwrites r4 */
	movl	FSR3,sp@-	/* r3 on stack */
	jbsr	spadd		/* r4*g + r3 */
	addql	#4,sp		/* Remove r3 from stack */
	movl	d0,sp@		/* r4*g + r3 overwrites r4*g on stack */
	jbsr	spmul		/* (r4*g + r3)*g */
	movl	d0,sp@		/* (r4*g + r3)*g overwrites r4*g + r3 */
	movl	FSR2,sp@-	/* r2 on stack */
	jbsr	spadd		/* (r4*g + r3)*g + r2 */
	addql	#4,sp		/* Remove r2 from stack */
	movl	d0,sp@		/* (r4*g + r3)*g + r2 overwrites .... */
	jbsr	spmul		/* ((r4*g + r3)*g + r2)*g */
	movl	d0,sp@		/* Put it on the stack */
	movl	FSR1,sp@-	/* r2 on stack */
	jbsr	spadd		/* ((r4*g+r3)*g+r2)*g+r2 */
	addql	#4,sp		/* Remove r2 from stack */
	movl	d0,sp@		/* ((r4*g+r3)*g+r2)*g+r2 overwrites.... */
	jbsr	spmul		/* R(g) = (((r4*g+r3)*g+r2)*g+r1)*g */
	addql	#4,sp		/* Remove garbage */
	movl	d0,sp@		/* R(g) on stack */
	jbsr	spmul		/* f*R(g) */
	movl	d0,sp@		/* f*R(g) overwrites R(g) */
	jbsr	spadd		/* f + f*R(g) = result */
/*									*/
/*	Note: This routine stubbornly insists that some numbers have	*/
/*	sines and cosines > 1.0.  The elegant ways to take care of	*/
/*	this don't seem to work, so here is a crude way.  Observe	*/
/*	that it works only for results between one and two,		*/
/*	but that's far more than is needed.				*/
/*									*/
	movl	d0,d1		/* Copy result */
	bclr	#31,d1		/* abs(result) */
	cmpl	FSONE,d1	/* Is abs(result) > 1. ? */
	ble	FSIN20		/* If so, result = +- 1. */
	andl	FSMONE,d0	/* Set result to +- 1. */
FSIN20:
	eorl	d7,d0		/* Adjust sign */
	lea	sp@(8),sp	/* Adjust stack */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
