# include "DEFS.h"

/************************************************************************/
/*									*/
/*  Exponential function						*/
/*  Algorithm from Cody & Waite, Software Manual for the		*/
/*  Elementary Functions, Prentice-Hall, 1980.				*/
/*  Gory details provided by Wendy Thrash, ISI/NBI, 1984-5.		*/
/*									*/
/************************************************************************/

.data
FLC0:	.long	0x3f3504f3	/* sqrt(2)/2. = .70710678118654752440	*/
FLA0:	.long	0xbf0d7e3d	/* -.5527074855				*/
FLB0:	.long	0xc0d43f3a	/* -.6632718214e+1			*/
FLB1:	.long	0x3f800000	/* 1.					*/
FLC1:	.long	0x3f318000	/* 355/512 = .693359375			*/
FLC2:	.long	0xb95e8083	/* -2.1219444005469058276779e-4		*/
FLC3:	.long	0x3ede5bd9	/* log10(e) = .43429448190325182765	*/

.text

ENTRY(r_lg10)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	movl	#1,d7
	jbsr	FPFADJ		/* Set-up for FP functions */
	bra	FLG5

ENTRY(r_log)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	clrl	d7
	jbsr	FPFADJ		/* Set-up for FP functions */
FLG5:
	bvs	FFNANR		/* J/ NaN arg -> NaN result */
	bmi	FFNANR		/* J/ Neg arg -> NaN result */
	beq	FFMINR		/* J/ 0.0 arg -> -INF result */
	bcs	FFPINR		/* J/ +INF arg -> +INF result */
	movl	d0,d6
	movl	d0,d5
	clrw	d6
	swap	d6
	lsrw	#7,d6

/*	In computing N and f here, remember that IEEE is  */
/*	2**(exp-bias) * (1.+.frac), so we add 1 to exponent, adjust fraction */

	subw	#0x7e,d6	/* N = unbiased exponent + 1 */
	andl	#0x7fffff,d5
	orl	#0x3f000000,d5	/* f = fraction; .5 <= f < 1. */
	movl	d5,sp@-		/* f on stack */
	cmpl	FLC0,d5		/* Is f >= sqrt(2.)/2. ? */
	bge	FLG20		/* If so, jump */
	subqw	#1,d6		/* N = N - 1 */
	movl	#0xbf000000,sp@- /* -.5 on stack */
	jbsr	spadd		/* znum = f - .5 */
	addql	#4,sp		/* remove -.5 from stack */
	movl	d0,d4		/* Save znum */
	beq	FLG10		/* If znum is 0, skip fancy multiply */
	addl	#0xff800000,d0	/* znum * .5 */
FLG10:
	movl	d0,sp@		/* znum * .5 replaces f on stack */
	movl	#0x3f000000,sp@- /* .5 on stack */
	jbsr	spadd		/* zden = znum * .5 + .5 */
	bra	FLG30
FLG20:
	movl	#0xbf800000,sp@- /* -1. on stack */
	jbsr	spadd		/* znum = f - 1. (deviation from alg.) */
	movl	d0,d4		/* save znum */
	addql	#4,sp		/* Remove 1. from stack */
	addl	#0xff800000,sp@	/* f * .5 on stack */
	movl	#0x3f000000,sp@- /* .5 on stack */
	jbsr	spadd		/* zden = f * .5 + .5 */
FLG30:
	movl	d0,d3		/* Save zden */
	movl	d3,sp@(4)	/* zden overwrites top of stack */
	movl	d4,sp@		/* znum overwrites next element of stack */
	jbsr	spdiv		/* z = znum/zden */
	movl	d0,sp@(4)	/* z overwrites zden on stack */
	movl	d0,sp@		/* z overwrites znum on stack */
	jbsr	spmul		/* w = z*z */
	movl	d0,sp@		/* w overwrites second z on stack */
	movl	FLB0,sp@-	/* b0 on stack */
	jbsr	spadd		/* w + b0  (note b1 = 1.) */
	movl	d0,sp@		/* w + b0 overwrites b0 on stack */
	movl	FLA0,sp@-	/* a0 on stack */
	jbsr	spdiv		/* A(w)/B(w) */
	addql	#4,sp		/* Remove a0 from stack */
	movl	d0,sp@		/* A(w)/B(w) overwrites w + b0 on stack */
	jbsr	spmul		/* r = w * A(w)/B(w) */
	addql	#4,sp		/* Remove A(w)/B(w) from stack */
	movl	d0,sp@		/* r overwrites w on stack */
	jbsr	spmul		/* z * r */
	movl	d0,sp@		/* z*r overwrites r on stack */
	jbsr	spadd		/* R = z + z*r */
	movl	d0,sp@(4)	/* R on top of stack */
	extl	d6		/* N from word to long */
	movl	d6,sp@		/* N on stack */
	jbsr	spfloat		/* float N */
	movl	d0,sp@		/* XN = float(N) overwrites N on stack */
	movl	FLC1,sp@-	/* C1 on stack */
	jbsr	spmul		/* XN * C1 */
	movl	d0,d6		/* Save XN * C1 */
	movl	FLC2,sp@	/* C2 overwrites C1 on stack */
	jbsr	spmul		/* XN * C2 */
	addql	#4,sp		/* Remove C2 from stack */
	movl	d0,sp@		/* XN*C2 overwrites XN on stack */
	jbsr	spadd		/* XN*C2 + R */
	movl	d0,sp@(4)	/* XN*C2 + R overwrites R on stack */
	movl	d6,sp@		/* XN * C1 overwrites XN * C2 on stack */
	jbsr	spadd		/* Value of log */
	movl	d7,d7		/* Test log10 flag */
	beq	FLG40		/* If not log10, done */
	movl	d0,sp@(4)	/* Natural log on stack */
	movl	FLC3,sp@	/* lg10(e) on stack */
	jbsr	spmul		/* Value of log10 */
FLG40:
	lea	sp@(8),sp	/* Clean up stack */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts
