# include "DEFS.h"

/************************************************************************/
/*									*/
/*  Single-precision arctangent routine.				*/
/*  Algorithm from Cody & Waite, Software Manual for the		*/
/*  Elementary Functions, Prentice-Hall, 1980.				*/
/*  Gory details provided by Wendy Thrash, ISI/NBI, 1984-5.		*/
/*									*/
/************************************************************************/

.data

FONE:	.long	0x3F800000	/* 1.0 */
FMONE:	.long	0xBF800000	/* -1.0 */
FATC0:	.long	0x3E8930A3	/* 2. - sqrt(3.) = .26794919243112270647 */
FATC1:	.long	0x3FDDB3D7	/* sqrt(3.) = 1.73205080756887729353 */
FATEPS:	.long	0x39800000	/* 2**-12 */
FATP0:	.long	0xBEF110F6	/* p0 = -.4708325141 */
FATP1:	.long	0xBD508691	/* p1 = -.5090958253E-1 */
FATQ0:	.long	0x3FB4CCD3	/* q0 = .1412500740E+1 */

/*  Do not move the following four constants */
FATA0:	.long	0x00000000	/* A0 = 0. */
	.long	0x3F060A92	/* A1 = pi/6 = .52359877559829887308 */
FATPIO2: .long	0x3FC90FDB	/* A2 = pi/2 = 1.57079632679489661923 */
	.long	0x3F860A92	/* A3 = pi/3 = 1.04719755119659774615 */

FATPI:	.long	0x40490FDB	/* pi = 3.14159265358979323846 */

.text
/***********************************************************************/
/*                   -pi < atan2(V,U) = atan(V/U) <= pi                */
/*                                                                     */
/*                 Q1: 0 < ... < pi/2; Q2: pi/2 < ... < pi             */
/*                Q3: -pi < ... < -pi/2; Q4: -pi/2 < ... < 0           */
/*                                                                     */
/*	   V:	-Inf       -        0        +      +Inf      NaN      */
/*	U:    +--------+--------+--------+--------+--------+-------+   */
/*	-Inf  |   NaN  |   pi   |   pi   |   pi   |  NaN   |  NaN  |   */
/*	-     |  -pi/2 |   Q3   |   pi   |   Q2   |  pi/2  |  NaN  |   */
/*	0     |  -pi/2 |  -pi/2 |   NaN  |  pi/2  |  pi/2  |  NaN  |   */
/*	+     |  -pi/2 |   Q4   |    0   |   Q1   |  pi/2  |  NaN  |   */
/*	+Inf  |   NaN  |    0   |    0   |    0   |  NaN   |  NaN  |   */
/*	NaN   |   NaN  |   NaN  |   NaN  |   NaN  |  NaN   |  NaN  |   */
/*	      +--------+--------+--------+--------+--------+-------+   */
/*                                                                     */
/***********************************************************************/

ENTRY(r_atn2)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	movl	fp@(8),a0	/* Get address of V */
	movl	a0@,d0		/* Get V itself */
	movl	d0,d6		/* Save V */
	movl	fp@(12),a0	/* Get address of U */
	movl	a0@,d1		/* Get U itself */
	movl	d1,d7		/* Save U */
	movl	d1,d7		/* Save U for sign test */
	movl	d0,d6		/* Save V for sign test */
	movl	d1,sp@-		/* U on stack */
	movl	d0,sp@-		/* V on stack */
	jbsr	spdiv		/* V/U */
	lea	sp@(8),sp	/* Clean up stack */
	movl	d0,d2
	swap	d2
	rolw	#1,d2
	cmpw	#256*0xFF,d2
	bcs	FAT15		/* Jump if not INF or NaN */
	andw	#0xFE,d2
	jne	FFNANR		/* If U is NaN, return NaN */
	movl	FATPIO2,d0	/* Result = pi/2 */
	bra	FAT50

ENTRY(r_atan)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ
	bvs	FFNANR		/* J/ NaN arg -> NaN result */
	bcc	FAT10		/* J/ not INF */
	clrl	d7		/* Dummy U for testing later */
	movl	d0,d6		/* Save arg (X and U share d6) */
	movl	FATPIO2,d0	/* Result is +- PIO2 */
	jbr	FAT50		/* Go adjust sign */

FAT10:	beq	FFZERR		/* J/ 0.0 arg -> 0.0 result */
	clrl	d7		/* Dummy U for testing later */
	movl	d0,d6		/* Save arg (X and V share d6) */
FAT15:
	bclr	#31,d0		/* f = |X| */
	clrl	d5		/* N = 0 */
	cmpl	FONE,d0
	ble	1f		/* Jump if f <= 1. */
	movl	d0,sp@-		/* f on stack */
	movl	FONE,sp@-	/* 1.0 on stack */
	jbsr	spdiv		/* 1.0/f */
	lea	sp@(8),sp	/* Clean up stack */
	moveq	#2,d5		/* N = 2 */
1:
	cmpl	FATC0,d0
	ble	2f		/* Jump if f <= 2.-sqrt(3.) */
	
	movl	d0,sp@-		/* f on stack */
	movl	FATC1,sp@-	/* sqrt(3.) on stack */
	jbsr	spadd		/* f + sqrt(3.) */
	movl	d0,d4		/* Save f + sqrt(3.) */
	jbsr	spmul		/* f * sqrt(3.) */
	movl	d0,sp@(4)	/* f * sqrt(3.) overwrites f on stack */
	movl	FMONE,sp@	/* -1.0 overwrites sqrt(3.) on stack */
	jbsr	spadd		/* f*sqrt(3.) - 1. */
	movl	d4,sp@(4)	/* f + sqrt(3.) overwrites f * sqrt(3.) */
	movl	d0,sp@		/* f*sqrt(3.) - 1. overwrites -1. */
	jbsr	spdiv		/* f = (f*sqrt(3.)-1.)/(sqrt(3.)+f) */
	lea	sp@(8),sp	/* Clean up stack */
	addql	#1,d5		/* N = N + 1 */
2:
	movl	d0,sp@-		/* f on stack */
	movl	d0,sp@-		/* Another copy of f on stack */
/*	This cmpl and blt are done after the movls so the stack will */
/*	be the right size if the branch to FAT20 is taken. */
	movl	d0,d1
	bclr	#31,d1		/* |f| */
	cmpl	FATEPS,d1
	blt	FAT20		/* If |f| < 2.**-12, f is result */
	jbsr	spmul		/* g = f*f */
	movl	d0,sp@		/* g overwrites second copy of f */
	movl	FATQ0,sp@-	/* q0 on stack */
	jbsr	spadd		/* Q = g + q0 */
	movl	d0,d4		/* Save Q */
	movl	FATP1,sp@	/* p1 overwrites q0 */
	jbsr	spmul		/* p1*g */
	movl	d0,sp@		/* p1*g overwrites q0 */
	movl	FATP0,sp@-	/* p0 on stack */
	jbsr	spadd		/* P = p1*g + p0 */
	addql	#4,sp		/* Remove p0 from stack */
	movl	d0,sp@		/* P overwrites p1*g on stack */
	jbsr	spmul		/* g*P */
	movl	d4,sp@(4)	/* Q overwrites g */
	movl	d0,sp@		/* g*P overwrites P */
	jbsr	spdiv		/* R = g*P/Q */
	addql	#4,sp		/* Remove g*P from stack */
	movl	d0,sp@		/* R overwrites g on stack */
	jbsr	spmul		/* f*R */
	movl	d0,sp@		/* f*R overwrites R */
	jbsr	spadd		/* Result = f + f*R */
FAT20:
	cmpl	#1,d5
	ble	2f		/* Jump if N <= 1 */
	bchg	#31,d0		/* Negate Result */
2:
	movl	d0,sp@(4)	/* Put Result on stack */
	lslw	#2,d5		/* Scale N */
	lea	FATA0,a0	/* Get address of A0 */
	movl	a0@(0,d5:W),sp@	/* Put AN on stack */
	jbsr	spadd		/* Result = Result + AN */
	lea	sp@(8),sp	/* Clean up stack */
FAT40:
	movl	d7,d7
	bge	FAT50		/* Jump if U >= 0 or if not ATAN2 */
	movl	d0,sp@-		/* Result on stack */
	movl	FATPI,sp@-	/* Pi on stack */
	jbsr	spsub		/* Pi - Result */
	lea	sp@(8),sp	/* Clean up stack */
FAT50:
	andl	#0x80000000,d6	/* Get sign bit of V or X */
	eorl	d6,d0		/* Adjust sign of Result */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

	.data
