# include "DEFS.h"

/************************************************************************/
/*									*/
/*  Single-precision arcsin, arccos					*/
/*  Algorithm from Cody & Waite, Software Manual for the		*/
/*  Elementary Functions, Prentice-Hall, 1980.				*/
/*  Gory details provided by Wendy Thrash, ISI/NBI, 1984-5.		*/
/*									*/
/************************************************************************/

.data

FASP1:	.long	0x3F6F166B	/* .933935835 */
FASP2:	.long	0xBF012065	/* -.504400557 */
FASQ0:	.long	0x40B350F0	/* .560363004E+1 */
FASQ1:	.long	0xC0B18D0B	/* -.554846723E+1 */
FASQ2:	.long	0x3F800000	/* 1.0 */
FASHLF:	.long	0x3F000000	/* 0.5 */

FASEPS:	.long	0x39800000	/* 2**-12 */

/* Note these constants are double those in Cody & Waite */
FASB1:
FASA1:	.long	0x3FC90FDB	/* pi/2 */
FASB0:	.long	0x40490FDB	/* pi */

.text
ENTRY(r_acos)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ
	bvs	FFNANR		/* Return NaN if  NaN arg */
	bcs	FFNANR		/* Return NaN if +/- INF */
	moveq	#1,d7		/* FLAG = 1 */
	jbr	FAS10
ENTRY(r_asin)
	link	fp,#-40
	moveml	#0x3cfc,sp@	/* Save registers */
	jbsr	FPFADJ
	bvs	FFNANR		/* Return NaN if  NaN arg */
	bcs	FFNANR		/* Return NaN if +/- INF */
	clrl	d7		/* FLAG = 0 */
FAS10:
	movl	d0,d4		/* Copy X */
	bclr	#31,d0		/* Y = abs(X) */
	cmpl	FASHLF,d0	/* Is abs(X) > .5 ? */
	bgt	FAS20		/* If so, branch */
	movl	d7,d6		/* i = FLAG */
	cmpl	FASEPS,d0	/* Is abs(Y) <= 2.**-12 ? */
	ble	FAS40		/* If so, Result = Y */
	movl	d0,sp@-		/* Y on stack */
	movl	d0,sp@-		/* Another copy of Y on stack */
	jbsr	spmul		/* g = Y*Y */
	movl	d0,sp@		/* g overwrites Y on stack */
	jbr	FAS30
FAS20:
	moveq	#1,d6
	subl	d7,d6		/* i = 1 - FLAG */
	cmpl	FASQ2,d0	/* Is Y > 1 > */
	bgt	FFNANR		/* If so, return NaN */
	movl	d0,sp@-		/* Y on stack */
	movl	FASQ2,sp@-	/* 1. on stack */
	jbsr	spsub		/* 1.-Y */
	movl	d0,d0
	beq	FAS25		/* Jump if 1.-Y is 0. */
	subl	#0x00800000,d0	/* g = (1. - Y)/2 */
FAS25:
	movl	d0,d5		/* Save g */
	jbsr	asqrt		/* sqrt(g) */
	addl	#0x00800000,d0	/* 2.*sqrt(g) */
	bchg	#31,d0		/* Y = -2.*sqrt(g) */
	movl	d0,sp@(4)	/* Y on stack */
	movl	d5,sp@		/* g on stack */
FAS30:
	movl	FASP2,sp@-	/* p2 on stack */
	jbsr	spmul
	movl	d0,sp@		/* p2*g overwrites p2 */
	movl	FASP1,sp@-	/* p2 on stack */
	jbsr	spadd		/* p2*g + p1 */
	addql	#4,sp		/* Clean up stack */
	movl	d0,sp@		/* p2*g + p1 overwrites p2*g */
	jbsr	spmul		/* g*P(g) = (p2*g + p1)*g */
	movl	d0,d5		/* Save g*P(g) */
	movl	FASQ1,sp@	/* q1 on stack */
	jbsr	spadd		/* g + q1 */
	movl	d0,sp@		/* g + q1 overwrites q1 */
	jbsr	spmul		/* ((g + q2)*g + q1)*g */
	movl	d0,sp@		/* ((g + q2)*g + q1)*g  overwrites.... */
	movl	FASQ0,sp@-	/* q0 on stack */
	jbsr	spadd		/* Q(g) = ((g + q2)*g + q1)*g + q0 */
	movl	d0,sp@(4)	/* Q(g) overwrites.... */
	movl	d5,sp@		/* g*P(g) overwrites.... */
	jbsr	spdiv		/* R(g) = g*P(g)/Q(g) */
	lea	sp@(8),sp	/* Clean up stack */
	movl	d0,sp@		/* R(g) overwrites g */
	jbsr	spmul		/* Y*R(g) */
	movl	d0,sp@		/* Y*R(g) overwrites R(g) */
	jbsr	spadd		/* Result = Y + Y*R(g) */
	lea	sp@(8),sp	/* Clean up stack */
FAS40:
	movl	d0,sp@-		/* Result on stack */
	movl	d7,d7		/* Is FLAG zero? */
	bne	FAS60		/* If not, branch */
	movl	d6,d6		/* Is i zero? */
	beq	FAS50		/* If so, branch */
	movl	FASA1,sp@-	/* a1 on stack */
	jbsr	spadd		/* Result = a1 + Result */
	addql	#4,sp		/* Clean up stack */
FAS50:
	addql	#4,sp		/* Clean up stack */
	movl	d4,d4
	bge	FAS100		/* Jump if X >= 0 */
	bchg	#31,d0		/* Negate Result */
	jbr	FAS100		/* Go exit */
FAS60:				/* Come here when FLAG !=0 */
	movl	d4,d4
	blt	FAS80		/* Jump if X < 0 */
	movl	d6,d6		/* Is i zero? */
	beq	FAS70		/* If so, branch */
	movl	FASA1,sp@-	/* a1 on stack */
	jbsr	spsub		/* Result = a1 - Result */
	lea	sp@(8),sp	/* Clean up stack */
	jbr	FAS100		/* Go exit */
FAS70:
	addql	#4,sp		/* Clean up stack */
	bchg	#31,d0		/* Result = - Result */
	jbr	FAS100
FAS80:				/* Come here when FLAG != 0 and X < 0 */
	movl	d6,d6		/* Is i zero? */
	beq	FAS90		/* If so, branch */
	movl	FASB1,sp@-	/* b1 on stack */
	jbsr	spadd		/* Result = b1 + Result */
	lea	sp@(8),sp	/* Clean up stack */
	jbr	FAS100
FAS90:
	movl	FASB0,sp@-	/* b1 on stack */
	jbsr	spadd		/* Result = b1 + Result */
	lea	sp@(8),sp	/* Clean up stack */
FAS100:
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

	.data
