# include "DEFS.h"

ERUNF = 1		/*FPERR UNDERFLOW ERROR CODE */
EROVF = 2		/*FPERR OVERFLOW ERROR CODE */
ERNAN = 3		/*FPERR INVALID OPERATION ERROR CODE */

	.text

/*	These routines are common to the single-precision library functions */
/*	(Actually, FPFADJ is a subroutine; the others are code fragments */
/*	that effect the return from the calling library function */

/*	FPFADJ gets the floating point argument whose address is on the */
/*	stack, then sets the condition code bits N, Z, C (INF), and V (NaN) */
/*	to type the argument quickly. The argument returns in d0.  Registers */
/*	d1 and a0 are also destroyed */

ASENTRY(FPFADJ)
	movl	fp@(8),a0	/* Get address of argument */
	movl	a0@,d0		/* Get argument itself */
	movl	d0,d1
	swap	d1
	rolw	#1,d1
	cmpw	#256*0xFF,d1
	bcs	FPFA10		/* Jump if not INF or NaN */

	andw	#0xFE,d1
	beq	FPFA05

	orb	#0x02,cc	/* Set -V- bit -> NaN argument */
	rts

FPFA05:	tstb	a0@		/* Set N bit as req'd, clear Z bit. */
	orb	#0x01,cc	/* Set -C- bit -> INF argument */
	rts

FPFA10:	tstw	a0@		/* Set N, Z bits as req'd, clear V, C */
	rts



ASENTRY(FFPINR)			/* Result is positive overflow */
	movl	#0x7f800000,d0	/* +INF */
	bra	FFIN01

ASENTRY(FFMINR)			/* Result in negative overflow */
	movl	#0xff800000,d0	/* -INF */

FFIN01:	movb	#EROVF,FPERR
	movb	#-1,INFFLG
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


ASENTRY(FFNANR)			/* Result is NaN */
	moveq	#-1,d0		/* Set D0 to NAN */

	movb	#ERNAN,FPERR
	movb	#-1,NANFLG
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts			/* Return */


ASENTRY(FFUNFR)			/* Underflow result */
	subl	a0,a0		/* Set global return flag */
	movb	#ERUNF,FPERR
	movb	#-1,UNFFLG
	clrl	d0		/* Result is zero */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts


ASENTRY(FFZERR)			/* Result is zero */
	clrl	d0
	movb	#0,FPERR	/* Clear error flag */
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts


ASENTRY(FFONER)			/* Result is 1.0 */
	movl	#0x3F800000,d0
	clrb	FPERR
	moveml	sp@,#0x3cfc	/* Restore registers */
	unlk	fp
	rts

	.data
