/* Copyright (c) 1980 Regents of the University of California */
static	char sccsid[] = "@(#)aspseudo.c 4.3 8/16/80";
#include <stdio.h>
#include "as.h"

extern ea(), ead(), ea_ea6(), ea_r9(), r9_ea();
extern nop(), imm_ea(), ea_imm(), imm(), imml();
extern r0(), r0d(), r0_r9(), r9_r0(), r0_imm(), r0_r9_imm();
extern disp8(), disp16(), disp32(), /*disp(),*/ r0_disp16();
extern q30(), q40(), q39_r0(), q39_ea(), qb0_r9();
extern movs_ea(), ea_movs(), c_r(), r_c();
extern list_ea(), ea_list(), cas_ea(), cas2();
extern ea_rh0(), ea_rh1();
extern ea_rh0p0(), ea_rh0p1(), ea_rh1p0(), ea_rh1p1();
extern eafld(), eafld_r12(), r12_eafld();

/*	1st operand	2nd operand	3nd operand	opcode	generator */
/*	===========	===========	===========	======	========= */

readonly struct insfmt ADDB_FMT[] = {
	{ IMM3&~IMM,	DATA&ALT,	0,		0x5000,	q39_ea,	},
	{ DATAB,	DREG,		0,		0xD000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0xD100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0,		0x0600,	imm_ea,	},
};

readonly struct insfmt ADDW_FMT[] = {
	{ IMM3&~IMM,	ALT,		0,		0x5040,	q39_ea,	},
	{ ALLW,		DREG,		0,		0xD040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0xD140,	r9_ea,	},
	{ ALLSW,	AREG,		0,		0xD0C0,	ea_r9,	},
	{ IMMW,		DATA&ALT,	0,		0x0640,	imm_ea,	},
};

readonly struct insfmt ADDL_FMT[] = {
	{ IMM3&~IMM,	ALT,		0,		0x5080,	q39_ea,	},
	{ ALLL,		DREG,		0,		0xD080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0xD180,	r9_ea,	},
	{ ALLL,		AREG,		0,		0xD1C0,	ea_r9,	},
	{ IMML,		DATA&ALT,	0,		0x0680,	imm_ea,	},
};

readonly struct insfmt ANDB_FMT[] = {
	{ DATAB,	DREG,		0,		0xC000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0xC100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0,		0x0200,	imm_ea,	},
	{ IMMB,		CC,		0,		0x023C,	imm,	},
};

readonly struct insfmt ANDW_FMT[] = {
	{ DATAW,	DREG,		0,		0xC040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0xC140,	r9_ea,	},
	{ IMMW,		DATA&ALT,	0,		0x0240,	imm_ea,	},
	{ IMMW,		SR,		0,		0x027C,	imm,	},
};

readonly struct insfmt ANDL_FMT[] = {
	{ DATAL,	DREG,		0,		0xC080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0xC180,	r9_ea,	},
	{ IMML,		DATA&ALT,	0,		0x0280,	imm_ea,	},
};

readonly struct insfmt CMPB_FMT[] = {
	{ ALLB,		DREG,		0,		0xB000,	ea_r9,	},
	{ IMMB,		DATA&ALT,	0,		0x0C00,	imm_ea,	},
	{ INC,		INC,		0,		0xB108,	r0_r9,	},
};

readonly struct insfmt CMPW_FMT[] = {
	{ ALLW,		DREG,		0,		0xB040,	ea_r9,	},
	{ ALLSW,	AREG,		0,		0xB0C0,	ea_r9,	},
	{ IMMW,		DATA&ALT,	0,		0x0C40,	imm_ea,	},
	{ INC,		INC,		0,		0xB148,	r0_r9,	},
};

readonly struct insfmt CMPL_FMT[] = {
	{ ALLL,		DREG,		0,		0xB080,	ea_r9,	},
	{ ALLL,		AREG,		0,		0xB1C0,	ea_r9,	},
	{ IMML,		DATA&ALT,	0,		0x0C80,	imm_ea,	},
	{ INC,		INC,		0,		0xB188,	r0_r9,	},
};

readonly struct insfmt EORB_FMT[] = {
	{ DREG,		DATA&ALT,	0,		0xB100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0,		0x0A00,	imm_ea,	},
	{ IMMB,		CC,		0,		0x0A3C, imm,	},
};

readonly struct insfmt EORW_FMT[] = {
	{ DREG,		DATA&ALT,	0,		0xB140,	r9_ea,	},
	{ IMMW,		DATA&ALT,	0,		0x0A40,	imm_ea,	},
	{ IMMW,		SR,		0,		0x0A7C, imm,	},
};

readonly struct insfmt EORL_FMT[] = {
	{ DREG,		DATA&ALT,	0,		0xB180,	r9_ea,	},
	{ IMML,		DATA&ALT,	0,		0x0A80,	imm_ea,	},
};

readonly struct insfmt MOVB_FMT[] = {
	{ ALLB,		DATA&ALT,	0,		0x1000,	ea_ea6,	},
};

readonly struct insfmt MOVW_FMT[] = {
	{ ALLW,		ALT&~AREG,	0,		0x3000,	ea_ea6,	},
	{ ALLSW,	AREG,		0,		0x3040,	ea_r9,	},
	{ DATAW,	CC,		0,		0x44C0,	ea,	},
	{ CC,		DATA&ALT,	0,		0x42C0,	ead,	},
	{ DATAW,	SR,		0,		0x46C0,	ea,	},
	{ SR,		DATA&ALT,	0,		0x40C0,	ead,	},
};

readonly struct insfmt MOVL_FMT[] = {
	{ IMMSB&~IMM,	DREG,		0,		0x7000,	qb0_r9,	},
	{ IMMSW&~IMM,	AREG,		0,		0x3040,	ea_r9,	},
	{ ALLL,		ALT&~AREG,	0,		0x2000,	ea_ea6,	},
	{ ALLL,		AREG,		0,		0x2040,	ea_r9,	},
	{ USP,		AREG,		0,		0x4E68,	r0d,	},
	{ AREG,		USP,		0,		0x4E60,	r0,	},
	{ USP|CREG,	DREG|AREG,	0,		0x4E7A,	c_r,	},
	{ DREG|AREG,	USP|CREG,	0,		0x4E7B,	r_c,	},
};

readonly struct insfmt ORB_FMT[] = {
	{ DATAB,	DREG,		0,		0x8000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0x8100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0,		0x0000,	imm_ea,	},
	{ IMMB,		CC,		0,		0x003C, imm,	},
};

readonly struct insfmt ORW_FMT[] = {
	{ DATAW,	DREG,		0,		0x8040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0x8140,	r9_ea,	},
	{ IMMW,		DATA&ALT,	0,		0x0040,	imm_ea,	},
	{ IMMW,		SR,		0,		0x007C, imm,	},
};

readonly struct insfmt ORL_FMT[] = {
	{ DATAL,	DREG,		0,		0x8080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0x8180,	r9_ea,	},
	{ IMML,		DATA&ALT,	0,		0x0080,	imm_ea,	},
};

readonly struct insfmt SUBB_FMT[] = {
	{ IMM3&~IMM,	DATA&ALT,	0,		0x5100,	q39_ea,	},
	{ DATAB,	DREG,		0,		0x9000,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0x9100,	r9_ea,	},
	{ IMMB,		DATA&ALT,	0,		0x0400,	imm_ea,	},
};

readonly struct insfmt SUBW_FMT[] = {
	{ IMM3&~IMM,	ALT,		0,		0x5140,	q39_ea,	},
	{ ALLW,		DREG,		0,		0x9040,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0x9140,	r9_ea,	},
	{ ALLSW,	AREG,		0,		0x90C0,	ea_r9,	},
	{ IMMW,		DATA&ALT,	0,		0x0440,	imm_ea,	},
};

readonly struct insfmt SUBL_FMT[] = {
	{ IMM3&~IMM,	ALT,		0,		0x5180,	q39_ea,	},
	{ ALLL,		DREG,		0,		0x9080,	ea_r9,	},
	{ DREG,		ALT&MEM,	0,		0x9180,	r9_ea,	},
	{ ALLL,		AREG,		0,		0x91C0,	ea_r9,	},
	{ IMML,		DATA&ALT,	0,		0x0480,	imm_ea,	},
};

readonly struct insfmt CLRB_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4200,	ea,	},
};

readonly struct insfmt CLRW_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4240,	ea,	},
};

readonly struct insfmt CLRL_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4280,	ea,	},
};

readonly struct insfmt NBCD_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4800,	ea,	},
};

readonly struct insfmt NEGB_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4400,	ea,	},
};

readonly struct insfmt NEGW_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4440,	ea,	},
};

readonly struct insfmt NEGL_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4480,	ea,	},
};

readonly struct insfmt NEGXB_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4000,	ea,	},
};

readonly struct insfmt NEGXW_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4040,	ea,	},
};

readonly struct insfmt NEGXL_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4080,	ea,	},
};

readonly struct insfmt NOTB_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4600,	ea,	},
};

readonly struct insfmt NOTW_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4640,	ea,	},
};

readonly struct insfmt NOTL_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4680,	ea,	},
};

readonly struct insfmt ST_FMT[] = {
	{ DATA&ALT,	0,		0,		0x50C0,	ea,	},
};

readonly struct insfmt SF_FMT[] = {
	{ DATA&ALT,	0,		0,		0x51C0,	ea,	},
};

readonly struct insfmt SHI_FMT[] = {
	{ DATA&ALT,	0,		0,		0x52C0,	ea,	},
};

readonly struct insfmt SLS_FMT[] = {
	{ DATA&ALT,	0,		0,		0x53C0,	ea,	},
};

readonly struct insfmt SCC_FMT[] = {
	{ DATA&ALT,	0,		0,		0x54C0,	ea,	},
};

readonly struct insfmt SCS_FMT[] = {
	{ DATA&ALT,	0,		0,		0x55C0,	ea,	},
};

readonly struct insfmt SNE_FMT[] = {
	{ DATA&ALT,	0,		0,		0x56C0,	ea,	},
};

readonly struct insfmt SEQ_FMT[] = {
	{ DATA&ALT,	0,		0,		0x57C0,	ea,	},
};

readonly struct insfmt SVC_FMT[] = {
	{ DATA&ALT,	0,		0,		0x58C0,	ea,	},
};

readonly struct insfmt SVS_FMT[] = {
	{ DATA&ALT,	0,		0,		0x59C0,	ea,	},
};

readonly struct insfmt SPL_FMT[] = {
	{ DATA&ALT,	0,		0,		0x5AC0,	ea,	},
};

readonly struct insfmt SMI_FMT[] = {
	{ DATA&ALT,	0,		0,		0x5BC0,	ea,	},
};

readonly struct insfmt SGE_FMT[] = {
	{ DATA&ALT,	0,		0,		0x5CC0,	ea,	},
};

readonly struct insfmt SLT_FMT[] = {
	{ DATA&ALT,	0,		0,		0x5DC0,	ea,	},
};

readonly struct insfmt SGT_FMT[] = {
	{ DATA&ALT,	0,		0,		0x5EC0,	ea,	},
};

readonly struct insfmt SLE_FMT[] = {
	{ DATA&ALT,	0,		0,		0x5FC0,	ea,	},
};

readonly struct insfmt TAS_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4AC0,	ea,	},
};

readonly struct insfmt TSTB_FMT[] = {
	{ DATA&ALT,	0,		0,		0x4A00, ea,	},
};

readonly struct insfmt TSTW_FMT[] = {
	{ DATA&~IMML,	0,		0,		0x4A40, ea,	},
};

readonly struct insfmt TSTL_FMT[] = {
	{ DATA&~IMML,	0,		0,		0x4A80, ea,	},
};

readonly struct insfmt BRA_FMT[] = {
	{ ABS,		0,		0,		0x6000,	disp16,	},
};

readonly struct insfmt BSR_FMT[] = {
	{ ABS,		0,		0,		0x6100,	disp16,	},
};

readonly struct insfmt BHI_FMT[] = {
	{ ABS,		0,		0,		0x6200,	disp16,	},
};

readonly struct insfmt BLS_FMT[] = {
	{ ABS,		0,		0,		0x6300,	disp16,	},
};

readonly struct insfmt BCC_FMT[] = {
	{ ABS,		0,		0,		0x6400,	disp16,	},
};

readonly struct insfmt BCS_FMT[] = {
	{ ABS,		0,		0,		0x6500,	disp16,	},
};

readonly struct insfmt BNE_FMT[] = {
	{ ABS,		0,		0,		0x6600,	disp16,	},
};

readonly struct insfmt BEQ_FMT[] = {
	{ ABS,		0,		0,		0x6700,	disp16,	},
};

readonly struct insfmt BVC_FMT[] = {
	{ ABS,		0,		0,		0x6800,	disp16,	},
};

readonly struct insfmt BVS_FMT[] = {
	{ ABS,		0,		0,		0x6900,	disp16,	},
};

readonly struct insfmt BPL_FMT[] = {
	{ ABS,		0,		0,		0x6A00,	disp16,	},
};

readonly struct insfmt BMI_FMT[] = {
	{ ABS,		0,		0,		0x6B00,	disp16,	},
};

readonly struct insfmt BGE_FMT[] = {
	{ ABS,		0,		0,		0x6C00,	disp16,	},
};

readonly struct insfmt BLT_FMT[] = {
	{ ABS,		0,		0,		0x6D00,	disp16,	},
};

readonly struct insfmt BGT_FMT[] = {
	{ ABS,		0,		0,		0x6E00,	disp16,	},
};

readonly struct insfmt BLE_FMT[] = {
	{ ABS,		0,		0,		0x6F00,	disp16,	},
};

readonly struct insfmt BRAS_FMT[] = {
	{ ABS,		0,		0,		0x6000,	disp8,	},
};

readonly struct insfmt BSRS_FMT[] = {
	{ ABS,		0,		0,		0x6100,	disp8,	},
};

readonly struct insfmt BHIS_FMT[] = {
	{ ABS,		0,		0,		0x6200,	disp8,	},
};

readonly struct insfmt BLSS_FMT[] = {
	{ ABS,		0,		0,		0x6300,	disp8,	},
};

readonly struct insfmt BCCS_FMT[] = {
	{ ABS,		0,		0,		0x6400,	disp8,	},
};

readonly struct insfmt BCSS_FMT[] = {
	{ ABS,		0,		0,		0x6500,	disp8,	},
};

readonly struct insfmt BNES_FMT[] = {
	{ ABS,		0,		0,		0x6600,	disp8,	},
};

readonly struct insfmt BEQS_FMT[] = {
	{ ABS,		0,		0,		0x6700,	disp8,	},
};

readonly struct insfmt BVCS_FMT[] = {
	{ ABS,		0,		0,		0x6800,	disp8,	},
};

readonly struct insfmt BVSS_FMT[] = {
	{ ABS,		0,		0,		0x6900,	disp8,	},
};

readonly struct insfmt BPLS_FMT[] = {
	{ ABS,		0,		0,		0x6A00,	disp8,	},
};

readonly struct insfmt BMIS_FMT[] = {
	{ ABS,		0,		0,		0x6B00,	disp8,	},
};

readonly struct insfmt BGES_FMT[] = {
	{ ABS,		0,		0,		0x6C00,	disp8,	},
};

readonly struct insfmt BLTS_FMT[] = {
	{ ABS,		0,		0,		0x6D00,	disp8,	},
};

readonly struct insfmt BGTS_FMT[] = {
	{ ABS,		0,		0,		0x6E00,	disp8,	},
};

readonly struct insfmt BLES_FMT[] = {
	{ ABS,		0,		0,		0x6F00,	disp8,	},
};

readonly struct insfmt BRAL_FMT[] = {
	{ ABS,		0,		0,		0x6000,	disp32,	},
};

readonly struct insfmt BSRL_FMT[] = {
	{ ABS,		0,		0,		0x6100,	disp32,	},
};

readonly struct insfmt BHIL_FMT[] = {
	{ ABS,		0,		0,		0x6200,	disp32,	},
};

readonly struct insfmt BLSL_FMT[] = {
	{ ABS,		0,		0,		0x6300,	disp32,	},
};

readonly struct insfmt BCCL_FMT[] = {
	{ ABS,		0,		0,		0x6400,	disp32,	},
};

readonly struct insfmt BCSL_FMT[] = {
	{ ABS,		0,		0,		0x6500,	disp32,	},
};

readonly struct insfmt BNEL_FMT[] = {
	{ ABS,		0,		0,		0x6600,	disp32,	},
};

readonly struct insfmt BEQL_FMT[] = {
	{ ABS,		0,		0,		0x6700,	disp32,	},
};

readonly struct insfmt BVCL_FMT[] = {
	{ ABS,		0,		0,		0x6800,	disp32,	},
};

readonly struct insfmt BVSL_FMT[] = {
	{ ABS,		0,		0,		0x6900,	disp32,	},
};

readonly struct insfmt BPLL_FMT[] = {
	{ ABS,		0,		0,		0x6A00,	disp32,	},
};

readonly struct insfmt BMIL_FMT[] = {
	{ ABS,		0,		0,		0x6B00,	disp32,	},
};

readonly struct insfmt BGEL_FMT[] = {
	{ ABS,		0,		0,		0x6C00,	disp32,	},
};

readonly struct insfmt BLTL_FMT[] = {
	{ ABS,		0,		0,		0x6D00,	disp32,	},
};

readonly struct insfmt BGTL_FMT[] = {
	{ ABS,		0,		0,		0x6E00,	disp32,	},
};

readonly struct insfmt BLEL_FMT[] = {
	{ ABS,		0,		0,		0x6F00,	disp32,	},
};

readonly struct insfmt DBT_FMT[] = {
	{ DREG,		ABS,		0,		0x50C8,	r0_disp16, },
};

readonly struct insfmt DBF_FMT[] = {
	{ DREG,		ABS,		0,		0x51C8,	r0_disp16, },
};

readonly struct insfmt DBHI_FMT[] = {
	{ DREG,		ABS,		0,		0x52C8,	r0_disp16, },
};

readonly struct insfmt DBLS_FMT[] = {
	{ DREG,		ABS,		0,		0x53C8,	r0_disp16, },
};

readonly struct insfmt DBCC_FMT[] = {
	{ DREG,		ABS,		0,		0x54C8,	r0_disp16, },
};

readonly struct insfmt DBCS_FMT[] = {
	{ DREG,		ABS,		0,		0x55C8,	r0_disp16, },
};

readonly struct insfmt DBNE_FMT[] = {
	{ DREG,		ABS,		0,		0x56C8,	r0_disp16, },
};

readonly struct insfmt DBEQ_FMT[] = {
	{ DREG,		ABS,		0,		0x57C8,	r0_disp16, },
};

readonly struct insfmt DBVC_FMT[] = {
	{ DREG,		ABS,		0,		0x58C8,	r0_disp16, },
};

readonly struct insfmt DBVS_FMT[] = {
	{ DREG,		ABS,		0,		0x59C8,	r0_disp16, },
};

readonly struct insfmt DBPL_FMT[] = {
	{ DREG,		ABS,		0,		0x5AC8,	r0_disp16, },
};

readonly struct insfmt DBMI_FMT[] = {
	{ DREG,		ABS,		0,		0x5BC8,	r0_disp16, },
};

readonly struct insfmt DBGE_FMT[] = {
	{ DREG,		ABS,		0,		0x5CC8,	r0_disp16, },
};

readonly struct insfmt DBLT_FMT[] = {
	{ DREG,		ABS,		0,		0x5DC8,	r0_disp16, },
};

readonly struct insfmt DBGT_FMT[] = {
	{ DREG,		ABS,		0,		0x5EC8,	r0_disp16, },
};

readonly struct insfmt DBLE_FMT[] = {
	{ DREG,		ABS,		0,		0x5FC8,	r0_disp16, },
};

/* readonly struct insfmt JRA_FMT[] = {
/* 	{ ABS,		0,		0,		0x6000,	disp,	},
/* };
/* 
/* readonly struct insfmt JBSR_FMT[] = {
/* 	{ ABS,		0,		0,		0x6100,	disp,	},
/* };
/* 
/* readonly struct insfmt JHI_FMT[] = {
/* 	{ ABS,		0,		0,		0x6200,	disp,	},
/* };
/* 
/* readonly struct insfmt JLS_FMT[] = {
/* 	{ ABS,		0,		0,		0x6300,	disp,	},
/* };
/* 
/* readonly struct insfmt JCC_FMT[] = {
/* 	{ ABS,		0,		0,		0x6400,	disp,	},
/* };
/* 
/* readonly struct insfmt JCS_FMT[] = {
/* 	{ ABS,		0,		0,		0x6500,	disp,	},
/* };
/* 
/* readonly struct insfmt JNE_FMT[] = {
/* 	{ ABS,		0,		0,		0x6600,	disp,	},
/* };
/* 
/* readonly struct insfmt JEQ_FMT[] = {
/* 	{ ABS,		0,		0,		0x6700,	disp,	},
/* };
/* 
/* readonly struct insfmt JVC_FMT[] = {
/* 	{ ABS,		0,		0,		0x6800,	disp,	},
/* };
/* 
/* readonly struct insfmt JVS_FMT[] = {
/* 	{ ABS,		0,		0,		0x6900,	disp,	},
/* };
/* 
/* readonly struct insfmt JPL_FMT[] = {
/* 	{ ABS,		0,		0,		0x6A00,	disp,	},
/* };
/* 
/* readonly struct insfmt JMI_FMT[] = {
/* 	{ ABS,		0,		0,		0x6B00,	disp,	},
/* };
/* 
/* readonly struct insfmt JGE_FMT[] = {
/* 	{ ABS,		0,		0,		0x6C00,	disp,	},
/* };
/* 
/* readonly struct insfmt JLT_FMT[] = {
/* 	{ ABS,		0,		0,		0x6D00,	disp,	},
/* };
/* 
/* readonly struct insfmt JGT_FMT[] = {
/* 	{ ABS,		0,		0,		0x6E00,	disp,	},
/* };
/* 
/* readonly struct insfmt JLE_FMT[] = {
/* 	{ ABS,		0,		0,		0x6F00,	disp,	},
/* };
/* */

readonly struct insfmt ASL_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE1C0,	ea,	},
};

readonly struct insfmt ASLB_FMT[] = {
	{ DREG,		DREG,		0,		0xE120,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE100,	q39_r0,	},
};

readonly struct insfmt ASLW_FMT[] = {
	{ DREG,		DREG,		0,		0xE160,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE140,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE1C0,	ead,	},
};

readonly struct insfmt ASLL_FMT[] = {
	{ DREG,		DREG,		0,		0xE1A0,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE180,	q39_r0,	},
};

readonly struct insfmt ASR_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE0C0,	ea,	},
};

readonly struct insfmt ASRB_FMT[] = {
	{ DREG,		DREG,		0,		0xE020,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE000,	q39_r0,	},
};

readonly struct insfmt ASRW_FMT[] = {
	{ DREG,		DREG,		0,		0xE060,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE040,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE0C0,	ead,	},
};

readonly struct insfmt ASRL_FMT[] = {
	{ DREG,		DREG,		0,		0xE0A0,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE080,	q39_r0,	},
};

readonly struct insfmt LSL_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE3C0,	ea,	},
};

readonly struct insfmt LSLB_FMT[] = {
	{ DREG,		DREG,		0,		0xE128,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE108,	q39_r0,	},
};

readonly struct insfmt LSLW_FMT[] = {
	{ DREG,		DREG,		0,		0xE168,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE148,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE3C0,	ead,	},
};

readonly struct insfmt LSLL_FMT[] = {
	{ DREG,		DREG,		0,		0xE1A8,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE188,	q39_r0,	},
};

readonly struct insfmt LSR_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE2C0,	ea,	},
};

readonly struct insfmt LSRB_FMT[] = {
	{ DREG,		DREG,		0,		0xE028,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE008,	q39_r0,	},
};

readonly struct insfmt LSRW_FMT[] = {
	{ DREG,		DREG,		0,		0xE068,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE048,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE2C0,	ead,	},
};

readonly struct insfmt LSRL_FMT[] = {
	{ DREG,		DREG,		0,		0xE0A8,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE088,	q39_r0,	},
};

readonly struct insfmt ROL_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE7C0,	ea,	},
};

readonly struct insfmt ROLB_FMT[] = {
	{ DREG,		DREG,		0,		0xE138,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE118,	q39_r0,	},
};

readonly struct insfmt ROLW_FMT[] = {
	{ DREG,		DREG,		0,		0xE178,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE158,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE7C0,	ead,	},
};

readonly struct insfmt ROLL_FMT[] = {
	{ DREG,		DREG,		0,		0xE1B8,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE198,	q39_r0,	},
};

readonly struct insfmt ROR_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE6C0,	ea,	},
};

readonly struct insfmt RORB_FMT[] = {
	{ DREG,		DREG,		0,		0xE038,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE018,	q39_r0,	},
};

readonly struct insfmt RORW_FMT[] = {
	{ DREG,		DREG,		0,		0xE078,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE058,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE6C0,	ead,	},
};

readonly struct insfmt RORL_FMT[] = {
	{ DREG,		DREG,		0,		0xE0B8,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE098,	q39_r0,	},
};

readonly struct insfmt ROXL_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE5C0,	ea,	},
};

readonly struct insfmt ROXLB_FMT[] = {
	{ DREG,		DREG,		0,		0xE130,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE110,	q39_r0,	},
};

readonly struct insfmt ROXLW_FMT[] = {
	{ DREG,		DREG,		0,		0xE170,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE150,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE5C0,	ead,	},
};

readonly struct insfmt ROXLL_FMT[] = {
	{ DREG,		DREG,		0,		0xE1B0,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE190,	q39_r0,	},
};

readonly struct insfmt ROXR_FMT[] = {
	{ MEM&ALT,	0,		0,		0xE4C0,	ea,	},
};

readonly struct insfmt ROXRB_FMT[] = {
	{ DREG,		DREG,		0,		0xE030,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE010,	q39_r0,	},
};

readonly struct insfmt ROXRW_FMT[] = {
	{ DREG,		DREG,		0,		0xE070,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE050,	q39_r0,	},
	{ IMM1,		MEM&ALT,	0,		0xE4C0,	ead,	},
};

readonly struct insfmt ROXRL_FMT[] = {
	{ DREG,		DREG,		0,		0xE0B0,	r9_r0,	},
	{ IMM3,		DREG,		0,		0xE090,	q39_r0,	},
};

readonly struct insfmt ABCD_FMT[] = {
	{ DREG,		DREG,		0,		0xC100,	r0_r9,	},
	{ DEC,		DEC,		0,		0xC108,	r0_r9,	},
};

readonly struct insfmt ADDQB_FMT[] = {
	{ IMM3,		DATA&ALT,	0,		0x5000,	q39_ea,	},
};

readonly struct insfmt ADDQW_FMT[] = {
	{ IMM3,		ALT,		0,		0x5040,	q39_ea,	},
};

readonly struct insfmt ADDQL_FMT[] = {
	{ IMM3,		ALT,		0,		0x5080,	q39_ea,	},
};

readonly struct insfmt ADDXB_FMT[] = {
	{ DREG,		DREG,		0,		0xD100,	r0_r9,	},
	{ DEC,		DEC,		0,		0xD108,	r0_r9,	},
};

readonly struct insfmt ADDXW_FMT[] = {
	{ DREG,		DREG,		0,		0xD140,	r0_r9,	},
	{ DEC,		DEC,		0,		0xD148,	r0_r9,	},
};

readonly struct insfmt ADDXL_FMT[] = {
	{ DREG,		DREG,		0,		0xD180,	r0_r9,	},
	{ DEC,		DEC,		0,		0xD188,	r0_r9,	},
};

readonly struct insfmt BKPT_FMT[] = {
	{ IMB3,		0,		0,		0x4848,	q30,	},
};

readonly struct insfmt BTST_FMT[] = {
	{ DREG,		DATA&~IMM,	0,		0x0100,	r9_ea,	},
	{ IMB5,		DREG,		0,		0x0800,	imm_ea,	},
	{ IMB3,		MEM&~IMM,	0,		0x0800,	imm_ea,	},
};

readonly struct insfmt BCHG_FMT[] = {
	{ DREG,		DATA&ALT,	0,		0x0140,	r9_ea,	},
	{ IMB5,		DREG,		0,		0x0840,	imm_ea,	},
	{ IMB3,		MEM&ALT,	0,		0x0840,	imm_ea,	},
};

readonly struct insfmt BCLR_FMT[] = {
	{ DREG,		DATA&ALT,	0,		0x0180,	r9_ea,	},
	{ IMB5,		DREG,		0,		0x0880,	imm_ea,	},
	{ IMB3,		MEM&ALT,	0,		0x0880,	imm_ea,	},
};

readonly struct insfmt BSET_FMT[] = {
	{ DREG,		DATA&ALT,	0,		0x01C0,	r9_ea,	},
	{ IMB5,		DREG,		0,		0x08C0,	imm_ea,	},
	{ IMB3,		MEM&ALT,	0,		0x08C0,	imm_ea,	},
};

readonly struct insfmt BFTST_FMT[] = {
	{ DREG|CONT,	0,		0,		0xE8C0,	eafld,	},
};

readonly struct insfmt BFCHG_FMT[] = {
	{ DREG|MOST,	0,		0,		0xEAC0,	eafld,	},
};

readonly struct insfmt BFCLR_FMT[] = {
	{ DREG|MOST,	0,		0,		0xECC0,	eafld,	},
};

readonly struct insfmt BFSET_FMT[] = {
	{ DREG|MOST,	0,		0,		0xEEC0,	eafld,	},
};

readonly struct insfmt BFEXTU_FMT[] = {
	{ DREG|CONT,	DREG,		0,		0xE9C0,	eafld_r12,},
};

readonly struct insfmt BFEXTS_FMT[] = {
	{ DREG|CONT,	DREG,		0,		0xEBC0,	eafld_r12,},
};

readonly struct insfmt BFFFO_FMT[] = {
	{ DREG|CONT,	DREG,		0,		0xEDC0,	eafld_r12,},
};

readonly struct insfmt BFINS_FMT[] = {
	{ DREG,		DREG|MOST,	0,		0xEFC0,	r12_eafld,},
};

readonly struct insfmt CALLM_FMT[] = {
	{ IMMB,		CONT,		0,		0x06C0,	imm_ea,	},
};

readonly struct insfmt CASB_FMT[] = {
	{ DREG,		DREG,		ALT&MEM,	0x0AC0,	cas_ea,},
};

readonly struct insfmt CASW_FMT[] = {
	{ DREG,		DREG,		ALT&MEM,	0x0CC0,	cas_ea,},
};

readonly struct insfmt CASL_FMT[] = {
	{ DREG,		DREG,		ALT&MEM,	0x0EC0,	cas_ea,},
};

readonly struct insfmt CAS2B_FMT[] = {
	{ REGPAIR,	REGPAIR,	REGPAIR,	0x0AFC,	cas2,},
};

readonly struct insfmt CAS2W_FMT[] = {
	{ REGPAIR,	REGPAIR,	REGPAIR,	0x0CFC,	cas2,},
};

readonly struct insfmt CAS2L_FMT[] = {
	{ REGPAIR,	REGPAIR,	REGPAIR,	0x0EFC,	cas2,},
};

readonly struct insfmt CHKW_FMT[] = {
	{ DATAW,	DREG,		0,		0x4180,	ea_r9,	},
};

readonly struct insfmt CHKL_FMT[] = {
	{ DATAL,	DREG,		0,		0x4100,	ea_r9,	},
};

readonly struct insfmt CHK2B_FMT[] = {
	{ CONT,		DREG|AREG,	0,		0x00C0,	ea_rh1,},
};

readonly struct insfmt CHK2W_FMT[] = {
	{ CONT,		DREG|AREG,	0,		0x02C0,	ea_rh1,},
};

readonly struct insfmt CHK2L_FMT[] = {
	{ CONT,		DREG|AREG,	0,		0x04C0,	ea_rh1,},
};

readonly struct insfmt CMPMB_FMT[] = {
	{ INC,		INC,		0,		0xB108,	r0_r9,	},
};

readonly struct insfmt CMPMW_FMT[] = {
	{ INC,		INC,		0,		0xB148,	r0_r9,	},
};

readonly struct insfmt CMPML_FMT[] = {
	{ INC,		INC,		0,		0xB188,	r0_r9,	},
};

readonly struct insfmt CMP2B_FMT[] = {
	{ CONT,		DREG|AREG,	0,		0x00C0,	ea_rh0,},
};

readonly struct insfmt CMP2W_FMT[] = {
	{ CONT,		DREG|AREG,	0,		0x02C0,	ea_rh0,},
};

readonly struct insfmt CMP2L_FMT[] = {
	{ CONT,		DREG|AREG,	0,		0x04C0,	ea_rh0,},
};

readonly struct insfmt DIVSW_FMT[] = {
	{ DATAW,	DREG,		0,		0x81C0,	ea_r9,	},
};

readonly struct insfmt DIVUW_FMT[] = {
	{ DATAW,	DREG,		0,		0x80C0,	ea_r9,	},
};

readonly struct insfmt DIVSL_FMT[] = {
	{ DATAL,	DREG,		0,		0x4C40,	ea_rh1p0,},
	{ DATAL,	REGPAIR,	0,		0x4C40,	ea_rh1p1,},
};

readonly struct insfmt DIVSLL_FMT[] = {
	{ DATAL,	REGPAIR,	0,		0x4C40,	ea_rh1p0,},
};

readonly struct insfmt DIVUL_FMT[] = {
	{ DATAL,	DREG,		0,		0x4C40,	ea_rh0p0,},
	{ DATAL,	REGPAIR,	0,		0x4C40,	ea_rh0p1,},
};

readonly struct insfmt DIVULL_FMT[] = {
	{ DATAL,	REGPAIR,	0,		0x4C40,	ea_rh0p0,},
};

readonly struct insfmt EXG_FMT[] = {
	{ DREG,		DREG,		0,		0xC140,	r0_r9,	},
	{ AREG,		AREG,		0,		0xC148,	r0_r9,	},
	{ AREG,		DREG,		0,		0xC188,	r0_r9,	},
	{ DREG,		AREG,		0,		0xC188,	r9_r0,	},
};

readonly struct insfmt EXTW_FMT[] = {
	{ DREG,		0,		0,		0x4880,	r0,	},
};

readonly struct insfmt EXTL_FMT[] = {
	{ DREG,		0,		0,		0x48C0,	r0,	},
};

readonly struct insfmt EXTBL_FMT[] = {
	{ DREG,		0,		0,		0x49C0,	r0,	},
};

readonly struct insfmt JMP_FMT[] = {
	{ CONT,		0,		0,		0x4EC0,	ea,	},
};

readonly struct insfmt JSR_FMT[] = {
	{ CONT,		0,		0,		0x4E80,	ea,	},
};

readonly struct insfmt LEA_FMT[] = {
	{ CONT,		AREG,		0,		0x41C0,	ea_r9,	},
};

readonly struct insfmt LINK_FMT[] = {
	{ AREG,		IMMW,		0,		0x4E50,	r0_imm,	},
	{ AREG,		IMML,		0,		0x4808,	r0_imm,	},
};

readonly struct insfmt MOVC_FMT[] = {
	{ USP|CREG,	DREG|AREG,	0,		0x4E7A,	c_r,	},
	{ DREG|AREG,	USP|CREG,	0,		0x4E7B,	r_c,	},
};

readonly struct insfmt MOVMW_FMT[] = {
	{ IMMW,		(CONT&ALT)|DEC,	0,		0x4880,	imm_ea,	},
	{ REGLIST,	(CONT&ALT)|DEC,	0,		0x4880,	list_ea,},
	{ CONT|INC,	IMMW,		0,		0x4C80,	ea_imm,	},
	{ CONT|INC,	REGLIST,	0,		0x4C80,	ea_list,},
};

readonly struct insfmt MOVML_FMT[] = {
	{ IMMW,		(CONT&ALT)|DEC,	0,		0x48C0,	imm_ea,	},
	{ REGLIST,	(CONT&ALT)|DEC,	0,		0x48C0,	list_ea,},
	{ CONT|INC,	IMMW,		0,		0x4CC0,	ea_imm,	},
	{ CONT|INC,	REGLIST,	0,		0x4CC0,	ea_list,},
};

readonly struct insfmt MOVPW_FMT[] = {
	{ DREG,		DISP,		0,		0x0188,	r9_r0,	},
	{ DISP,		DREG,		0,		0x0108,	r0_r9,	},
};

readonly struct insfmt MOVPL_FMT[] = {
	{ DREG,		DISP,		0,		0x01C8,	r9_r0,	},
	{ DISP,		DREG,		0,		0x0148,	r0_r9,	},
};

readonly struct insfmt MOVSB_FMT[] = {
	{ DREG|AREG,	ALT&MEM,	0,		0x0E00,	movs_ea, },
	{ ALT&MEM,	DREG|AREG,	0,		0x0E00,	ea_movs, },
};

readonly struct insfmt MOVSW_FMT[] = {
	{ DREG|AREG,	ALT&MEM,	0,		0x0E40,	movs_ea, },
	{ ALT&MEM,	DREG|AREG,	0,		0x0E40,	ea_movs, },
};

readonly struct insfmt MOVSL_FMT[] = {
	{ DREG|AREG,	ALT&MEM,	0,		0x0E80,	movs_ea, },
	{ ALT&MEM,	DREG|AREG,	0,		0x0E80,	ea_movs, },
};

readonly struct insfmt MOVQ_FMT[] = {
	{ IMMB,		DREG,		0,		0x7000,	qb0_r9,	},
};

readonly struct insfmt MULSW_FMT[] = {
	{ DATAW,	DREG,		0,		0xC1C0,	ea_r9,	},
};

readonly struct insfmt MULUW_FMT[] = {
	{ DATAW,	DREG,		0,		0xC0C0,	ea_r9,	},
};

readonly struct insfmt MULSL_FMT[] = {
	{ DATAL,	DREG,		0,		0x4C00,	ea_rh1p0,},
	{ DATAL,	REGPAIR,	0,		0x4C00,	ea_rh1p1,},
};

readonly struct insfmt MULUL_FMT[] = {
	{ DATAL,	DREG,		0,		0x4C00,	ea_rh0p0,},
	{ DATAL,	REGPAIR,	0,		0x4C00,	ea_rh0p1,},
};

readonly struct insfmt NOP_FMT[] = {
	{ 0,		0,		0,		0x4E71,	nop,	},
};

readonly struct insfmt PEA_FMT[] = {
	{ CONT,		0,		0,		0x4840,	ea,	},
};

readonly struct insfmt PACK_FMT[] = {
	{ DREG,		DREG,		IMMW,		0x8140,	r0_r9_imm,},
	{ DEC,		DEC,		IMMW,		0x8148,	r0_r9_imm,},
};

readonly struct insfmt RESET_FMT[] = {
	{ 0,		0,		0,		0x4E70,	nop,	},
};

readonly struct insfmt RTE_FMT[] = {
	{ 0,		0,		0,		0x4E73,	nop,	},
};

readonly struct insfmt RTD_FMT[] = {
	{ IMMW,		0,		0,		0x4E74,	imm,	},
};

readonly struct insfmt RTS_FMT[] = {
	{ 0,		0,		0,		0x4E75,	nop,	},
};

readonly struct insfmt RTM_FMT[] = {
	{ DREG,		0,		0,		0x06C0,	r0,	},
	{ AREG,		0,		0,		0x06C8,	r0,	},
};

readonly struct insfmt RTR_FMT[] = {
	{ 0,		0,		0,		0x4E77,	nop,	},
};

readonly struct insfmt SBCD_FMT[] = {
	{ DREG,		DREG,		0,		0x8100,	r0_r9,	},
	{ DEC,		DEC,		0,		0x8108,	r0_r9,	},
};

readonly struct insfmt STOP_FMT[] = {
	{ IMMW,		0,		0,		0x4E72,	imm,	},
};

readonly struct insfmt SUBQB_FMT[] = {
	{ IMM3,		DATA&ALT,	0,		0x5100,	q39_ea,	},
};

readonly struct insfmt SUBQW_FMT[] = {
	{ IMM3,		ALT,		0,		0x5140,	q39_ea,	},
};

readonly struct insfmt SUBQL_FMT[] = {
	{ IMM3,		ALT,		0,		0x5180,	q39_ea,	},
};

readonly struct insfmt SUBXB_FMT[] = {
	{ DREG,		DREG,		0,		0x9100,	r0_r9,	},
	{ DEC,		DEC,		0,		0x9108,	r0_r9,	},
};

readonly struct insfmt SUBXW_FMT[] = {
	{ DREG,		DREG,		0,		0x9140,	r0_r9,	},
	{ DEC,		DEC,		0,		0x9148,	r0_r9,	},
};

readonly struct insfmt SUBXL_FMT[] = {
	{ DREG,		DREG,		0,		0x9180,	r0_r9,	},
	{ DEC,		DEC,		0,		0x9188,	r0_r9,	},
};

readonly struct insfmt SWAP_FMT[] = {
	{ DREG,		0,		0,		0x4840,	r0,	},
};

readonly struct insfmt TRAP_FMT[] = {
	{ IMMB,		0,		0,		0x4E40,	q40,	},
};

readonly struct insfmt TRAPV_FMT[] = {
	{ 0,		0,		0,		0x4E76,	nop,	},
};

readonly struct insfmt TRAPT_FMT[] = {
	{ 0,		0,		0,		0x50FC,	nop,	},
};

readonly struct insfmt TRAPF_FMT[] = {
	{ 0,		0,		0,		0x51FC,	nop,	},
};

readonly struct insfmt TRAPHI_FMT[] = {
	{ 0,		0,		0,		0x52FC,	nop,	},
};

readonly struct insfmt TRAPLS_FMT[] = {
	{ 0,		0,		0,		0x53FC,	nop,	},
};

readonly struct insfmt TRAPCC_FMT[] = {
	{ 0,		0,		0,		0x54FC,	nop,	},
};

readonly struct insfmt TRAPCS_FMT[] = {
	{ 0,		0,		0,		0x55FC,	nop,	},
};

readonly struct insfmt TRAPNE_FMT[] = {
	{ 0,		0,		0,		0x56FC,	nop,	},
};

readonly struct insfmt TRAPEQ_FMT[] = {
	{ 0,		0,		0,		0x57FC,	nop,	},
};

readonly struct insfmt TRAPVC_FMT[] = {
	{ 0,		0,		0,		0x58FC,	nop,	},
};

readonly struct insfmt TRAPVS_FMT[] = {
	{ 0,		0,		0,		0x59FC,	nop,	},
};

readonly struct insfmt TRAPPL_FMT[] = {
	{ 0,		0,		0,		0x5AFC,	nop,	},
};

readonly struct insfmt TRAPMI_FMT[] = {
	{ 0,		0,		0,		0x5BFC,	nop,	},
};

readonly struct insfmt TRAPGE_FMT[] = {
	{ 0,		0,		0,		0x5CFC,	nop,	},
};

readonly struct insfmt TRAPLT_FMT[] = {
	{ 0,		0,		0,		0x5DFC,	nop,	},
};

readonly struct insfmt TRAPGT_FMT[] = {
	{ 0,		0,		0,		0x5EFC,	nop,	},
};

readonly struct insfmt TRAPLE_FMT[] = {
	{ 0,		0,		0,		0x5FFC,	nop,	},
};

readonly struct insfmt TRAPTL_FMT[] = {
	{ IMML,		0,		0,		0x50FB,	imml,	},
};

readonly struct insfmt TRAPFL_FMT[] = {
	{ IMML,		0,		0,		0x51FB,	imml,	},
};

readonly struct insfmt TRAPHIL_FMT[] = {
	{ IMML,		0,		0,		0x52FB,	imml,	},
};

readonly struct insfmt TRAPLSL_FMT[] = {
	{ IMML,		0,		0,		0x53FB,	imml,	},
};

readonly struct insfmt TRAPCCL_FMT[] = {
	{ IMML,		0,		0,		0x54FB,	imml,	},
};

readonly struct insfmt TRAPCSL_FMT[] = {
	{ IMML,		0,		0,		0x55FB,	imml,	},
};

readonly struct insfmt TRAPNEL_FMT[] = {
	{ IMML,		0,		0,		0x56FB,	imml,	},
};

readonly struct insfmt TRAPEQL_FMT[] = {
	{ IMML,		0,		0,		0x57FB,	imml,	},
};

readonly struct insfmt TRAPVCL_FMT[] = {
	{ IMML,		0,		0,		0x58FB,	imml,	},
};

readonly struct insfmt TRAPVSL_FMT[] = {
	{ IMML,		0,		0,		0x59FB,	imml,	},
};

readonly struct insfmt TRAPPLL_FMT[] = {
	{ IMML,		0,		0,		0x5AFB,	imml,	},
};

readonly struct insfmt TRAPMIL_FMT[] = {
	{ IMML,		0,		0,		0x5BFB,	imml,	},
};

readonly struct insfmt TRAPGEL_FMT[] = {
	{ IMML,		0,		0,		0x5CFB,	imml,	},
};

readonly struct insfmt TRAPLTL_FMT[] = {
	{ IMML,		0,		0,		0x5DFB,	imml,	},
};

readonly struct insfmt TRAPGTL_FMT[] = {
	{ IMML,		0,		0,		0x5EFB,	imml,	},
};

readonly struct insfmt TRAPLEL_FMT[] = {
	{ IMML,		0,		0,		0x5FFB,	imml,	},
};

readonly struct insfmt TRAPTW_FMT[] = {
	{ IMMW,		0,		0,		0x50FA,	imm,	},
};

readonly struct insfmt TRAPFW_FMT[] = {
	{ IMMW,		0,		0,		0x51FA,	imm,	},
};

readonly struct insfmt TRAPHIW_FMT[] = {
	{ IMMW,		0,		0,		0x52FA,	imm,	},
};

readonly struct insfmt TRAPLSW_FMT[] = {
	{ IMMW,		0,		0,		0x53FA,	imm,	},
};

readonly struct insfmt TRAPCCW_FMT[] = {
	{ IMMW,		0,		0,		0x54FA,	imm,	},
};

readonly struct insfmt TRAPCSW_FMT[] = {
	{ IMMW,		0,		0,		0x55FA,	imm,	},
};

readonly struct insfmt TRAPNEW_FMT[] = {
	{ IMMW,		0,		0,		0x56FA,	imm,	},
};

readonly struct insfmt TRAPEQW_FMT[] = {
	{ IMMW,		0,		0,		0x57FA,	imm,	},
};

readonly struct insfmt TRAPVCW_FMT[] = {
	{ IMMW,		0,		0,		0x58FA,	imm,	},
};

readonly struct insfmt TRAPVSW_FMT[] = {
	{ IMMW,		0,		0,		0x59FA,	imm,	},
};

readonly struct insfmt TRAPPLW_FMT[] = {
	{ IMMW,		0,		0,		0x5AFA,	imm,	},
};

readonly struct insfmt TRAPMIW_FMT[] = {
	{ IMMW,		0,		0,		0x5BFA,	imm,	},
};

readonly struct insfmt TRAPGEW_FMT[] = {
	{ IMMW,		0,		0,		0x5CFA,	imm,	},
};

readonly struct insfmt TRAPLTW_FMT[] = {
	{ IMMW,		0,		0,		0x5DFA,	imm,	},
};

readonly struct insfmt TRAPGTW_FMT[] = {
	{ IMMW,		0,		0,		0x5EFA,	imm,	},
};

readonly struct insfmt TRAPLEW_FMT[] = {
	{ IMMW,		0,		0,		0x5FFA,	imm,	},
};

readonly struct insfmt UNLK_FMT[] = {
	{ AREG,		0,		0,		0x4E58,	r0,	},
};

readonly struct insfmt UNPK_FMT[] = {
	{ DREG,		DREG,		IMMW,		0x8180,	r0_r9_imm,},
	{ DEC,		DEC,		IMMW,		0x8188,	r0_r9_imm,},
};

/* ??? FOLLOWING IS TEMPORARY FOR DEVELOPMENT ONLY ??? */
#include "fp_pseudo"


#define	OP(name, opcode, nargs, fmt, tag) \
	{ \
		name, ((sizeof fmt)/(sizeof fmt[0])), nargs, opcode, fmt, tag \
	}
#define	PSEUDO(name, type, tag) \
	{ \
		name, 0, 0, type, 0, \
		tag \
	}

readonly struct Instab instab[] = {
PSEUDO(".space",	0,	ISPACE),
PSEUDO(".fill",		0,	IFILL),
PSEUDO(".byte",		0,	IBYTE),
PSEUDO(".word",		0,	IWORD),
PSEUDO(".long",		0,	ILONG),
PSEUDO(".int",		0,	IINT),
PSEUDO(".quad",		0,	IQUAD),
PSEUDO(".data",		0,	IDATA),
PSEUDO(".globl",	0,	IGLOBAL),
PSEUDO(".set",		0,	ISET),
PSEUDO(".text",		0,	ITEXT),
PSEUDO(".comm",		0,	ICOMM),
PSEUDO(".lcomm",	0,	ILCOMM),
PSEUDO(".lsym",		0,	ILSYM),
PSEUDO(".align",	0,	IALIGN),
PSEUDO(".even",		0,	IEVEN),
PSEUDO(".float",	0,	IFLOAT),
PSEUDO(".double",	0,	IDOUBLE),
PSEUDO(".org",		0,	IORG),
PSEUDO(".stab",		0,	ISTAB),
PSEUDO(".stabs",	0,	ISTABSTR),
PSEUDO(".stabn",	0,	ISTABNONE),
PSEUDO(".stabd",	0,	ISTABDOT),
PSEUDO(".ascii",	0,	IASCII),
PSEUDO(".asciz",	0,	IASCIZ),
PSEUDO(".file",		0,	IFILE),
PSEUDO(".line",		0,	ILINENO),
PSEUDO(".ABORT",	0,	IABORT),

PSEUDO("d0",		0,	REG),
PSEUDO("d1",		1,	REG),
PSEUDO("d2",		2,	REG),
PSEUDO("d3",		3,	REG),
PSEUDO("d4",		4,	REG),
PSEUDO("d5",		5,	REG),
PSEUDO("d6",		6,	REG),
PSEUDO("d7",		7,	REG),
PSEUDO("a0",		8,	REG),
PSEUDO("a1",		9,	REG),
PSEUDO("a2",		10,	REG),
PSEUDO("a3",		11,	REG),
PSEUDO("a4",		12,	REG),
PSEUDO("a5",		13,	REG),
PSEUDO("a6",		14,	REG),
PSEUDO("a7",		15,	REG),
PSEUDO("fp",		14,	REG),
PSEUDO("sp",		15,	REG),
PSEUDO("f0",		16,	REG),
PSEUDO("f1",		17,	REG),
PSEUDO("f2",		18,	REG),
PSEUDO("f3",		19,	REG),
PSEUDO("f4",		20,	REG),
PSEUDO("f5",		21,	REG),
PSEUDO("f6",		22,	REG),
PSEUDO("f7",		23,	REG),
PSEUDO("fpcr",		R_FPCR,	REG),
PSEUDO("fpsr",		R_FPSR,	REG),
PSEUDO("fpiar",		R_FPIAR,	REG),
PSEUDO("pc",		R_PC,	REG),
PSEUDO("zpc",		R_ZPC,	REG),
PSEUDO("za",		R_ZA,	REG),
PSEUDO("cc",		R_CC,	REG),
PSEUDO("sr",		R_SR,	REG),
PSEUDO("usp",		R_USP,	REG),
PSEUDO("vb",		R_VB,	REG),
PSEUDO("sfc",		R_SFC,	REG),
PSEUDO("dfc",		R_DFC,	REG),
PSEUDO("cac",		R_CAC,	REG),
PSEUDO("caa",		R_CAA,	REG),
PSEUDO("msp",		R_MSP,	REG),
PSEUDO("isp",		R_ISP,	REG),

#include "instrs"

0
};

#ifdef	DEBUG
readonly char *regstrs[] = {
	"d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",
	"a0", "a1", "a2", "a3", "a4", "a5", "a6", "sp",
	"pc", "zpc", "za", "cc", "sr",
	"usp", "vb", "sfc", "dfc",
	"caa", "cac", "msp", "isp"
};

readonly struct Tok_Desc{
	int		tok_which;
	char		*tok_name;
} tok_desc[] = {
	FIRSTTOKEN,	"firsttoken",	/* 0 */
	ISPACE,		"ispace", 	/* 1 */
	IBYTE,		"ibyte", 	/* 2 */
	IWORD,		"iword", 	/* 3 */
	IINT,		"iint", 	/* 4 */
	ILONG,		"ilong", 	/* 5 */
	IDATA,		"idata", 	/* 6 */
	IGLOBAL,	"iglobal", 	/* 7 */
	ISET,		"iset", 	/* 8 */
	ITEXT,		"itext", 	/* 9 */
	ICOMM,		"icomm", 	/* 10 */
	ILCOMM,		"ilcomm", 	/* 11 */
	IFLOAT,		"ifloat", 	/* 12 */
	IDOUBLE,	"idouble", 	/* 13 */
	IORG,		"iorg", 	/* 14 */
	IASCII,		"iascii", 	/* 15 */
	IASCIZ,		"iasciz", 	/* 16 */
	ILSYM,		"ilsym", 	/* 17 */
	IFILE,		"ifile", 	/* 18 */
	ILINENO,	"ilineno", 	/* 19 */
	IABORT,		"iabort", 	/* 20 */
	ISTAB,		"istab", 	/* 23 */
	ISTABSTR,	"istabstr", 	/* 24 */
	ISTABNONE,	"istabnone", 	/* 25 */
	ISTABDOT,	"istabdot", 	/* 26 */
	IJXXX,		"ijxxx", 	/* 27 */
	IALIGN,		"ialign", 	/* 28 */
	IEVEN,		"ieven", 	/* 29 */
	INST0,		"inst0", 	/* 30 */
	INSTn,		"instn", 	/* 31 */
	BFINT,		"bfint",	/* 32 */
	PARSEEOF,	"parseeof",	/* 33 */
	ILINESKIP,	"ilineskip",	/* 34 */
	VOID,		"void",		/* 35 */
	SKIP,		"skip",		/* 36 */
	INT,		"int",		/* 37 */
	FLTNUM,		"fltnum",	/* 38 */
	NAME,		"name",		/* 39 */
	STRING,		"string",	/* 40 */
	QUAD,		"quad",		/* 41 */
	SIZESPEC,	"sizespec", 	/* 42 */
	REG,		"reg",		/* 43 */
	MUL,		"mul",		/* 44 */
	LITOP,		"litop",	/* 45 */
	LP,		"lp",		/* 46 */
	IND,		"ind",		/* 47 */
	NEEDSBUF,	"needsbuf",	/* 48 */	
	REGOP,		"regop",	/* 49 */
	NL,		"nl",		/* 50 */
	SCANEOF,	"scaneof",	/* 51 */
	BADCHAR,	"badchar",	/* 52 */
	SP,		"sp",		/* 53 */
	ALPH,		"alph",		/* 54 */
	DIG,		"dig",		/* 55 */
	SQ,		"sq",		/* 56 */
	DQ,		"dq",		/* 57 */
	BUCK,		"buck",		/* 58 */
	LSH,		"lsh",		/* 59 */
	RSH,		"rsh",		/* 60 */
	MINUS,		"minus",	/* 61 */
	LA,		"la",		/* 62 */
	RA,		"ra",		/* 63 */
	XOR,		"xor",		/* 64 */
	DIV,		"div",		/* 65 */
	SEMI,		"semi",		/* 66 */
	COLON,		"colon",	/* 67 */
	PLUS,		"plus",		/* 68 */
	IOR,		"ior",		/* 69 */ 
	AND,		"and",		/* 70 */
	TILDE,		"tilde",	/* 71 */
	ORNOT,		"ornot",	/* 72 */
	CM,		"cm",		/* 73 */
	LB,		"lb",		/* 74 */
	RB,		"rb",		/* 75 */
	RP,		"rp",		/* 76 */
	ASSIGN,		"assign",	/* 77 */
	LCB,		"lcb",		/* 78 */
	RCB,		"rcb",		/* 79 */
	LASTTOKEN,	"lasttoken",	/* 80 */
	0,		(char *)0
};
#endif DEBUG
