/* Copyright (c) 1980 Regents of the University of California */
static	char sccsid[] = "@(#)asjxxx.c 4.5 8/20/80";
#include	<stdio.h>
#include	"as.h"
#include	"assyms.h"
#include	"instrs.h"

#define	DISP16(op)	((op)-16)
#define	DISP32(op)	((op)+16)
#define	NEGOPCODE(op)	(0x6000 + ((((op)^1)-JRA) << 8))
#define	FDISP32(op)	((op)+32)

#define	s_op	s_jxfear
#define	JXOFF8	(1<<0)
#define	JXOFF16	(1<<1)
#define	JXOFF32	(1<<2)
#define	JXABS16	(1<<3)
#define	JXABS32	(1<<4)
#define	JXNABS16 (1<<5)
#define	JXNABS32 (1<<6)
#define	JXNOP	(1<<7)

/*
 *	These variables are filled by asscan.c with the
 *	last name encountered (a pointer buried in the intermediate file),
 *	and the last jxxx symbol table entry encountered.
 */
struct 	symtab	*lastnam;
struct	symtab	*lastjxxx;

/*
 *	Handle jxxx instructions
 */
ijxout(op,ap,nact)
	register unsigned short op;
	struct arg *ap;
	register short nact;
{
	register short n;

	if (passno == 1){
		/*
		 *	READ THIS BEFORE LOOKING AT jxxxfix()
		 *
		 *	Record the jxxx in a special symbol table entry
		 */
		register struct symtab *jumpfrom;

		/*
		 *	We assume the MINIMAL length
		 */
		putins(op,ap,nact); 
		jumpfrom = lastjxxx;
		jumpfrom->s_tag = JXACTIVE;
		jumpfrom->s_jxbump = (op >= FJMPS ? JXOFF16 : JXOFF8);
		jumpfrom->s_op = op;
		if (lastnam == 0)
			yyerror("jxxx destination not a label");
		jumpfrom->s_dest = lastnam;
		jumpfrom->s_type = dotp->e_xtype;	/*only TEXT or DATA*/
		jumpfrom->s_index = dotp-usedot;
		/*
		 *	value ALWAYS (ALWAYS!!!) indexes the next instruction
		 *	after the jump, even if the jump must be exploded
		 *	(bumped)
		 */
		jumpfrom->s_value = dotp->e_xvalue;
		njxxx++;
	} else {/* pass2, resolve */
		/*
		 *	READ THIS AFTER LOOKING AT jxxxfix()
		 */
		switch (lastjxxx->s_jxbump) {
		  case JXNOP:
			op = NOP;
			nact = 0;
			break;
		  case JXOFF16:		/* expand byte offset to word */
			if (op < FJMPS)
				op = DISP16(op);
			break;
		  case JXOFF32:		/* expand byte offset to long word */
			if (op >= FJMPS)
				op = FDISP32(op);
			else
				op = DISP32(op);
			break;
		  case JXNABS16:
			if (op >= FJMPS) {
				n = op - FJF;
				if (n < 15)
					/* FJEQ <=> FJNEQ */
					n = 0xF280 + (15 - n);	/* jbxxw */
				else
					/* FJ{GT,GE,LT,LE} <=> FJ{LE,LT,GE,GT} */
					n = 0xF280 + (39 - n);	/* jbxxw */
				outw(n);
				outw(8);
			} else {
				n = NEGOPCODE(op)|6;
				outw(n);
			}
			/* fall thru */
		  case JXABS16:
			ap->a_xsize = 2;
			goto abs;
		  case JXNABS32:
			if (op >= FJMPS) {
				n = op - FJF;
				if (n < 15)
					/* FJEQ <=> FJNEQ */
					n = 0xF280 + (15 - n);	/* jbxxw */
				else
					/* FJ{GT,GE,LT,LE} <=> FJ{LE,LT,GE,GT} */
					n = 0xF280 + (39 - n);	/* jbxxw */
				outw(n);
				outw(8);
			} else {
				n = NEGOPCODE(op)|6;
				outw(n);
			}
			/* fall thru */
		  case JXABS32:
			ap->a_xsize = 4;
		    abs:
			op = (op == JBSR) ? JSR : JMP;
			break;
		}
		putins(op, ap, nact);
	}
}	/*end of ijxout*/

/* FOREACH segment
/* 
/*     FOREACH active jxxx in segment
/*        IF destination is undefined
/*            CHANGE size of span to accomodate absolute external
/*            CONTINUE
/*        at this point it is known that destination is defined
/*        make sure destination is in same segment
/*    IF something changed
/*        jxxxbump the segment
/*
/*    REPEAT WHILE changing
/*        FOREACH active jxxx in segment
/*            span is the current distance from jxxx to destination
/*            IF span is too big to fit
/*                CHANGE size of span to something bigger
/*                CONTINUE
/*        IF something changed
/*            jxxxbump the segment
/* */

jxxxfix()
  {
	register struct symtab *jumpfrom, **cojumpfrom, *ubjumpfrom;
	register struct symtab *dest;
	register short segno, changing, jxext = (d124 == 4) ? JXABS32 : JXABS16;
#ifdef	DEBUG
	register count;
#endif

    for (segno = 0;  segno < NLOC + NLOC;  segno++) {

#ifdef	DEBUG
	if (debug) {
		count = 0;
		printf ("jxxxfix: segno %d\n", segno);
	}
#endif
	changing = 0;
	SEGITERATE(segno, 0, 0, cojumpfrom, jumpfrom, ubjumpfrom, ++) {
		if (jumpfrom->s_tag != JXACTIVE)
			continue;
		dest = jumpfrom->s_dest;
		if ((dest->s_type & XTYPE) == XUNDEF) {	/* check this */
			jumpfrom->s_tag = JXNOTYET;
			jumpfrom->s_jxbump |= jxext;
			changing = 1;
			continue;
		}
		if (jumpfrom->s_index != dest->s_index) {
			yyerror ("Intersegment jump");
			continue;
		}
	}
	if (changing)
		jxxxbump (segno, (struct symtab **)0);

	do {
#ifdef	DEBUG
		if (debug) {
			count++;
			printf ("	iteration #%d\n", count);
		}
#endif
		changing = 0;
		SEGITERATE(segno, 0, 0, cojumpfrom, jumpfrom, ubjumpfrom, ++) {
			register span;
			if (jumpfrom->s_tag != JXACTIVE)
				continue;
			span = jumpfrom->s_dest->s_value - jumpfrom->s_value;
			switch (jumpfrom->s_jxbump) {
			  case JXOFF8:
				if (span == 0)
					jumpfrom->s_jxbump = JXNOP;
				else if (span < MINWORD  ||  span > MAXWORD) {
					jumpfrom->s_tag = JXNOTYET;
					jumpfrom->s_jxbump = JXOFF8|JXOFF32;
					changing = 1;
				} else if (span < MINBYTE  ||  span > MAXBYTE) {
					jumpfrom->s_tag = JXNOTYET;
					jumpfrom->s_jxbump = JXOFF8|JXOFF16;
					changing = 1;
				}
				break;
			  case JXOFF16:
				if (span < MINWORD  ||  span > MAXWORD) {
					jumpfrom->s_tag = JXNOTYET;
					jumpfrom->s_jxbump = JXOFF16|JXOFF32;
					changing = 1;
				}
				break;
			}
		}
		if (changing)
			jxxxbump (segno, (struct symtab **)0);
	} while (changing);
    }
}

jxxxbump (segno, starthint)
  register short segno;
  struct symtab **starthint;
  {
	register struct symtab *sp, **cosp, *ub;
	register cum_bump = 0;

	SEGITERATE(segno, starthint, 0, cosp, sp, ub, ++) {
		if (sp->s_tag == JXNOTYET) {
			sp->s_tag = JXACTIVE;
#ifdef	DEBUG
			if (debug) switch (sp->s_jxbump) {
			  case JXOFF8|JXOFF16:
				printf ("Expanded jxxx (off8 -> off16) to %s\n",
					sp->s_dest->s_name);
				break;
			  case JXOFF8|JXOFF32:
				printf ("Expanded jxxx (off8 -> off32) to %s\n",
					sp->s_dest->s_name);
				break;
			  case JXOFF16|JXOFF32:
				printf ("Expanded jxxx (off16 -> off32) to %s\n",
					sp->s_dest->s_name);
				break;
			  case JXOFF8|JXABS16:
				switch (sp->s_op) {
				  case JRA:
				printf ("Expanded jra (off8 -> abs16) to %s\n",
					sp->s_dest->s_name);
					break;
				  case JBSR:
				printf ("Expanded jbsr (off8 -> abs16) to %s\n",
					sp->s_dest->s_name);
					break;
				  default:	/* conditional branch around */
				printf ("Expanded jxxx (off8 -> branch around abs16) to %s\n",
					sp->s_dest->s_name);
					break;
				}
				break;
			  case JXOFF8|JXABS32:
				/* fall thru */
			  case JXOFF16|JXABS32:
			  case JXABS16|JXABS32:
				switch (sp->s_op) {
				  case JRA:
				printf ("Expanded jra (off? -> abs32) to %s\n",
					sp->s_dest->s_name);
					break;
				  case JBSR:
				printf ("Expanded jbsr (off? -> abs32) to %s\n",
					sp->s_dest->s_name);
					break;
				  default:	/* conditional branch around */
				printf ("Expanded jxxx (off? -> branch around abs16) to %s\n",
					sp->s_dest->s_name);
					break;
				}
				break;
			}
#endif
			switch (sp->s_jxbump) {
			  case JXOFF8|JXOFF16:
				cum_bump += 2;
				sp->s_jxbump = JXOFF16;
				break;
			  case JXOFF8|JXOFF32:
				cum_bump += 4;
				sp->s_jxbump = JXOFF32;
				break;
			  case JXOFF16|JXOFF32:
				cum_bump += 2;
				sp->s_jxbump = JXOFF32;
				break;
			  case JXOFF8|JXABS16:
				cum_bump += 2;
				switch (sp->s_op) {
				  case JRA:
				  case JBSR:
				  case FJF:
				  case FJSF:
					sp->s_jxbump = JXABS16;
					break;
				  default:	/* conditional branch around */
					cum_bump += 2;
					if (sp->s_op >= FJMPS)
						cum_bump += 2;
					sp->s_jxbump = JXNABS16;
				}
				break;
			  case JXOFF8|JXABS32:
				cum_bump += 2;
				/* fall thru */
			  case JXOFF16|JXABS32:
			  case JXABS16|JXABS32:
				cum_bump += 2;
				switch (sp->s_op) {
				  case JRA:
				  case JBSR:
				  case FJF:
				  case FJSF:
					sp->s_jxbump = JXABS32;
					break;
				  default:  /* jump conditional to external */
					cum_bump += 2;
					if (sp->s_op >= FJMPS)
						cum_bump += 2;
					sp->s_jxbump = JXNABS32;
					break;
				}
				break;
			}
		}
		if (sp->s_tag >= OKTOBUMP)
			sp->s_value += cum_bump;
	}
	usedot[segno].e_xvalue += cum_bump;
}
