static char *rcsid = "$Header: vax.c,v 1.3 85/03/30 13:19:37 wendyt Exp $";

#include "defs.h"

#ifdef SDB
#	include <a.out.h>
extern int types2[];
#	ifndef N_SO
#		include <stab.h>
#	endif
#endif

#include "pccdefs.h"


/*
	VAX-11/780 - SPECIFIC ROUTINES
*/


int maxregvar = MAXREGVAR;
int regnum[] =  { 7, 6, 5, 4, 3, 2 } ;
int maxaregvar = MAXAREGVAR;
int aregnum[] =  { 12, 11, 10 } ;
# ifdef MC68881
int maxfregvar = MAXFREGVAR;
int fregnum[] =  { 23, 22, 21, 20, 19, 18 } ;
# endif MC68881

int usedregs = 0;
extern int retlabel;



ftnint intcon[14] =
	{ 2, 2, 2, 2,
	  15, 31, 24, 56,
	  -128, -128, 127, 127,
	  32767, 2147483647 };

/*
#if HERE == VAX
*/

# ifdef NOTDEFis
	/* then put in constants in octal */
long realcon[6][2] =
	{
		{ 0200, 0 },
		{ 0200, 0 },
		{ 037777677777, 0 },
		{ 037777677777, 037777777777 },
		{ 032200, 0 },
		{ 022200, 0 }
	};
#else
double realcon[6] =
	{
	2.9387358771e-39,
	2.938735877055718800e-39,
	1.7014117332e+38,
	1.701411834604692250e+38,
	5.960464e-8,
	1.38777878078144567e-17
	};
#endif



prsave(proflab)
int proflab;
{
p2pi("\tlink\ta6,#_F%d", procno );
p2pi("\tmoveml\t#_S%d,sp@",procno);
# ifdef MC68881
if (mc68881flag)
	p2pijk("\tfmovemx\t#_T%d,sp@(_F%d+_G%d)",procno,procno,procno);
# endif MC68881

# ifdef IEEE
if (skyflag)
	{
	p2pass("\tmovl\t_skyaddr,a4");
	p2pass("\taddql\t#4,a4");
	}
# endif IEEE

if(profileflag)
	{
	p2pi("\tmovl\t#L%d,a1\n",proflab);
	p2pi("\tjbsr\tmcount\n" );
	fprintf(asmfile,"\t.align\t1\n");
	fprintf(asmfile,"L%d:\t.long\t0\n",proflab);
	}
usedregs = 0;
}

extern int exitlabel;

goret(type)
int type;
{
p2pi("\tjra\tL%d\n",exitlabel);
}

# define MAXSLOTS 200

struct slot {
int src;
int dest;
} slots[MAXSLOTS];

LOCAL int slotcount;

/*
 * move argument slot arg1 (relative to ap)
 * to slot arg2 (relative to ARGREG)
 */

extern Addrp autovar();

mvarg(type, arg1, arg2)
int type, arg1, arg2;
{
slots[slotcount].src = arg1;
slots[slotcount++].dest = arg2;
}


fixupargs()
{
	register count,dest,inner,off;
	register Addrp q;

	for (count= 0 ; count < slotcount; count++)
		if (slots[count].src != slots[count].dest)
		{
			for (inner = count+1; inner < slotcount; inner++)
			{
				if ((dest=slots[count].dest)==slots[inner].src)
				{
					if (dest == slots[inner].dest)
						fatal("invalid arg slot");
					q = autovar(1, TYADDR, PNULL);
					off = simoffset(&(q->memoffset));
					p2pij("\tmovl\ta6@(%d),a6@(%d)",
						dest+ARGOFFSET,off);
					slots[inner].src = off-ARGOFFSET;
					break;
				}
			}
			p2pij("\tmovl\ta6@(%d),a6@(%d)",
				slots[count].src+ARGOFFSET,
				slots[count].dest+ARGOFFSET);
		}
}

move(start,src,dest)
int start,src,dest;
{
}

prlabel(fp, k)
FILEP fp;
int k;
{
fprintf(fp, "L%d:\n", k);
}



prconi(fp, type, n)
FILEP fp;
int type;
ftnint n;
{
fprintf(fp, "\t%s\t%ld\n", (type==TYSHORT ? ".word" : ".long"), n);
}



prcona(fp, a)
FILEP fp;
ftnint a;
{
fprintf(fp, "\t.long\tL%ld\n", a);
}


# ifdef NOTDEF
# ifdef IEEE

prconr(fp, type, x)
FILEP fp;
int type;
double x;
{
	union foo {
		double ddat;
		struct foo2 {
			long l1;
			long l2;
		} ldat;
	} dat;

	union foo3 {
		float fdat;
		long ldat;
	} dat2;

	if (type == TYDREAL || type == TYDCOMPLEX) {
		dat.ddat = x;
		fprintf(fp,"\t.long\t0x%x, 0x%x\n", dat.ldat.l1, dat.ldat.l2);
	}
	else {
		dat2.fdat = x;
		fprintf(fp,"\t.long\t0x%x\n", dat2.ldat);
	}
}

# else IEEE
#ifndef vax
prconr(fp, type, x)
FILEP fp;
int type;
float x;
{
fprintf(fp, "\t%s\t0f%e\n", (type==TYREAL ? ".float" : ".double"), x);
}
#endif

#ifdef vax
prconr(fp, type, x)
FILEP fp;
int type;
double x;
{
/* non-portable cheat to preserve bit patterns */
union { double xd; long int xl[2]; } cheat;
cheat.xd = x;
if(type == TYREAL)
	{float y = x; fprintf(fp, "\t.long\t0x%X\n", *(long *) &y); }
else
	fprintf(fp, "\t.long\t0x%X,0x%X\n", cheat.xl[0], cheat.xl[1]);
}
#endif
# endif IEEE

# else NOTDEF

prconr(fp, type, x)
FILEP fp;
int type;
double x;
{
	float f;

	if (type == TYDREAL || type == TYDCOMPLEX)
		fprintf(fp,"\t.long\t0x%x, 0x%x\n",*(long *)&x,*((long *)&x+1));
	else {
		f = x;
		fprintf(fp,"\t.long\t0x%x\n", *(long *)&f);
	}
}

# endif NOTDEF


praddr(fp, stg, varno, offset)
FILE *fp;
int stg, varno;
ftnint offset;
{
char *memname();

if(stg == STGNULL)
	fprintf(fp, "\t.long\t0\n");
else
	{
	fprintf(fp, "\t.long\t%s", memname(stg,varno));
	if(offset)
		fprintf(fp, "+%ld", offset);
	fprintf(fp, "\n");
	}
}




preven(k)
int k;
{
fprintf(asmfile, "\t.align\t1\n");
}




pralign(k)
int k;
{
fprintf(initfile, "\t.align\t1\n");
  return;
}



prcmgoto(index, nlab, skiplabel, labarray)
expptr index;
int nlab,labarray,skiplabel;
{
register int again;

putforce(TYINT, index);
p2pi("\tcmpl\t#%d,d0", nlab);
p2pi("\tbgt\tL%d", skiplabel);
p2pass("\ttstl\td0");
p2pi("\tble\tL%d", skiplabel);
p2pi("\tlea\tL%d-4,a0",labarray);
p2pass("\tlsll\t#2,d0");
p2pass("\tmovl\ta0@(0,d0:w),a0");
p2pass("\tjmp\ta0@");
}


prarif(p, neg, zer, pos)
expptr p;
int neg, zer, pos;
{
int type;

type = p->headblock.vtype;


putforce(type, p);

# ifdef IEEE

if (type == TYREAL ) {
	if (mc68881flag) {
		p2pass("/*ARIF*/\n\tfcmps\t#0f0.,f0");
		p2pi("\tfjlt\tL%d", neg);
		p2pi("\tfjeq\tL%d", zer);
		p2pi("\tbra\tL%d", pos);
	} else {
		p2pass("/*ARIF*/\n\tcmpl\t#0x80000000,d0");
		p2pi("\tbeq\tL%d", zer);
		p2pass("\ttstl\td0");
	}
} else if (type == TYDREAL) {
	if (mc68881flag) {
		p2pass("/*ARIF*/\n\tfcmpd\t#0d0.,f0");
		p2pi("\tfjlt\tL%d", neg);
		p2pi("\tfjeq\tL%d", zer);
		p2pi("\tbra\tL%d", pos);
	} else {
		register int tstlab;
	
		p2pass("/*ARIF*/\n\tcmpl\t#0x80000000,d0");
		p2pi("\tbne\tL%d", tstlab=newlabel());
		p2pass("\ttstl\td1");
		p2pi("\tbeq\tL%d", zer);
		p2pi("L%d:", tstlab);
		p2pass("\ttstl\td0");
	}
}
# else IEEE
if (type == TYREAL || type==TYDREAL)
	p2pass("\ttstl\td0");
# endif IEEE

else if (type == TYLONG)
	p2pass("\ttstl\td0");
else if (type == TYSHORT)
	p2pass("\ttstw\td0");
else
	p2pass("\ttstb\td0");

p2pi("\tbmi\tL%d", neg);
p2pi("\tbeq\tL%d", zer);
p2pi("\tbra\tL%d", pos);

}




char *memname(stg, mem)
int stg, mem;
{
static char s[20];

switch(stg)
	{
	case STGCOMMON:
	case STGEXT:
		sprintf(s, "_%s", varstr(XL, extsymtab[mem].extname) );
		break;

	case STGBSS:
	case STGINIT:
		sprintf(s, "v.%d", mem);
		break;

	case STGCONST:
		sprintf(s, "L%d", mem);
		break;

	case STGEQUIV:
		sprintf(s, "q.%d", mem+eqvstart);
		break;

	default:
		badstg("memname", stg);
	}
return(s);
}




prlocvar(s, len)
char *s;
ftnint len;
{
fprintf(asmfile, "\t.lcomm\t%s,%ld\n", s, len);
}




char *
packbytes(cp)
register Constp cp;
{
  static char shrt[2];
  static char lng[4];
  static char quad[8];
  static char oct[16];

  register int type;
  register int *ip, *jp;

  union foo {
    float fdat;
    long ldat;
  } dat;

  switch (cp->vtype)
    {
    case TYSHORT:
      *((short *) shrt) = (short) cp->const.ci;
      return (shrt);

    case TYLONG:
    case TYLOGICAL:
      *((int *) lng) = cp->const.ci;
      return (lng);

    case TYREAL:
#ifdef IEEE
      dat.fdat = cp->const.cd[0];
      *((int *) lng) = dat.ldat;
      return (lng);
#else IEEE
      *((int *) lng) = cp->const.ci;
      return (lng);
#endif IEEE

    case TYDREAL:
      ip = (int *) quad;
      jp = (int *) &(cp->const.cd[0]);
      ip[0] = jp[0];
      ip[1] = jp[1];
      return (quad);

    case TYCOMPLEX:
#ifdef IEEE
      ip = (int *) quad;
      dat.fdat = cp->const.cd[0];
      ip[0] = dat.ldat;
      dat.fdat = cp->const.cd[1];
      ip[1] = dat.ldat;
      return (quad);
#else IEEE
      ip = (int *) quad;
      jp = (int *) &(cp->const.cd[0]);
      ip[0] = jp[0];
      ip[1] = jp[2];
      return (quad);
#endif IEEE

    case TYDCOMPLEX:
      ip = (int *) oct;
      jp = (int *) &(cp->const.cd[0]);
      *ip++ = *jp++;
      *ip++ = *jp++;
      *ip++ = *jp++;
      *ip = *jp;
      return (oct);

    default:
      badtype("packbytes", cp->vtype);
    }
}




prsdata(s, len)
register char *s;
register int len;
{
  static char *longfmt = "\t.long\t0x%x\n";
  static char *wordfmt = "\t.word\t0x%x\n";
  static char *bytefmt = "\t.byte\t0x%x\n";

  register int i;

  i = 0;
  if ((len - i) >= 4)
    {
      fprintf(initfile, longfmt, *((int *) s));
      i += 4;
    }
  if ((len - i) >= 2)
    {
      fprintf(initfile, wordfmt, 0xffff & (*((short *) (s + i))));
      i += 2;
    }
  if ((len - i) > 0)
    fprintf(initfile,bytefmt, 0xff & s[i]);

  return;
}



prquad(s)
char *s;
{

  static char *quadfmt1 = "\t.long\t0x%x\n";

  fprintf(initfile, quadfmt1, *((int *) s));
  fprintf(initfile, quadfmt1, *((int *) (s + 4)));

  return;
}



#ifdef NOTDEF

/*  The code for generating .fill directives has been      */
/*  ifdefed out because of bugs in the UCB VAX assembler.  */
/*  If those bugs are ever fixed (and it seems unlikely),  */
/*  the NOTDEF's should be replaced by UCBVAXASM.          */


prfill(n, s)
int n;
register char *s;
{
  static char *fillfmt1 = "\t.fill\t%d,8,0x%x\n";
  static char *fillfmt2 = "\t.fill\t%d,8,0x%x%08x\n";

  if (*((int *) (s + 4)) == 0)
    fprintf(initfile, fillfmt1, n, *((int *) s));
  else
    fprintf(initfile, fillfmt2, n, *((int *) (s + 4)), *((int *) s));

  return;
}

#endif


prext(ep)
register struct Extsym *ep;
{
  static char *globlfmt = "\t.globl\t_%s\n";
  static char *commfmt = "\t.comm\t_%s,%ld\n";
  static char *spacefmt = "\t.space\t%d\n";
  static char *align2fmt = "\t.align\t1\n";
  static char *labelfmt = "_%s:\n";

  static char *seekerror = "seek error on tmp file";
  static char *readerror = "read error on tmp file";

  char *tag;
  register int leng;
  long pos;
  register int i;
  char oldvalue[8];
  char newvalue[8];
  register int n;
  register int repl;

  tag = varstr(XL, ep->extname);
  leng = ep->maxleng;

  if (leng == 0)
    {
      fprintf(asmfile, globlfmt, tag);
      return;
    }

  if (ep->init == NO)
    {
      fprintf(asmfile, commfmt, tag, leng);
      return;
    }

  fprintf(asmfile, globlfmt, tag);
  fprintf(initfile, align2fmt);
  fprintf(initfile, labelfmt, tag);

  pos = lseek(cdatafile, ep->initoffset, 0);
  if (pos == -1)
    {
      err(seekerror);
      done(1);
    }

  *((int *) oldvalue) = 0;
  *((int *) (oldvalue + 4)) = 0;
  n = read(cdatafile, oldvalue, 8);
  if (n < 0)
    {
      err(readerror);
      done(1);
    }

  if (leng <= 8)
    {
      i = leng;
      while (i > 0 && oldvalue[--i] == '\0') /* SKIP */;
      if (oldvalue[i] == '\0')
	fprintf(initfile, spacefmt, leng);
      else if (leng == 8)
	prquad(oldvalue);
      else
	prsdata(oldvalue, leng);

      return;
    }

  repl = 1;
  leng -= 8;

  while (leng >= 8)
    {
      *((int *) newvalue) = 0;
      *((int *) (newvalue + 4)) = 0;

      n = read(cdatafile, newvalue, 8);
      if (n < 0)
	{
	  err(readerror);
	  done(1);
	}

      leng -= 8;

      if (*((int *) oldvalue) == *((int *) newvalue)
	  && *((int *) (oldvalue + 4)) == *((int *) (newvalue + 4)))
	repl++;
      else
	{
	  if (*((int *) oldvalue) == 0
	      && *((int *) (oldvalue + 4)) == 0)
	    fprintf(initfile, spacefmt, 8*repl);
	  else if (repl == 1)
	    prquad(oldvalue);
	  else
#ifdef NOTDEF
	    prfill(repl, oldvalue);
#else
	    {
	      while (repl-- > 0)
		prquad(oldvalue);
	    }
#endif
	  *((int *) oldvalue) = *((int *) newvalue);
	  *((int *) (oldvalue + 4)) = *((int *) (newvalue + 4));
	  repl = 1;
	}
    }

  *((int *) newvalue) = 0;
  *((int *) (newvalue + 4)) = 0;

  if (leng > 0)
    {
      n = read(cdatafile, newvalue, leng);
      if (n < 0)
	{
	  err(readerror);
	  done(1);
	}
    }

  if (*((int *) (oldvalue + 4)) == 0
      && *((int *) oldvalue) == 0
      && *((int *) (newvalue + 4)) == 0
      && *((int *) newvalue) == 0)
    {
      fprintf(initfile, spacefmt, 8*repl + leng);
      return;
    }

  if (*((int *) (oldvalue + 4)) == 0
      && *((int *) oldvalue) == 0)
    fprintf(initfile, spacefmt, 8*repl);
  else if (repl == 1)
    prquad(oldvalue);
  else
#ifdef NOTDEF
    prfill(repl, oldvalue);
#else
    {
      while (repl-- > 0)
	prquad(oldvalue);
    }
#endif

  prsdata(newvalue, leng);

  return;
}



prlocdata(sname, leng, type, initoffset, inlcomm)
char *sname;
ftnint leng;
int type;
long initoffset;
char *inlcomm;
{
  static char *seekerror = "seek error on tmp file";
  static char *readerror = "read error on tmp file";

  static char *labelfmt = "%s:\n";
  static char *spacefmt = "\t.space\t%d\n";

  register int k;
  register int i;
  register int repl;
  register int first;
  register long pos;
  register long n;
  char oldvalue[8];
  char newvalue[8];

  *inlcomm = NO;

  k = leng;
  first = YES;

  pos = lseek(vdatafile, initoffset, 0);
  if (pos == -1)
    {
      err(seekerror);
      done(1);
    }

  *((int *) oldvalue) = 0;
  *((int *) (oldvalue + 4)) = 0;
  n = read(vdatafile, oldvalue, 8);
  if (n < 0)
    {
      err(readerror);
      done(1);
    }

  if (k <= 8)
    {
      i = k;
      while (i > 0 && oldvalue[--i] == '\0')
	/*  SKIP  */ ;
      if (oldvalue[i] == '\0')
	{
	  if (SMALLVAR(leng))
	    {
	      pralign(typealign[type]);
	      fprintf(initfile, labelfmt, sname);
	      fprintf(initfile, spacefmt, leng);
	    }
	  else
	    {
	      preven(ALIDOUBLE);
	      prlocvar(sname, leng);
	      *inlcomm = YES;
	    }
	}
      else
	{
	  fprintf(initfile, labelfmt, sname);
	  if (leng == 8)
	    prquad(oldvalue);
	  else
# ifndef BOZO
	    prsdata(oldvalue, leng);
# else BOZO
	    {
	    if (type == TYREAL)
	        {
	        * (float *)newvalue = * (double *)oldvalue;
	        prsdata(newvalue, leng);
	        }
	    else
	        prsdata(oldvalue, leng);
	    }
# endif BOZO
	}
      return;
    }

  repl = 1;
  k -= 8;

  while (k >=8)
    {
      *((int *) newvalue) = 0;
      *((int *) (newvalue + 4)) = 0;

      n = read(vdatafile, newvalue, 8);
      if (n < 0)
	{
	  err(readerror);
	  done(1);
	}

      k -= 8;

      if (*((int *) oldvalue) == *((int *) newvalue)
	  && *((int *) (oldvalue + 4)) == *((int *) (newvalue + 4)))
	repl++;
      else
	{
	  if (first == YES)
	    {
	      pralign(typealign[type]);
	      fprintf(initfile, labelfmt, sname);
	      first = NO;
	    }

	  if (*((int *) oldvalue) == 0
	      && *((int *) (oldvalue + 4)) == 0)
	    fprintf(initfile, spacefmt, 8*repl);
	  else
	    {
	      while (repl-- > 0)
		prquad(oldvalue);
	    }
	  *((int *) oldvalue) = *((int *) newvalue);
	  *((int *) (oldvalue + 4)) = *((int *) (newvalue + 4));
	  repl = 1;
	}
    }

  *((int *) newvalue) = 0;
  *((int *) (newvalue + 4)) = 0;

  if (k > 0)
    {
      n = read(vdatafile, newvalue, k);
      if (n < 0)
	{
	  err(readerror);
	  done(1);
	}
    }

  if (*((int *) (oldvalue + 4)) == 0
      && *((int *) oldvalue) == 0
      && *((int *) (newvalue + 4)) == 0
      && *((int *) newvalue) == 0)
    {
      if (first == YES && !SMALLVAR(leng))
	{
	  prlocvar(sname, leng);
	  *inlcomm = YES;
	}
      else
	{
	  if (first == YES)
	    {
	      pralign(typealign[type]);
	      fprintf(initfile, labelfmt, sname);
	    }
	  fprintf(initfile, spacefmt, 8*repl + k);
	}
      return;
    }

  if (first == YES)	
    {
      pralign(typealign[type]);
      fprintf(initfile, labelfmt, sname);
    }

  if (*((int *) (oldvalue + 4)) == 0
      && *((int *) oldvalue) == 0)
    fprintf(initfile, spacefmt, 8*repl);
  else
    {
      while (repl-- > 0)
	prquad(oldvalue);
    }

# ifdef BOZO
  if (type == TYREAL && k == 4)
     {
     * (float *)oldvalue = * (double *)newvalue;
     prsdata(oldvalue, k);
     }
  else
      prsdata(newvalue, k);
# else BOZO

  prsdata(newvalue, k);
# endif BOZO

  return;
}
	    



prendproc()
{
}




prtail()
{
}


prolog(ep, argvec)
struct Entrypoint *ep;
Addrp  argvec;
{
int i, argslot, proflab;
int size;
register chainp p;
register Namep q;
register struct Dimblock *dp;
expptr tp;

if(procclass == CLMAIN) {
	if(fudgelabel)
		{
		if(ep->entryname) {
			p2ps("_%s:",  varstr(XL, ep->entryname->extname));
		}
		putlabel(fudgelabel);
		fudgelabel = 0;
		fixlwm();
		}
	else
		p2pass( "_MAIN_:" );

} else if(ep->entryname)
	if(fudgelabel)
		{
		putlabel(fudgelabel);
		fudgelabel = 0;
		fixlwm();
		}
	else
		{
		p2ps("_%s:",  varstr(XL, ep->entryname->extname));
		prsave(newlabel());
		}

if(procclass == CLBLOCK)
	return;

if (anylocals == YES)
	{
	char buff[30];
	sprintf(buff, "\tmovl\t#v.%d,a5", bsslabel);
	p2pass(buff);
	}

if(argvec)
	{
	slotcount = 0;
	if (argvec->tag != TADDR) badtag ("prolog",argvec->tag);
	argloc = -argvec->memoffset->constblock.const.ci + SZINT;
			/* first slot holds count */
# ifdef BOZO
	p2pi("\tmovl\t#%d,a6@\n", lastargslot/SZADDR);
# endif BOZO
	if(proctype == TYCHAR)
		{
		mvarg(TYADDR, 0, chslot);
		mvarg(TYLENG, SZADDR, chlgslot);
		argslot = SZADDR + SZLENG;
		}
	else if( ISCOMPLEX(proctype) )
		{
		mvarg(TYADDR, 0, cxslot);
		argslot = SZADDR;
		}
	else
		argslot = 0;

	for(p = ep->arglist ; p ; p =p->nextp)
		{
		q = (Namep) (p->datap);
		mvarg(TYADDR, argslot, q->vardesc.varno);
		argslot += SZADDR;
		}
	for(p = ep->arglist ; p ; p = p->nextp)
		{
		q = (Namep) (p->datap);
		if(q->vtype==TYCHAR && q->vclass!=CLPROC)
			{
			if(q->vleng && ! ISCONST(q->vleng) )
				mvarg(TYLENG, argslot,
					q->vleng->addrblock.memno);
			argslot += SZLENG;
			}
		}
	fixupargs();
	}

for(p = ep->arglist ; p ; p = p->nextp)
	{
	q = (Namep) (p->datap);
	if(dp = q->vdim)
		{
		for(i = 0 ; i < dp->ndim ; ++i)
			if(dp->dims[i].dimexpr)
				puteq( fixtype(cpexpr(dp->dims[i].dimsize)),
					fixtype(cpexpr(dp->dims[i].dimexpr)));
#ifdef SDB
                if(sdbflag) {
		for(i = 0 ; i < dp->ndim ; ++i) {
			if(dp->dims[i].lbaddr)
				puteq( fixtype(cpexpr(dp->dims[i].lbaddr)),
					fixtype(cpexpr(dp->dims[i].lb)));
			if(dp->dims[i].ubaddr)
				puteq( fixtype(cpexpr(dp->dims[i].ubaddr)),
					fixtype(cpexpr(dp->dims[i].ub)));
		    
                                                }
                            }
#endif
		size = typesize[ q->vtype ];
		if(q->vtype == TYCHAR)
			if( ISICON(q->vleng) )
				size *= q->vleng->constblock.const.ci;
			else
				size = -1;

		/* get more efficient subscripting if subscripts
		   have zero-base, so fudge the argument pointers for arrays.
		   Not done if array bounds are being checked.
		*/
		if(dp->basexpr)
			puteq( 	cpexpr(fixtype(dp->baseoffset)),
				cpexpr(fixtype(dp->basexpr)));
#ifdef SDB
		if( (! checksubs) && (! sdbflag) )
#else
		if(! checksubs)
#endif
			{
			if(dp->basexpr)
				{
				if(size > 0)
					tp = (expptr) ICON(size);
				else
					tp = (expptr) cpexpr(q->vleng);
				putforce(TYINT,
					fixtype( mkexpr(OPSTAR, tp,
						cpexpr(dp->baseoffset)) ));
				p2pi("\tsubl\td0,a6@(%d)",
					p->datap->nameblock.vardesc.varno +
						ARGOFFSET);
				}
			else if(dp->baseoffset->constblock.const.ci != 0)
				{
				char buff[25];
				if(size > 0)
					{
					sprintf(buff, "\tsubl\t#%ld,a6@(%d)",
						dp->baseoffset->constblock.const.ci * size,
						p->datap->nameblock.vardesc.varno +
							ARGOFFSET);
					}
				else	{
					putforce(TYINT, mkexpr(OPSTAR, cpexpr(dp->baseoffset),
						cpexpr(q->vleng) ));
					sprintf(buff, "\tsubl\td0,a6@(%d)",
						p->datap->nameblock.vardesc.varno +
							ARGOFFSET);
					}
				p2pass(buff);
				}
			}
		}
	}

putgoto(ep->entrylabel);
}

fixlwm()
{
	extern lwmno;
	if (lwmno == procno)
		return;
	lwmno = procno;
}

prhead(fp)
FILEP fp;
{
#if FAMILY==PCC
/*
**	Note: if DISABLEARRAYREG (or whatever it is) is ever undefined
**	in regalloc.c, something will have to be done here to pass the
**	correct naregs to local2.c (via fort.c). For now, it is hardwired
**	in as 4.  -Wendy T-
*/
	p2triple(P2LBRACKET, (7-highregvar), procno);
	p2word( (long) (BITSPERCHAR*autoleng) );
# ifdef MC68881
	p2word( (MAXAREGVAR-higharegvar)|((MAXFREGVAR-highfregvar)<<8) );
# else MC68881
	p2word( (MAXAREGVAR-higharegvar) );
# endif MC68881
	p2flush();
#endif
}
