#include "../h/ashelp.h"
#include "../h/ucode.h"
/*#define UCODE_DEBUG /**/

/******************************************************************************
* UCoutput(n, p1, p2, ... pn ):  Loads n parameters into the micro-coded 
*	graphics image procesor. This version assumes a FIFO empty bit but no 
*	FIFO empty interrupt. If the whole command could overflow the FIFO, the
*	process waits in a loop until the FIFO is not full before writing.
*
* C Interface:
*	UCoutput(n, p1, p2, ... pn )
*	int nparms;
*	int p1, p2, p3;
*
* Assembly Interface:
*	+---------------------------------+
*	| nparms                          |  0 (L)
*	+---------------------------------+
*	|////////////////| p1             |  6 (W)
*	+---------------------------------+
*	|////////////////| p2             | 10 (W)
*	+---------------------------------+
*			.
*	+---------------------------------+
*	|////////////////| pn             | ((4 * n) + 2) (W)
*	+---------------------------------+
*
* C Return:
* Assembly Return:
*	all registers returned as passed
******************************************************************************/
	.globl	_UCoutput
	.globl	_UCflevel
	.data
_UCflevel:	.long	0	/* current max FIFO fill */
#ifdef	UCODE_DEBUG
	.globl	_UCnbusy
	.globl	_UCbusycnt
	.globl	_UCnring
_UCnbusy:	.long	0	/* number of times FIFO could be 'full' */
_UCbusycnt:	.long	0	/* loop count when 'full', waiting for empty */
_UCnring:	.long	0	/* number of times empty ~empty */
ostr:		.asciz	"O"
#endif UCODE_DEBUG

	.text
_UCoutput:
	/* Setup stack frame */
	link	a6,#0			/* establish frame pointer */
	moveml	#D0_D1_A0_A1_,sp@-	/* save registers */
	movb	#0,_CPUdisplay		/* mark GIP access */

	/* Setup registers for loading fifo */
	movl	_gpaddr,a1		/* fifo pointer */
	movl	a6,a0
	addl	#8,a0			/* generate parameter pointer */
	movl	a0@+,d0			/* get parameter count */
	addl	#2,a0			/* adjust for word */

	movl	d0,d1
	addl	_UCflevel,d1
	movl	d1,_UCflevel
	subl	#GPFIFOMAX-2,d1		/* leave some slack */
	jlt	3f

#ifdef	UCODE_DEBUG
	addl	#1,_UCnbusy		/* incr number of busy waits */
	jra	2f
    1:	addl	#1,_UCnring		/* number of debounce */
    2:	addl	#1,_UCbusycnt		/* incr total loop counts */
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	2b
#else	UCODE_DEBUG
    1:	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	1b
#endif	UCODE_DEBUG
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	1b
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	1b
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	1b
	movw	a1@,d1;btst	#GPFIFOEMPTY,d1; jeq	1b
	movl	d0,_UCflevel
	jra	3f

    1:	movw	a0@,a1@			/* load fifo */
	addl	#4,a0
    3:	dbf	d0,1b			/* test for done */

	/* Clean up stack and return */
	moveml	sp@+,#_D0_D1_A0_A1	/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */

#ifdef UCODE_DEBUG
/******************************************************************
*
* prgipout
*	print output sent to the GIP
*
*	input:
*		a0 = pointer to the word to be sent
*	output:
*		all registers saved
*
********************************************************************/

	.data
fmtstr:	.asciz	">%x"

	.text
prgipout:
	moveml	#0xFFFF,sp@-	/* save */
	movw	a0@,sp@-	/* push word */
	clrw	sp@-		/* long align */
	movl	#fmtstr,sp@-	/* push format string */
	jsr	_printf		/* print it */
	addl	#8,sp		/* fix stack */
	moveml	sp@+,#0xFFFF	/* restore */
	rts
#endif UCODE_DEBUG
