
#include "../h/ucode.h"
#include "../h/ashelp.h"

/*******************************************************************************
* CPUgetdisp: Get control of the graphics display memory for the CPU.
*	Check accessability of the display memory and loop until available
* Assembly Interface:
*	input:	no parameters
*	output:	all registers saved
*******************************************************************************/

	.globl	_CPUgetdisp
	.globl	_CPUdisplay
	.data
_CPUdisplay:	.byte	0
#ifdef	UCODE_DEBUG
	.globl	_CPUnbusy
	.globl	_CPUbusycnt
	.globl	_CPUrbusy
_CPUnbusy:	.long	0		/* number of times FIFO was busy */
_CPUbusycnt:	.long	0		/* total loop count when busy */
_CPUrbusy:	.long	0	
#endif	UCODE_DEBUG

	.text
_CPUgetdisp:
	tstb	_CPUdisplay		/* do we already have it ? */
	jne	3f			/* jump if yes */
	moveml	#D0_A0_,sp@-		/* save */
	movl	_gpaddr,a0		/* get fifo pointer */
	movw	#GP_INTOF,a0@		/* send interrupt off cmd */

/*	movl	#0x8,d0			/* KLUDGE 68010 constant */
	movl	#0x64,d0		/* 68020 constant */
    1:	dbf	d0,1b			/* 2usec, fifo trickle */
#ifdef	UCODE_DEBUG
	addl	#1,_CPUnbusy		/* incr number of busy waits */
	jra	2f
    1:	addl	#1,_CPUrbusy		/* incr number of busy waits */
    2:	addl	#1,_CPUbusycnt		/* incr total loop counts */
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	2b /* wait till empty */
#else	UCODE_DEBUG
    1:	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	1b /* wait till empty */
#endif	UCODE_DEBUG
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	1b
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	1b
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	1b
	movw	a0@,d0;btst	#GPFIFOEMPTY,d0; beq	1b
	movl	#0,_UCflevel		/* fifo is now empty */
	movb	#1,_CPUdisplay		/* mark CPU access */
	moveml	sp@+,#_D0_A0		/* restore */
    3:	rts				/* return */

#ifdef	UCODE_DEBUG
/*******************************************************************************
* CPUrlsdisp:	Release control of the graphics display memory by the CPU
* Assembly Interface:
*	input:	no parameters
*	output:	all registers saved
*******************************************************************************/
	.globl	_CPUrlsdisp
_CPUrlsdisp:
	movb	#0,_CPUdisplay		/* mark CPU access done */
	rts
#endif	UCODE_DEBUG
