#include "../h/ucode.h"

/******************************************************************************
* paint
*
* Paints a rectangular region with upper left corner at (Xs,Ys)
*	relative to the destination raster address
*	with given width and height. Bits in the rectangle are set,
*	cleared or complemented depending upon the current alu mode
*	if the corresponding bit in the mask rectangle is set.
*	The mask has upper left corner at (Xs,Ys) 
*	relative to the source raster address.
*	Width and height applies to both rectangles.
*
* Assembly Interface:
*	input:
*		d0 = Xs
*		d1 = Ys
*		d2 = width
*		d3 = height
*		d4 = Xd
*		d5 = Yd
*		a2 = source raster address
*		a3 = destination raster address
*	output:
*		all registers saved
*
******************************************************************************/

	.globl	paint
	.text
paint:	movl	d6,sp@-			/* save */
	movl	#GP_PAINT,d6		/* box copy command */
	jsr	cmd_sdrast		/* do raster command */
	movl	sp@+,d6			/* resore */
	rts
