#ifdef COLOR
#include "../h/ucode.h"

/******************************************************************************
* set_color
*
* Check and set the current color
*
* Assembly Interface:
*	input:
*		d0 = new color
*	output:
*		all registers are saved
*
******************************************************************************/

	.globl	set_color

	.data
UCscolor:
	.word	0			/* save last src pitch */

	.text
set_color:
	cmpw	UCscolor,d0		/* check for already set */
	beq	1f			/* skip load if so */
	movw	d0,UCscolor		/* save color */

	movl	d0,sp@-			/* load color */
	movl	#GP_SCOLOR,sp@-		/* set color command */
	movl	#2,sp@-			/* number of paramters */
	jsr	_UCoutput		/* execute */
	addl	#12,sp			/* clear stack */
1:	rts
#endif COLOR
