#include "../h/ashelp.h"

/******************************************************************************
* cmd_sdrast
*
* Assemble parameters for commands using source and destination raster
*	Currently only "boxc", "boxp" and "paint"
*
* Assembly Interface:
*	input:
*		d0 = Xs
*		d1 = Ys
*		d2 = width
*		d3 = height
*		d4 = Xd
*		d5 = Yd
*		d6 = BOXC, BOXP or PAINT command
*		a2 = source raster address
*		a3 = destination raster address
*	output:
*		all registers saved
*
******************************************************************************/

	.globl	cmd_sdrast
	.text
cmd_sdrast:
	moveml	#D2_D3_A3_,sp@-		/* save registers */
	movl	d3,sp@-			/* height */
	movl	d2,sp@-			/* width */
	movl	d5,sp@-			/* Yd */
	movl	d4,sp@-			/* Xd */
	jsr	UCaddr			/* dest raster d2 hi, d3 lo */
	movl	d3,sp@-			/* dest_l */
	movl	d2,sp@-			/* dest_h */
	movl	d1,sp@-			/* Ys */
	movl	d0,sp@-			/* Xs */
	movl	a2,a3			/* src raster address */
	jsr	UCaddr			/* src raster d2 hi, d3 lo */
	movl	d3,sp@-			/* src_l */
	movl	d2,sp@-			/* src_h */
	movl	d6,sp@-			/* command */
	movl	#11,sp@-		/* number of paramters */
	jsr	_UCoutput		/* execute */
	addl	#48,sp			/* clear stack */
	moveml	sp@+,#_D2_D3_A3		/* restore registers */
	rts
