/******************************************************************************
* cmd_drast
*
* Assemble parameters for commands using destination raster only
*	Currently only "box" and "vector"
*
* Assembly Interface:
*	input:
*		a3 = raster address
*		d0 = X
*		d1 = Y
*		d2 = width or X1
*		d3 = height or Y1
*		d4 = BOX or VECT command
*	output:
*		d2, d3 used
*		rest saved
*
******************************************************************************/

	.globl	cmd_drast
	.text
cmd_drast:
	movl	d3,sp@-			/* height or Y1 */
	movl	d2,sp@-			/* width or X1 */
	movl	d1,sp@-			/* Y */
	movl	d0,sp@-			/* X */
	jsr	UCaddr			/* d2 hi, d3 lo */
	movl	d3,sp@-			/* dest_l */
	movl	d2,sp@-			/* dest_h */
	movl	d4,sp@-			/* command */
	movl	#7,sp@-			/* number of paramters */
	jsr	_UCoutput		/* execute */
	addl	#32,sp			/* clear stack */
	rts
