#include "../h/ucode.h"

/******************************************************************************
* boxp
*
* Draws a 32 X 32 pattern located at the source raster address
*	into a rectangular region with upper left corner at (Xd,Yd)
*	from the destination raster address and given width and height. 
*	(Xs,Ys) specify a starting phase coordinate.
*
* Assembly Interface:
*	input:
*		d0 = Xs
*		d1 = Ys
*		d2 = width
*		d3 = height
*		d4 = Xd
*		d5 = Yd
*		a2 = source raster address
*		a3 = destination raster address
*	output:
*		all registers saved
*
******************************************************************************/

	.globl	boxp
	.text
boxp:	movl	d6,sp@-			/* save */
	movl	#GP_BOXP,d6		/* box pattern command */
	jsr	cmd_sdrast		/* do raster command */
	movl	sp@+,d6			/* restore */
	rts
