/******************************************************************************
* Within(r, x, y)
*
* Returns true if and only if the point ("x", "y") is within rectangle "r".
*
* C Interface:
*
*	bool Within(r, x, y)
*	struct rectangle r;
*	int x, y;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| r.x            | r.y            |  0 (W), 2 (W)
*	+---------------------------------+
*	| r.w            | r.h            |  4 (W), 6 (W)
*	+---------------------------------+
*	|////////////////| x              | 10 (W)
*	+---------------------------------+
*	|////////////////| y              | 14 (W)
*	+---------------------------------+
*
******************************************************************************/

rx	= 0+8
ry	= 2+8
rw	= 4+8
rh	= 6+8
x	= 10+8
y	= 14+8

	.globl	_Within
	.text
_Within:
	link	a6,#0			/* establish stack frame */

	movw	a6@(x),d0		/* get X coordinate of point */
	subw	a6@(rx),d0		/* compute distance from left edge */
	blt	1f			/* return false if too far left */
	cmpw	a6@(rw),d0		/* check against right edge */
	bge	1f			/* return false if too far right */

	movw	a6@(y),d0		/* get Y coordinate of point */
	subw	a6@(ry),d0		/* compute distance from top edge */
	blt	1f			/* return false if too high */
	cmpw	a6@(rh),d0		/* check against bottom edge */
	bge	1f			/* return false if too low */

	moveq	#1,d0			/* get value for true */
	unlk	a6			/* remove stack frame */
	rts				/* return it */
	
    1:	clrl	d0			/* get value for false */
	unlk	a6			/* remove stack frame */
	rts				/* return it */
