#include "../h/ashelp.h"

/******************************************************************************
* Union(result, r1, r2)
*
* Returns the union of rectangles "r1" and "r2".
*
* C Interface:
*
*	void Union(result, r1, r2)
*	struct rectangle *result, r1, r2;
*
* Assembly Interface:
*
*	+---------------------------------+
*	| result			  |  0 (L)
*	+---------------------------------+
*	| r1.x           | r1.y           |  4 (W), 6 (W)
*	+---------------------------------+
*	| r1.w           | r1.h           |  8 (W), 10 (W)
*	+---------------------------------+
*	| r2.x           | r2.y           | 12 (W), 14 (W)
*	+---------------------------------+
*	| r2.w           | r2.h           | 16 (W), 18 (W)
*	+---------------------------------+
*
******************************************************************************/

ans	= 0+8
r1x	= 4+8
r1y	= 6+8
r1w	= 8+8
r1h	= 10+8
r2x	= 12+8
r2y	= 14+8
r2w	= 16+8
r2h	= 18+8

	.globl	_Union
	.text
_Union:	link	a6,#0			/* set up stack frame */
	moveml	#D1_D7_,sp@-		/* save registers */
	movemw	a6@(r1x),#_D0_D7	/* blast rectangles in */

	addw	d0,d2			/* compute upper X of first rectangle */
	addw	d4,d6			/* compute upper X of second rectangle */

	cmpw	d4,d0			/* compare lower X's */
	ble	1f			/* branch if first is smaller */
	movw	d4,d0			/* put smaller value in D0 */

    1:	cmpw	d6,d2			/* compare upper X's */
	bge	2f			/* branch if first is larger */
	movw	d6,d2			/* put larger value in D2 */

    2:	subw	d0,d2			/* compute width of union */

	addw	d1,d3			/* compute upper Y of first rectangle */
	addw	d5,d7			/* compute upper Y of second rectangle */

	cmpw	d5,d1			/* compare lower Y's */
	ble	3f			/* branch if first is smaller */
	movw	d5,d1			/* put smaller value in D1 */

    3:	cmpw	d7,d3			/* compare upper Y's */
	bge	4f			/* branch if first is larger */
	movw	d7,d3			/* put larger value in D3 */

    4:	subw	d1,d3			/* compute height of intersection */

	movl	a6@(ans),a0		/* get the address of the result */
	movemw	#_D0_D3,a0@		/* blast result out */
	moveml	sp@+,#_D1_D7		/* restore registers */
	unlk	a6			/* remove stack frame */
	rts				/* return */
